/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.scattersphere.api.ClientConnection;
import net.scattersphere.api.ClientConnectionState;
import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.data.message.JobParametersMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private Consumer<String> onConnect = null;
    private Consumer<String> onDisconnect;
    private BiConsumer<String, JobMessage> onMessage;
    private final Logger LOG = LoggerFactory.getLogger(Client.class);
    private Map<String, ClientConnectionPair> connections = new HashMap<String, ClientConnectionPair>();

    public void addClient(String clientName, String clientAddress) {
        Objects.requireNonNull(clientName);
        Objects.requireNonNull(clientAddress);
        ClientConnectionPair clientConnectionPair = new ClientConnectionPair(clientName, clientAddress);
        clientConnectionPair.connect();
        this.connections.put(clientName, clientConnectionPair);
    }

    public ClientConnection getClientConnection(String clientName) {
        Objects.requireNonNull(clientName);
        if (this.connections.get(clientName) == null) {
            throw new NullPointerException("Connection for client by name does not exist: " + clientName);
        }
        return this.connections.get(clientName).getClientConnection();
    }

    public void listJobs(String clientName) {
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])new JobMessage("LIST").toByteArray()));
    }

    public void listJobs(String clientName, String jobType) {
        JobParametersMessage parameters = new JobParametersMessage(jobType, new String[0]);
        JobMessage message = new JobMessage("LIST", parameters.toByteArray());
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])message.toByteArray()));
    }

    public void startJob(String clientName, String jobName, String[] arguments) {
        JobParametersMessage parameters = new JobParametersMessage(jobName, arguments);
        JobMessage message = new JobMessage("START", parameters.toByteArray());
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])message.toByteArray()));
    }

    public void stopJob(String clientName, String jobId, String reason) {
        JobParametersMessage parameters = new JobParametersMessage(jobId, reason, null);
        JobMessage message = new JobMessage("STOP", parameters.toByteArray());
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])message.toByteArray()));
    }

    public void statusJob(String clientName, String jobId) {
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])new JobMessage("STATUS", jobId).toByteArray()));
    }

    public void onConnect(Consumer<String> function) {
        this.onConnect = function;
    }

    public void onDisconnect(Consumer<String> function) {
        this.onDisconnect = function;
    }

    public void onMessage(BiConsumer<String, JobMessage> function) {
        this.onMessage = function;
    }

    public void send(String clientName, JobMessage message) {
        this.connections.get(clientName).getClientConnection().sendMessage(message.toByteArray());
    }

    private class ClientConnectionPair {
        private String host;
        private String pairName;
        private ClientConnection client;

        public ClientConnectionPair(String pairName, String host) {
            this.pairName = pairName;
            this.host = host;
            this.client = new ClientConnection();
        }

        public String getHost() {
            return this.host;
        }

        public void connect() {
            this.client.onConnect(x -> {
                if (x == ClientConnectionState.CONNECTED) {
                    Client.this.onConnect.accept(this.pairName);
                    Client.this.LOG.info("New connection state: {}", (Object)x);
                }
                if (x == ClientConnectionState.CLOSED) {
                    Client.this.onDisconnect.accept(this.pairName);
                    Client.this.LOG.info("Connection closed: {}", (Object)x);
                }
                if (x == ClientConnectionState.FAILED) {
                    Client.this.onDisconnect.accept(this.pairName);
                    Client.this.LOG.info("Connection failed: {}", (Object)this.host);
                }
            }).messageReceived(msg -> Client.this.onMessage.accept(this.pairName, msg)).connect(this.host);
        }

        public ClientConnection getClientConnection() {
            return this.client;
        }
    }
}

