/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.output;

import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.sansa_stack.spark.io.rdf.output.RdfPostProcessingSettingsBase;
import net.sansa_stack.spark.io.rdf.output.RdfPostProcessingSettingsMutable;
import org.aksw.commons.io.util.StdIo;
import org.aksw.jenax.arq.util.lang.RDFLanguagesEx;
import org.apache.hadoop.fs.Path;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;

public class RddRdfWriterSettings<SELF extends RddRdfWriterSettings> {
    protected Path partitionFolder;
    protected Path targetFile;
    protected boolean useCoalesceOne;
    protected boolean deletePartitionFolderAfterMerge;
    protected PrefixMapping globalPrefixMapping;
    protected RDFFormat outputFormat;
    protected boolean allowOverwriteFiles;
    protected boolean useElephas;
    protected boolean partitionsAsIndependentFiles;
    protected boolean mapQuadsToTriplesForTripleLangs;
    protected RdfPostProcessingSettingsMutable postProcessingSettings = new RdfPostProcessingSettingsBase();
    protected long deferOutputForUsedPrefixes = 0L;
    protected Supplier<OutputStream> consoleOutSupplier = StdIo::openStdOutWithCloseShield;

    public boolean isMapQuadsToTriplesForTripleLangs() {
        return this.mapQuadsToTriplesForTripleLangs;
    }

    protected SELF self() {
        return (SELF)this;
    }

    public SELF configureFrom(RddRdfWriterSettings<?> other) {
        this.partitionFolder = other.partitionFolder;
        this.targetFile = other.targetFile;
        this.useCoalesceOne = other.useCoalesceOne;
        this.deletePartitionFolderAfterMerge = other.deletePartitionFolderAfterMerge;
        this.globalPrefixMapping = other.globalPrefixMapping;
        this.outputFormat = other.outputFormat;
        this.allowOverwriteFiles = other.allowOverwriteFiles;
        this.useElephas = other.useElephas;
        this.partitionsAsIndependentFiles = other.partitionsAsIndependentFiles;
        this.mapQuadsToTriplesForTripleLangs = other.mapQuadsToTriplesForTripleLangs;
        this.deferOutputForUsedPrefixes = other.deferOutputForUsedPrefixes;
        this.consoleOutSupplier = other.consoleOutSupplier;
        this.postProcessingSettings.copyFrom(other.postProcessingSettings);
        return this.self();
    }

    public SELF setMapQuadsToTriplesForTripleLangs(boolean mapQuadsToTriplesForTripleLangs) {
        this.mapQuadsToTriplesForTripleLangs = mapQuadsToTriplesForTripleLangs;
        return this.self();
    }

    public boolean isUseCoalesceOne() {
        return this.useCoalesceOne;
    }

    public void setUseCoalesceOne(boolean useCoalesceOne) {
        this.useCoalesceOne = useCoalesceOne;
    }

    public boolean isDeletePartitionFolderAfterMerge() {
        return this.deletePartitionFolderAfterMerge;
    }

    public SELF setDeletePartitionFolderAfterMerge(boolean deletePartitionFolderAfterMerge) {
        this.deletePartitionFolderAfterMerge = deletePartitionFolderAfterMerge;
        return this.self();
    }

    public PrefixMapping getGlobalPrefixMapping() {
        return this.globalPrefixMapping;
    }

    public Path getPartitionFolder() {
        return this.partitionFolder;
    }

    public SELF setPartitionFolder(Path partitionFolder) {
        this.partitionFolder = partitionFolder;
        return this.self();
    }

    public SELF setPartitionFolder(String partitionFolder) {
        return this.setPartitionFolder(partitionFolder == null ? null : new Path(partitionFolder));
    }

    public Path getTargetFile() {
        return this.targetFile;
    }

    public SELF setTargetFile(Path targetFile) {
        this.targetFile = targetFile;
        return this.self();
    }

    public SELF setTargetFile(String targetFile) {
        return this.setTargetFile(targetFile == null ? null : new Path(targetFile));
    }

    public SELF setGlobalPrefixMapping(PrefixMapping globalPrefixMapping) {
        this.globalPrefixMapping = globalPrefixMapping;
        return this.self();
    }

    public SELF setGlobalPrefixMapping(Map<String, String> globalPrefixMap) {
        PrefixMappingImpl pm = new PrefixMappingImpl();
        pm.setNsPrefixes(globalPrefixMap);
        this.setGlobalPrefixMapping((PrefixMapping)pm);
        return this.self();
    }

    public RDFFormat getOutputFormat() {
        return this.outputFormat;
    }

    public SELF setOutputFormat(RDFFormat format) {
        this.outputFormat = format;
        return this.self();
    }

    public SELF setOutputFormat(String formatName) {
        RDFFormat fmt = formatName == null ? null : Optional.ofNullable(RDFLanguagesEx.findRdfFormat((String)formatName)).orElseThrow(() -> new IllegalArgumentException("Unknown format: " + formatName));
        return this.setOutputFormat(fmt);
    }

    public RDFFormat getFallbackOutputFormat() {
        return this.outputFormat;
    }

    public boolean isAllowOverwriteFiles() {
        return this.allowOverwriteFiles;
    }

    public SELF setAllowOverwriteFiles(boolean allowOverwriteFiles) {
        this.allowOverwriteFiles = allowOverwriteFiles;
        return this.self();
    }

    public boolean isUseElephas() {
        return this.useElephas;
    }

    public SELF setUseElephas(boolean useElephas) {
        this.useElephas = useElephas;
        return this.self();
    }

    public boolean isPartitionsAsIndependentFiles() {
        return this.partitionsAsIndependentFiles;
    }

    public SELF setPartitionsAsIndependentFiles(boolean partitionsAsIndependentFiles) {
        this.partitionsAsIndependentFiles = partitionsAsIndependentFiles;
        return this.self();
    }

    public SELF setDeferOutputForUsedPrefixes(long deferOutputForUsedPrefixes) {
        this.deferOutputForUsedPrefixes = deferOutputForUsedPrefixes;
        return this.self();
    }

    public boolean isConsoleOutput() {
        return this.partitionFolder == null && this.targetFile == null;
    }

    public SELF setConsoleOutput() {
        this.partitionFolder = null;
        this.targetFile = null;
        return this.self();
    }

    public SELF setConsoleOutSupplier(Supplier<OutputStream> consoleOutSupplier) {
        this.consoleOutSupplier = consoleOutSupplier;
        return this.self();
    }

    public Supplier<OutputStream> getConsoleOutSupplier() {
        return this.consoleOutSupplier;
    }

    public RdfPostProcessingSettingsMutable getPostProcessingSettings() {
        return this.postProcessingSettings;
    }

    public SELF setPostProcessingSettings(RdfPostProcessingSettingsMutable postProcessingSettings) {
        this.postProcessingSettings = postProcessingSettings;
        return this.self();
    }
}

