/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.output;

import java.io.Serializable;
import java.util.Iterator;
import java.util.function.BiConsumer;
import net.sansa_stack.spark.io.rdf.output.RddRdfOps;
import net.sansa_stack.spark.rdd.function.JavaRddFunction;
import org.aksw.commons.lambda.serializable.SerializableBiConsumer;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.jenax.arq.dataset.api.DatasetGraphOneNg;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.util.quad.DatasetGraphUtils;
import org.aksw.jenax.arq.util.quad.DatasetUtils;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.triple.GraphUtils;
import org.aksw.jenax.arq.util.triple.ModelUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;

public class RddRdfOpsImpl<T>
implements RddRdfOps<T> {
    protected int componentCount;
    protected BiConsumer<T, StreamRDF> sendRecordToStreamRDF;
    protected JavaRddFunction<T, Triple> convertToTriple;
    protected JavaRddFunction<T, Quad> convertToQuad;
    protected JavaRddFunction<T, Node> convertToNode;
    protected java.util.function.Function<? super T, Comparable<?>> keyFunction;

    public RddRdfOpsImpl(int componentCount, BiConsumer<T, StreamRDF> sendRecordToStreamRDF, JavaRddFunction<T, Triple> convertToTriple, JavaRddFunction<T, Quad> convertToQuad, JavaRddFunction<T, Node> convertToNode, java.util.function.Function<? super T, Comparable<?>> keyFunction) {
        this.componentCount = componentCount;
        this.sendRecordToStreamRDF = sendRecordToStreamRDF;
        this.convertToTriple = convertToTriple;
        this.convertToQuad = convertToQuad;
        this.convertToNode = convertToNode;
        this.keyFunction = keyFunction;
    }

    @Override
    public int getComponentCount() {
        return this.componentCount;
    }

    @Override
    public void sendRecordToStreamRDF(T record, StreamRDF streamRDF) {
        this.sendRecordToStreamRDF.accept(record, streamRDF);
    }

    @Override
    public JavaRDD<Triple> convertToTriple(JavaRDD<T> rdd) {
        return (JavaRDD)this.convertToTriple.apply(rdd);
    }

    @Override
    public JavaRDD<Quad> convertToQuad(JavaRDD<T> rdd) {
        return (JavaRDD)this.convertToQuad.apply(rdd);
    }

    @Override
    public JavaRDD<Node> convertToNode(JavaRDD<T> rdd) {
        return (JavaRDD)this.convertToNode.apply(rdd);
    }

    @Override
    public java.util.function.Function<? super T, Comparable<?>> getKeyFunction() {
        return this.keyFunction;
    }

    public static <T> RddRdfOpsImpl<T> create(int componentCount, SerializableBiConsumer<T, StreamRDF> sendRecordToStreamRDF, JavaRddFunction<T, Triple> convertToTriple, JavaRddFunction<T, Quad> convertToQuad, JavaRddFunction<T, Node> convertToNode, SerializableFunction<? super T, Comparable<?>> keyFunction) {
        return new RddRdfOpsImpl<T>(componentCount, sendRecordToStreamRDF, convertToTriple, convertToQuad, convertToNode, keyFunction);
    }

    public static RddRdfOpsImpl<Triple> createForTriple() {
        return RddRdfOpsImpl.create(3, (SerializableBiConsumer & Serializable)(triple, streamRDF) -> streamRDF.triple(triple), (JavaRddFunction & Serializable)x -> x, (JavaRddFunction & Serializable)x -> x.map((Function & Serializable)triple -> Quad.create((Node)Quad.defaultGraphNodeGenerated, (Triple)triple)), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)triple -> TripleUtils.tripleToList((Triple)triple).iterator()), NodeFmtLib::str);
    }

    public static RddRdfOpsImpl<Quad> createForQuad() {
        return RddRdfOpsImpl.create(4, (SerializableBiConsumer & Serializable)(quad, streamRDF) -> streamRDF.quad(quad), (JavaRddFunction & Serializable)x -> x.map(Quad::asTriple), (JavaRddFunction & Serializable)x -> x, (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)q -> QuadUtils.quadToList((Quad)q).iterator()), NodeFmtLib::str);
    }

    public static RddRdfOpsImpl<Graph> createForGraph() {
        return RddRdfOpsImpl.create(3, (SerializableBiConsumer & Serializable)(graph, streamRDF) -> StreamRDFOps.sendDatasetToStream((DatasetGraph)DatasetGraphFactory.wrap((Graph)graph), (StreamRDF)streamRDF), (JavaRddFunction & Serializable)x -> x.flatMap(Graph::find), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)graph -> graph.find().mapWith(t -> new Quad(Quad.defaultGraphNodeGenerated, t))), (JavaRddFunction & Serializable)x -> x.flatMap(GraphUtils::iterateNodes), (SerializableFunction & Serializable)x -> {
            throw new UnsupportedOperationException("Graphs don't have a sort key");
        });
    }

    public static RddRdfOpsImpl<DatasetGraphOneNg> createForDatasetGraph() {
        return RddRdfOpsImpl.create(4, (SerializableBiConsumer & Serializable)(dg, streamRDF) -> StreamRDFOps.sendDatasetToStream((DatasetGraph)dg, (StreamRDF)streamRDF), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)dg -> WrappedIterator.create((Iterator)dg.find()).mapWith(Quad::asTriple)), (JavaRddFunction & Serializable)x -> x.flatMap(DatasetGraph::find), (JavaRddFunction & Serializable)x -> x.flatMap(DatasetGraphUtils::iterateNodes), (SerializableFunction & Serializable)x -> x.getGraphNode().toString(false));
    }

    public static RddRdfOpsImpl<Model> createForModel() {
        return RddRdfOpsImpl.create(3, (SerializableBiConsumer & Serializable)(model, streamRDF) -> StreamRDFOps.sendDatasetToStream((DatasetGraph)DatasetGraphFactory.wrap((Graph)model.getGraph()), (StreamRDF)streamRDF), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)model -> model.getGraph().find()), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)model -> model.getGraph().find().mapWith(t -> new Quad(Quad.defaultGraphNodeGenerated, t))), (JavaRddFunction & Serializable)x -> x.flatMap(ModelUtils::iterateNodes), (SerializableFunction & Serializable)x -> {
            throw new UnsupportedOperationException("Models don't have a sort key");
        });
    }

    public static RddRdfOpsImpl<DatasetOneNg> createForDataset() {
        return RddRdfOpsImpl.create(4, (SerializableBiConsumer & Serializable)(ds, streamRDF) -> StreamRDFOps.sendDatasetToStream((DatasetGraph)ds.asDatasetGraph(), (StreamRDF)streamRDF), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)ds -> WrappedIterator.create((Iterator)ds.asDatasetGraph().find()).mapWith(Quad::asTriple)), (JavaRddFunction & Serializable)x -> x.flatMap((FlatMapFunction & Serializable)ds -> ds.asDatasetGraph().find()), (JavaRddFunction & Serializable)x -> x.flatMap(DatasetUtils::iterateNodes), (SerializableFunction & Serializable)x -> x.getGraphName());
    }
}

