/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.sansa_stack.spark.io.rdf.input.api.RdfSourceCollection;
import net.sansa_stack.spark.io.rdf.input.api.RdfSourceFactory;
import net.sansa_stack.spark.io.rdf.input.api.RdfSourceFromResource;
import net.sansa_stack.spark.io.rdf.input.impl.RdfSourceCollectionImpl;
import net.sansa_stack.spark.io.rdf.input.impl.RdfSourceFromResourceImpl;
import org.aksw.jena_sparql_api.http.domain.api.RdfEntityInfo;
import org.aksw.jenax.sparql.query.rx.RDFDataMgrEx;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfSourceFactoryImpl
implements RdfSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(RdfSourceFactoryImpl.class);
    protected SparkSession sparkSession;

    public RdfSourceFactoryImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }

    public static RdfSourceFactory from(SparkSession sparkSession) {
        return new RdfSourceFactoryImpl(sparkSession);
    }

    @Override
    public RdfSourceFromResource create(Path path, FileSystem fileSystem, Lang lang) throws Exception {
        if (fileSystem == null) {
            Configuration hadoopConf = this.sparkSession.sparkContext().hadoopConfiguration();
            fileSystem = FileSystem.get((Configuration)hadoopConf);
        }
        Path resolvedPath = fileSystem.resolvePath(path);
        if (lang == null) {
            lang = RdfSourceFactoryImpl.probeLang(resolvedPath, fileSystem);
        }
        logger.info("Creating RDF Source: " + path + " -> " + lang);
        return new RdfSourceFromResourceImpl(this.sparkSession, resolvedPath, lang);
    }

    @Override
    public RdfSourceCollection newRdfSourceCollection() {
        return new RdfSourceCollectionImpl(this.sparkSession);
    }

    public static Lang probeLang(Path path, FileSystem fileSystem) throws IOException {
        RdfEntityInfo entityInfo;
        if (fileSystem == null) {
            fileSystem = Objects.requireNonNull(RdfSourceFactoryImpl.getDefaultFileSystem(), "Failed to obtain the default file system");
        }
        try (FSDataInputStream in = fileSystem.open(path);){
            entityInfo = RDFDataMgrEx.probeEntityInfo((InputStream)in, (Iterable)RDFDataMgrEx.DEFAULT_PROBE_LANGS);
        }
        Lang result = null;
        if (entityInfo != null) {
            result = RDFLanguages.contentTypeToLang((String)entityInfo.getContentType());
            Objects.requireNonNull(result, "Could not obtain lang for " + entityInfo.getContentType() + " from " + path);
        }
        return result;
    }

    public static FileSystem getDefaultFileSystem() throws IOException {
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", "file:///");
        FileSystem result = FileSystem.get((Configuration)conf);
        return result;
    }
}

