/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.impl;

import java.io.Serializable;
import net.sansa_stack.spark.io.rdf.input.api.RddRdfLoader;
import net.sansa_stack.spark.io.rdf.input.impl.RddRdfLoaderImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class RddRdfLoaders {
    public static <T> RddRdfLoader<T> create(Class<T> clazz, Class<? extends FileInputFormat<LongWritable, T>> fileInputFormat) {
        return new RddRdfLoaderImpl<T>(clazz, fileInputFormat);
    }

    public static <T> JavaRDD<T> createJavaRdd(SparkContext sparkContext, String path, Class<T> clazz, Class<? extends FileInputFormat<LongWritable, T>> fileInputFormat) {
        return RddRdfLoaders.asJavaRdd(RddRdfLoaders.createRddOfDatasetCore(sparkContext, path, clazz, fileInputFormat));
    }

    public static <T> RDD<T> createRdd(SparkContext sparkContext, String path, Class<T> clazz, Class<? extends FileInputFormat<LongWritable, T>> fileInputFormat) {
        return RddRdfLoaders.createJavaRdd(sparkContext, path, clazz, fileInputFormat).rdd();
    }

    public static <T> RDD<Tuple2<LongWritable, T>> createRddOfDatasetCore(SparkContext sparkContext, String path, Class<T> clazz, Class<? extends FileInputFormat<LongWritable, T>> fileInputFormat) {
        Configuration confHadoop = sparkContext.hadoopConfiguration();
        RDD result = sparkContext.newAPIHadoopFile(path, fileInputFormat, LongWritable.class, clazz, confHadoop);
        return result;
    }

    public static <T> JavaRDD<T> asJavaRdd(RDD<Tuple2<LongWritable, T>> rdd) {
        return rdd.toJavaRDD().map((Function & Serializable)t -> t._2());
    }
}

