/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.sansa_stack.hadoop.format.jena.nquads.FileInputFormatRdfNQuads;
import net.sansa_stack.hadoop.format.jena.ntriples.FileInputFormatRdfNTriples;
import net.sansa_stack.hadoop.format.jena.trig.FileInputFormatRdfTrigDataset;
import net.sansa_stack.hadoop.format.jena.trig.FileInputFormatRdfTrigQuad;
import net.sansa_stack.hadoop.format.jena.turtle.FileInputFormatRdfTurtleTriple;
import net.sansa_stack.spark.io.rdf.input.api.RddRdfLoader;
import net.sansa_stack.spark.io.rdf.input.api.RddRdfLoaderRegistry;
import net.sansa_stack.spark.io.rdf.input.impl.RddRdfLoaders;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.sparql.core.Quad;

public class RddRdfLoaderRegistryImpl
implements RddRdfLoaderRegistry {
    private static RddRdfLoaderRegistry INSTANCE = null;
    protected Table<Lang, Class<?>, RddRdfLoader<?>> registry = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RddRdfLoaderRegistry get() {
        if (INSTANCE != null) return INSTANCE;
        Class<RddRdfLoaderRegistryImpl> clazz = RddRdfLoaderRegistryImpl.class;
        synchronized (RddRdfLoaderRegistryImpl.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new RddRdfLoaderRegistryImpl();
            RddRdfLoaderRegistryImpl.loadDefaults(INSTANCE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void loadDefaults(RddRdfLoaderRegistry registry) {
        registry.register(Lang.TRIG, DatasetOneNg.class, RddRdfLoaders.create(DatasetOneNg.class, FileInputFormatRdfTrigDataset.class));
        registry.register(Lang.TRIG, Quad.class, RddRdfLoaders.create(Quad.class, FileInputFormatRdfTrigQuad.class));
        registry.register(Lang.TURTLE, Triple.class, RddRdfLoaders.create(Triple.class, FileInputFormatRdfTurtleTriple.class));
        registry.register(Lang.NTRIPLES, Triple.class, RddRdfLoaders.create(Triple.class, FileInputFormatRdfNTriples.class));
        registry.register(Lang.NQUADS, Quad.class, RddRdfLoaders.create(Quad.class, FileInputFormatRdfNQuads.class));
    }

    @Override
    public <T> void register(Lang lang, Class<T> targetType, RddRdfLoader<T> loader) {
        this.registry.put((Object)lang, targetType, loader);
    }

    @Override
    public <T, X> void registerMapped(Lang lang, Class<T> targetType, RddRdfLoader<X> loader) {
        this.registry.put((Object)lang, targetType, loader);
    }

    @Override
    public <T> RddRdfLoader<T> find(Lang lang, Class<T> rdfType) {
        RddRdfLoader tmp = (RddRdfLoader)this.registry.get((Object)lang, rdfType);
        return tmp;
    }
}

