/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.json.input;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sansa_stack.hadoop.format.gson.json.FileInputFormatJsonArray;
import net.sansa_stack.hadoop.format.gson.json.FileInputFormatJsonSequence;
import net.sansa_stack.hadoop.format.gson.json.JsonElementArrayIterator;
import net.sansa_stack.hadoop.format.gson.json.JsonElementSequenceIterator;
import net.sansa_stack.spark.io.rdf.input.api.HadoopInputData;
import net.sansa_stack.spark.io.rdf.input.api.InputFormatUtils;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.aksw.jena_sparql_api.sparql.ext.json.RDFDatatypeJson;
import org.apache.commons.io.input.CloseShieldReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;

public class JsonDataSources {
    public static JavaRDD<Binding> createRddFromJson(JavaSparkContext javaSparkContext, String filename, int probeCount, Var outputVar) {
        HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>> hid1;
        try {
            hid1 = JsonDataSources.probeJsonInputFormat(filename, javaSparkContext.hadoopConfiguration(), probeCount);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to probe JSON content of '" + filename + "'", e);
        }
        HadoopInputData<LongWritable, JsonElement, JavaRDD<Binding>> hid2 = hid1.map(JsonDataSources.bindingMapper(outputVar));
        JavaRDD<Binding> result = InputFormatUtils.createRdd(javaSparkContext, hid2);
        return result;
    }

    public static HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>> probeJsonInputFormat(String filename, Configuration conf, int probeCount) throws IOException {
        HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>> result;
        JsonProbeResult probeResult = JsonDataSources.probeJsonFormat(filename, conf, probeCount);
        switch (probeResult.getDetectedType()) {
            case ARRAY: {
                result = JsonDataSources.jsonArray(filename, conf);
                break;
            }
            case SEQUENCE: {
                result = JsonDataSources.jsonSequence(filename, conf);
                break;
            }
            default: {
                throw new RuntimeException("Failed to determine JSON format (only array or sequences supported): " + probeResult);
            }
        }
        return result;
    }

    public static HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>> jsonArray(String filename, Configuration conf) {
        return new HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>>(filename, FileInputFormatJsonArray.class, LongWritable.class, JsonElement.class, conf, pairRdd -> pairRdd.map((Function & Serializable)x -> (JsonElement)x._2));
    }

    public static HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>> jsonSequence(String filename, Configuration conf) {
        return new HadoopInputData<LongWritable, JsonElement, JavaRDD<JsonElement>>(filename, FileInputFormatJsonSequence.class, LongWritable.class, JsonElement.class, conf, pairRdd -> pairRdd.map((Function & Serializable)x -> (JsonElement)x._2));
    }

    public static JsonProbeResult probeJsonFormat(String filename, Configuration conf, int probeCount) throws IOException {
        JsonProbeResult result;
        FileSystem hadoopFs = FileSystem.get((Configuration)conf);
        Path path = new Path(filename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)hadoopFs.open(path), StandardCharsets.UTF_8));){
            result = JsonDataSources.probeJsonFormat(reader, RDFDatatypeJson.get().getGson(), probeCount);
        }
        return result;
    }

    public static java.util.function.Function<JavaRDD<JsonElement>, JavaRDD<Binding>> bindingMapper(Var outputVar) {
        String varName = outputVar.getName();
        return rdd -> rdd.mapPartitions((FlatMapFunction & Serializable)it -> {
            Var var = Var.alloc((String)varName);
            return Iter.iter((Iterator)it).map(json -> {
                Node node = JenaJsonUtils.convertJsonToNodeValue((JsonElement)json).asNode();
                Binding r = BindingFactory.binding((Var)var, (Node)node);
                return r;
            });
        });
    }

    public static JsonProbeResult probeJsonFormat(Reader reader, Gson gson, int probeCount) throws IOException {
        int i;
        JsonElementArrayIterator it;
        JsonSourceType detectedType = null;
        LinkedHashMap<JsonSourceType, Throwable> exceptions = new LinkedHashMap<JsonSourceType, Throwable>();
        if (!reader.markSupported()) {
            throw new IllegalArgumentException("InputStream must support marks");
        }
        int readLimit = 0x40000000;
        if (detectedType == null) {
            reader.mark(readLimit);
            try {
                it = new JsonElementArrayIterator(gson, gson.newJsonReader((Reader)new CloseShieldReader(reader)));
                try {
                    for (i = 0; i < probeCount && it.hasNext(); ++i) {
                        it.next();
                    }
                    detectedType = JsonSourceType.ARRAY;
                }
                finally {
                    it.close();
                }
            }
            catch (Throwable e) {
                exceptions.put(JsonSourceType.ARRAY, e);
            }
            reader.reset();
        }
        if (detectedType == null) {
            reader.mark(readLimit);
            try {
                it = new JsonElementSequenceIterator(gson, gson.newJsonReader((Reader)new CloseShieldReader(reader)));
                try {
                    for (i = 0; i < probeCount && it.hasNext(); ++i) {
                        it.next();
                    }
                    detectedType = JsonSourceType.SEQUENCE;
                }
                finally {
                    it.close();
                }
            }
            catch (Throwable e) {
                exceptions.put(JsonSourceType.SEQUENCE, e);
            }
            reader.reset();
        }
        if (detectedType == null) {
            detectedType = JsonSourceType.UNKNOWN;
        }
        JsonProbeResult result = new JsonProbeResult(detectedType, exceptions);
        return result;
    }

    public static class JsonProbeResult {
        protected JsonSourceType detectedType;
        protected Map<JsonSourceType, Throwable> exceptions;

        public JsonProbeResult(JsonSourceType detectedType, Map<JsonSourceType, Throwable> exceptions) {
            this.detectedType = detectedType;
            this.exceptions = exceptions;
        }

        public JsonSourceType getDetectedType() {
            return this.detectedType;
        }

        public Map<JsonSourceType, Throwable> getExceptions() {
            return this.exceptions;
        }

        public String toString() {
            return "JsonProbeResult{detectedType=" + this.detectedType + ", exceptions=" + this.exceptions + "}";
        }
    }

    public static enum JsonSourceType {
        UNKNOWN,
        ARRAY,
        SEQUENCE;

    }
}

