/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.csv.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.lambda.serializable.SerializableBiFunction;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.jena_sparql_api.sparql.ext.json.JenaJsonUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;

public class CsvRowMapperFactories {
    public static Function<String[], Binding> rowMapperFactoryBinding(String[][] header) {
        Var[][] vars = CsvRowMapperFactories.headerToVars(header);
        SerializableFunction & Serializable result = (SerializableFunction & Serializable)strs -> CsvRowMapperFactories.rowToBinding(vars, strs);
        return result;
    }

    public static Function<String[][], Function<String[], Binding>> rowMapperFactoryBinding(Var[] header) {
        SerializableFunction & Serializable result = (SerializableFunction & Serializable)columnNames -> {
            SerializableFunction & Serializable r = (SerializableFunction & Serializable)strs -> CsvRowMapperFactories.rowToBinding(header, strs);
            return r;
        };
        return result;
    }

    public static Function<String[][], Function<String[], Binding>> rowMapperFactoryJson(Binding parent, Var resultVar, SerializableBiFunction<String[][], String[], JsonObject> rowMapperFactoryJson) {
        SerializableFunction & Serializable result = (SerializableFunction & Serializable)headers -> {
            SerializableFunction & Serializable r = (SerializableFunction & Serializable)strs -> {
                JsonObject obj = (JsonObject)rowMapperFactoryJson.apply(headers, strs);
                Node node = JenaJsonUtils.createLiteralByValue((JsonElement)obj);
                BindingBuilder bb = BindingBuilder.create((Binding)parent);
                bb.add(resultVar, node);
                return bb.build();
            };
            return r;
        };
        return result;
    }

    public static String[][] transformHeader(String[][] input, Function<String, String> transform) {
        return (String[][])Arrays.stream(input).map(arr -> Arrays.stream(arr).map(transform).collect(Collectors.toList()).toArray(new String[0])).collect(Collectors.toList()).toArray((T[])new String[0][]);
    }

    public static Var[][] headerToVars(String[][] columnNames) {
        int n = columnNames.length;
        Var[][] result = new Var[n][];
        for (int i = 0; i < n; ++i) {
            String[] strs = columnNames[i];
            Var[] h = new Var[strs.length];
            result[i] = h;
            for (int j = 0; j < strs.length; ++j) {
                String str = strs[j];
                h[j] = Var.alloc((String)str);
            }
        }
        return result;
    }

    public static Binding rowToBinding(Var[][] headers, String[] strs) {
        BindingBuilder builder = BindingBuilder.create();
        int n = Math.min(headers.length, strs.length);
        for (int i = 0; i < n; ++i) {
            Var[] vars = headers[i];
            String str = strs[i];
            if (str == null) continue;
            int varlen = vars.length;
            Node node = NodeFactory.createLiteral((String)str);
            for (int j = 0; j < varlen; ++j) {
                Var var = vars[j];
                builder.add(var, node);
            }
        }
        Binding result = builder.build();
        return result;
    }

    public static Binding rowToBinding(Var[] headers, String[] strs) {
        BindingBuilder builder = BindingBuilder.create();
        int n = Math.min(headers.length, strs.length);
        for (int i = 0; i < n; ++i) {
            Var var = headers[i];
            String str = strs[i];
            if (str == null) continue;
            Node node = NodeFactory.createLiteral((String)str);
            builder.add(var, node);
        }
        Binding result = builder.build();
        return result;
    }

    public static JsonObject rowToJson(String[][] headers, String[] strs) {
        JsonObject result = new JsonObject();
        int n = Math.min(headers.length, strs.length);
        for (int i = 0; i < n; ++i) {
            String[] vars = headers[i];
            String str = strs[i];
            if (str == null) continue;
            for (String var : vars) {
                result.addProperty(var, str);
            }
        }
        return result;
    }
}

