/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.csv.input;

import com.google.common.base.StandardSystemProperty;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import net.sansa_stack.hadoop.format.univocity.csv.csv.FileInputFormatCsvUnivocity;
import net.sansa_stack.hadoop.util.FileSystemUtils;
import net.sansa_stack.spark.io.csv.input.ColumnNamingScheme;
import net.sansa_stack.spark.io.csv.input.CsvRowMapperFactories;
import net.sansa_stack.spark.io.rdf.input.api.HadoopInputData;
import net.sansa_stack.spark.io.rdf.input.api.InputFormatUtils;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;
import org.aksw.commons.model.csvw.domain.impl.DialectMutableImpl;
import org.aksw.commons.model.csvw.univocity.CsvwUnivocityUtils;
import org.aksw.commons.model.csvw.univocity.UnivocityCsvwConf;
import org.aksw.commons.model.csvw.univocity.UnivocityParserFactory;
import org.aksw.commons.model.csvw.univocity.UnivocityUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvDataSources {
    private static final Logger logger = LoggerFactory.getLogger(CsvDataSources.class);

    public static JavaRDD<Binding> createRddOfBindings(JavaSparkContext sc, String pathStr, UnivocityCsvwConf csvConf) throws IOException {
        return CsvDataSources.createRddOfBindings(sc, pathStr, csvConf, Arrays.asList("row"));
    }

    public static JavaRDD<Binding> createRddOfBindings(JavaSparkContext sc, String pathStr, UnivocityCsvwConf baseCsvConf, List<String> columnNamingSchemes) throws IOException {
        Configuration conf = new Configuration(sc.hadoopConfiguration());
        HadoopInputData<LongWritable, String[], JavaRDD<Binding>> hid = CsvDataSources.configureHadoop(conf, pathStr, baseCsvConf, columnNamingSchemes, CsvRowMapperFactories::rowMapperFactoryBinding);
        JavaRDD<Binding> result = InputFormatUtils.createRdd(sc, hid);
        return result;
    }

    public static HadoopInputData<LongWritable, String[], JavaRDD<Binding>> configureHadoop(Configuration conf, String pathStr, UnivocityCsvwConf baseCsvConf, List<String> columnNamingSchemes, java.util.function.Function<String[][], java.util.function.Function<String[], Binding>> rowMapperFactory) {
        String[] sampleRow;
        Path path = new Path(pathStr);
        Callable<InputStream> inputStreamFactory = () -> FileSystemUtils.newInputStream((Path)path, (Configuration)conf);
        DialectMutable dialect = baseCsvConf.getDialect();
        Long headerRowCountBak = dialect.getHeaderRowCount();
        boolean hasHeaders = !Long.valueOf(0L).equals(headerRowCountBak);
        DialectMutableImpl effectiveDialect = new DialectMutableImpl();
        dialect.copyInto((DialectMutable)effectiveDialect, false);
        effectiveDialect.setHeaderRowCount(Long.valueOf(0L));
        UnivocityCsvwConf csvConf = new UnivocityCsvwConf((DialectMutable)effectiveDialect, baseCsvConf.getNullValues());
        UnivocityParserFactory parserFactory = UnivocityParserFactory.createDefault((Boolean)false).configure(csvConf);
        if (!baseCsvConf.isTabs()) {
            Set detectedProperties;
            CsvParserSettings csvSettings = parserFactory.getCsvSettings();
            try {
                UnivocityParserFactory finalParserFactory = parserFactory;
                detectedProperties = CsvwUnivocityUtils.configureDialect((DialectMutable)effectiveDialect, (CsvParserSettings)csvSettings, () -> (CsvParser)finalParserFactory.newParser(), () -> finalParserFactory.newInputStreamReader((InputStream)inputStreamFactory.call()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.info("For source " + pathStr + " auto-detected csv properties: " + detectedProperties);
            csvConf.setTabs(false);
            parserFactory = UnivocityParserFactory.createDefault((Boolean)false).configure(csvConf);
        }
        try (Stream rows = UnivocityUtils.readCsvRows(inputStreamFactory, (UnivocityParserFactory)parserFactory);){
            sampleRow = rows.findFirst().orElse(new String[0]);
        }
        effectiveDialect.setHeaderRowCount(headerRowCountBak);
        int n = sampleRow.length;
        String[][] columnNames = null;
        if (columnNamingSchemes != null) {
            columnNames = ColumnNamingScheme.createColumnHeadings(columnNamingSchemes, sampleRow, !hasHeaders);
        }
        java.util.function.Function<String[], Binding> rowMapper = rowMapperFactory.apply(columnNames);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Effective CSV dialect for %s:%s%s", pathStr, StandardSystemProperty.LINE_SEPARATOR.value(), effectiveDialect));
        }
        FileInputFormatCsvUnivocity.setUnivocityConfig((Configuration)conf, (UnivocityCsvwConf)csvConf);
        return new HadoopInputData<LongWritable, String[], JavaRDD<Binding>>(pathStr, FileInputFormatCsvUnivocity.class, LongWritable.class, String[].class, conf, javaPairRdd -> javaPairRdd.map((Function & Serializable)row -> (Binding)rowMapper.apply((String[])row._2)));
    }
}

