/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.csv.input;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.model.csvw.domain.impl.CsvwLib;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.apache.commons.lang3.StringUtils;

public interface ColumnNamingScheme {
    public String[][] create(String[] var1);

    public static String[][] row(String[] row) {
        int n = row.length;
        String[][] r = new String[n][];
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            String v = row[i];
            if (v == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = v;
            }
            r[i] = stringArray;
        }
        return r;
    }

    public static String[][] sparql(String[] row) {
        int n = row.length;
        String[][] r = new String[n][];
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            String v = row[i];
            if (v == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = VarUtils.safeVarName((String)v);
            }
            r[i] = stringArray;
        }
        return r;
    }

    public static String[][] excel(int length) {
        String[][] r = new String[length][];
        for (int i = 0; i < length; ++i) {
            r[i] = new String[]{CsvwLib.getExcelColumnLabel((int)i)};
        }
        return r;
    }

    public static String[][] number(int offset, int length) {
        String[][] r = new String[length][];
        for (int i = 0; i < length; ++i) {
            r[i] = new String[]{Integer.toString(offset + i)};
        }
        return r;
    }

    public static String[][] merge(Collection<String[][]> elements) {
        Set lengths = elements.stream().map(e -> ((String[][])e).length).collect(Collectors.toSet());
        Preconditions.checkArgument((lengths.size() == 1 ? 1 : 0) != 0, (Object)("Need exactly one length for the columns; got lengths" + lengths));
        int n = (Integer)lengths.iterator().next();
        HashSet<String> seen = new HashSet<String>();
        List[] cols = new List[n];
        for (int i = 0; i < n; ++i) {
            cols[i] = new ArrayList();
        }
        for (String[][] element : elements) {
            for (int i = 0; i < n; ++i) {
                List alts = cols[i];
                for (String name : element[i]) {
                    if (!seen.contains(name)) {
                        alts.add(name);
                    }
                    seen.add(name);
                }
            }
        }
        String[][] result = new String[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = cols[i].toArray(new String[0]);
        }
        return result;
    }

    public static String[][] createColumnHeadings(List<String> schemeNames, String[] row, boolean rowAsExcel) {
        int n = row.length;
        ArrayList<String[][]> elements = new ArrayList<String[][]>();
        for (String schemeName : schemeNames) {
            String[][] outNames;
            if (StringUtils.isNumeric((CharSequence)schemeName)) {
                int offset = Integer.parseInt(schemeName);
                outNames = ColumnNamingScheme.number(offset, n);
            } else if (schemeName.equalsIgnoreCase("excel")) {
                outNames = ColumnNamingScheme.excel(n);
            } else if (schemeName.equalsIgnoreCase("row")) {
                outNames = rowAsExcel ? ColumnNamingScheme.excel(row.length) : ColumnNamingScheme.row(row);
            } else if (schemeName.equalsIgnoreCase("sparql")) {
                outNames = ColumnNamingScheme.sparql(row);
            } else {
                throw new RuntimeException("Unknown naming scheme: " + schemeNames);
            }
            elements.add(outNames);
        }
        String[][] result = ColumnNamingScheme.merge(elements);
        return result;
    }
}

