/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.rdd.op.rdf;

import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.aksw.commons.util.stream.StreamFunction;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import scala.Tuple2;

public class JavaRddOps {
    public static <K, V> JavaPairRDD<K, V> groupKeysAndReduceValues(JavaPairRDD<K, V> rdd, boolean distinct, boolean sortGraphsByIri, int numPartitions, Function2<V, V, V> reducer) {
        JavaPairRDD resultRdd = rdd;
        if (distinct) {
            resultRdd = resultRdd.reduceByKey(reducer);
        }
        if (numPartitions > 0) {
            resultRdd = sortGraphsByIri ? resultRdd.repartitionAndSortWithinPartitions((Partitioner)new HashPartitioner(numPartitions)) : resultRdd.repartition(numPartitions);
        }
        if (sortGraphsByIri) {
            resultRdd = resultRdd.sortByKey();
        }
        return resultRdd;
    }

    public static <T, A, R> R aggregateUsingJavaCollector(JavaRDD<? extends T> rdd, Collector<? super T, A, R> collector) {
        Object unfinishedResult = rdd.mapPartitions((FlatMapFunction & Serializable)it -> {
            Object result = collector.supplier().get();
            BiConsumer accumulator = collector.accumulator();
            while (it.hasNext()) {
                Object item = it.next();
                accumulator.accept(result, item);
            }
            return Collections.singleton(result).iterator();
        }).reduce(collector.combiner()::apply);
        R finishedResult = collector.finisher().apply(unfinishedResult);
        return finishedResult;
    }

    public static <I, O> JavaRDD<O> mapPartitions(JavaRDD<I> rdd, StreamFunction<I, O> fn) {
        return rdd.mapPartitions((FlatMapFunction & Serializable)it -> ((Stream)fn.apply((Object)Streams.stream((Iterator)it))).iterator());
    }

    public static <K, V, O> JavaRDD<O> mapPartitions(JavaPairRDD<K, V> rdd, StreamFunction<Tuple2<K, V>, O> fn) {
        return rdd.mapPartitions((FlatMapFunction & Serializable)it -> ((Stream)fn.apply((Object)Streams.stream((Iterator)it))).iterator());
    }
}

