/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.rdd.op.rdf;

import java.io.Serializable;
import net.sansa_stack.spark.rdd.function.JavaRddFunction;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class JavaRddOfQuadsOps {
    public static JavaPairRDD<String, Model> groupByNamedGraph(JavaRDD<Quad> rdd) {
        return rdd.mapToPair((PairFunction & Serializable)quad -> new Tuple2((Object)quad.getGraph().getURI(), quad)).combineByKey((Function & Serializable)triple -> ModelFactory.createDefaultModel(), (Function2 & Serializable)(model, quad) -> {
            model.getGraph().add(quad.asTriple());
            return model;
        }, (Function2 & Serializable)(m1, m2) -> {
            m1.add(m2);
            return m1;
        });
    }

    public static JavaRDD<Dataset> mapToDataset(JavaRDD<Quad> rdd) {
        return rdd.map((Function & Serializable)quad -> {
            DatasetGraph dg = DatasetGraphFactory.create();
            dg.add(quad);
            Dataset r = DatasetFactory.wrap((DatasetGraph)dg);
            return r;
        });
    }

    public static JavaRddFunction<Quad, Quad> mapIntoGraph(Node graphNode) {
        return (JavaRddFunction & Serializable)rdd -> rdd.map((Function & Serializable)quad -> new Quad(graphNode, quad.asTriple()));
    }

    public static JavaRddFunction<Quad, Triple> mapToTriples(Node graphNode) {
        return (JavaRddFunction & Serializable)rdd -> rdd.map(Quad::asTriple);
    }

    public static JavaRDD<Quad> postProcess(JavaRDD<Quad> rdd, boolean sort, boolean ascending, boolean distinct, int numPartitions) {
        if (distinct) {
            rdd = rdd.distinct();
        }
        if (sort) {
            rdd = rdd.sortBy(NodeFmtLib::str, ascending, numPartitions);
        }
        return rdd;
    }
}

