/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.rdd.op.rdf;

import java.io.Serializable;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOps;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.dataset.api.ResourceInDataset;
import org.aksw.jenax.arq.dataset.impl.DatasetOneNgImpl;
import org.aksw.jenax.arq.dataset.impl.ResourceInDatasetImpl;
import org.aksw.jenax.arq.dataset.orderaware.DatasetFactoryEx;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;

public class JavaRddOfNamedModelsOps {
    public static <K> JavaPairRDD<K, Model> groupNamedModels(JavaPairRDD<K, Model> rdd, boolean distinct, boolean sortGraphsByIri, int numPartitions) {
        return JavaRddOps.groupKeysAndReduceValues(rdd, distinct, sortGraphsByIri, numPartitions, (Function2 & Serializable)(g1, g2) -> {
            g1.add(g2);
            return g1;
        });
    }

    public static JavaRDD<DatasetOneNg> mapToDatasets(JavaPairRDD<String, Model> rdd) {
        return rdd.map((Function & Serializable)graphNameAndModel -> {
            DatasetOneNg r = DatasetOneNgImpl.create((String)((String)graphNameAndModel._1), (Graph)((Model)graphNameAndModel._2).getGraph());
            return r;
        });
    }

    public static JavaRDD<Resource> mapToResources(JavaPairRDD<String, Model> rdd) {
        return rdd.map((Function & Serializable)graphNameAndModel -> {
            String graphName = (String)graphNameAndModel._1();
            Model model = (Model)graphNameAndModel._2();
            Node node = NodeFactory.createURI((String)graphName);
            Resource r = model.asRDFNode(node).asResource();
            return r;
        });
    }

    public static JavaRDD<ResourceInDataset> mapToResourceInDataset(JavaPairRDD<String, Model> rdd) {
        return rdd.map((Function & Serializable)graphNameAndModel -> {
            String graphName = (String)graphNameAndModel._1();
            Model model = (Model)graphNameAndModel._2();
            Node node = NodeFactory.createURI((String)graphName);
            Dataset dataset = DatasetFactoryEx.createInsertOrderPreservingDataset();
            dataset.addNamedModel(graphName, model);
            ResourceInDatasetImpl r = new ResourceInDatasetImpl(dataset, graphName, node);
            return r;
        });
    }
}

