/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.rdd.op.rdf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.sansa_stack.spark.rdd.function.JavaRddFunction;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOfNamedModelsOps;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOps;
import net.sansa_stack.spark.util.JavaSparkContextUtils;
import org.aksw.commons.util.stream.StreamFunction;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.ext.com.google.common.collect.Lists;
import org.apache.jena.ext.com.google.common.collect.Streams;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import scala.Tuple2;

public class JavaRddOfDatasetsOps {
    public static JavaRDD<Quad> flatMapToQuads(JavaRDD<? extends Dataset> rdd) {
        return JavaRddOps.mapPartitions(rdd, (StreamFunction & Serializable)dss -> dss.flatMap(ds -> Iter.asStream((Iterator)ds.asDatasetGraph().find())));
    }

    public static JavaRDD<Triple> flatMapToTriples(JavaRDD<? extends Dataset> rdd) {
        return JavaRddOps.mapPartitions(rdd, (StreamFunction & Serializable)dss -> dss.flatMap(ds -> Iter.asStream((Iterator)ds.asDatasetGraph().find()).map(Quad::asTriple)));
    }

    public static JavaPairRDD<String, Model> flatMapToNamedModels(JavaRDD<? extends Dataset> rdd) {
        return rdd.flatMapToPair((PairFlatMapFunction & Serializable)ds -> Streams.stream((Iterator)ds.listNames()).map(iri -> new Tuple2(iri, (Object)ds.getNamedModel(iri))).iterator());
    }

    public static JavaRDD<DatasetOneNg> groupNamedGraphsByGraphIri(JavaRDD<? extends Dataset> rdd, boolean distinct, boolean sortGraphsByIri, int numPartitions) {
        JavaPairRDD<String, Model> step1 = JavaRddOfDatasetsOps.flatMapToNamedModels(rdd);
        JavaPairRDD<String, Model> step2 = JavaRddOfNamedModelsOps.groupNamedModels(step1, distinct, sortGraphsByIri, numPartitions);
        JavaRDD<DatasetOneNg> result = JavaRddOfNamedModelsOps.mapToDatasets(step2);
        return result;
    }

    JavaRddFunction<Dataset, Quad> flatMapToQuadsViaConstruct(Query query) {
        Objects.requireNonNull(query);
        return (JavaRddFunction & Serializable)rdd -> {
            Broadcast queryBc = JavaSparkContextUtils.fromRdd(rdd).broadcast((Object)query);
            return rdd.flatMap((FlatMapFunction & Serializable)in -> {
                Iterator r;
                Query q = (Query)queryBc.value();
                try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Dataset)in);){
                    ArrayList list = Lists.newArrayList((Iterator)qe.execConstructQuads());
                    r = list.iterator();
                }
                return r;
            });
        };
    }
}

