/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.output;

import java.io.Serializable;
import net.sansa_stack.hadoop.output.jena.base.OutputFormatStreamRdfQuad;
import net.sansa_stack.hadoop.output.jena.base.OutputFormatStreamRdfTriple;
import net.sansa_stack.hadoop.output.jena.base.OutputUtils;
import net.sansa_stack.hadoop.output.jena.base.RdfOutputUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class RddRdfWriter2 {
    protected RDFFormat rdfFormat;
    protected boolean mapQuadsToTriplesForTripleLangs;
    protected PrefixMapping prefixes;

    public RddRdfWriter2(RDFFormat rdfFormat, boolean mapQuadsToTriplesForTripleLangs, PrefixMapping prefixes) {
        this.rdfFormat = rdfFormat;
        this.mapQuadsToTriplesForTripleLangs = mapQuadsToTriplesForTripleLangs;
        this.prefixes = prefixes;
    }

    public void writeTriples(RDD<Triple> rdd, Path path) {
        Configuration conf = this.buildConfiguration(rdd);
        JavaPairRDD pairRdd = RddRdfWriter2.toPairRdd(rdd.toJavaRDD());
        pairRdd.saveAsNewAPIHadoopFile(path.toString(), Long.class, Triple.class, OutputFormatStreamRdfTriple.class, conf);
    }

    public void writeQuads(RDD<Quad> rdd, Path path) {
        Configuration conf = this.buildConfiguration(rdd);
        JavaPairRDD pairRdd = RddRdfWriter2.toPairRdd(rdd.toJavaRDD());
        pairRdd.saveAsNewAPIHadoopFile(path.toString(), Long.class, Quad.class, OutputFormatStreamRdfQuad.class, conf);
    }

    protected Configuration buildConfiguration(RDD<?> rdd) {
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)rdd.context());
        Configuration baseConf = sparkContext.hadoopConfiguration();
        Configuration result = new Configuration(baseConf);
        OutputUtils.setSplitCount((Configuration)result, (int)rdd.getNumPartitions());
        this.configure(result);
        return result;
    }

    protected void configure(Configuration conf) {
        RdfOutputUtils.setRdfFormat((Configuration)conf, (RDFFormat)this.rdfFormat);
        RdfOutputUtils.setPrefixes((Configuration)conf, (PrefixMapping)this.prefixes);
        RdfOutputUtils.setMapQuadsToTriplesForTripleLangs((Configuration)conf, (boolean)this.mapQuadsToTriplesForTripleLangs);
    }

    public static <T> JavaPairRDD<Long, T> toPairRdd(JavaRDD<T> rdd) {
        JavaPairRDD result = rdd.mapToPair((PairFunction & Serializable)v -> new Tuple2((Object)0L, v));
        return result;
    }
}

