/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.output;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.sansa_stack.spark.io.rdf.output.RddRdfOpsImpl;
import net.sansa_stack.spark.io.rdf.output.RddRdfWriter2;
import net.sansa_stack.spark.io.rdf.output.RddRdfWriterFormatRegistry;
import net.sansa_stack.spark.io.rdf.output.RddRdfWriterSettings;
import net.sansa_stack.spark.io.rdf.output.RdfPostProcessingSettings;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOps;
import org.aksw.commons.io.util.FileMerger;
import org.aksw.commons.io.util.FileUtils;
import org.aksw.commons.lambda.serializable.SerializableBiConsumer;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.commons.lambda.throwing.ThrowingFunction;
import org.aksw.jena_sparql_api.rx.RDFLanguagesEx;
import org.aksw.jenax.arq.analytics.NodeAnalytics;
import org.aksw.jenax.arq.dataset.api.DatasetGraphOneNg;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.util.prefix.PrefixMapAdapter;
import org.aksw.jenax.arq.util.prefix.PrefixMappingTrie;
import org.aksw.jenax.arq.util.streamrdf.StreamRDFDeferred;
import org.aksw.jenax.arq.util.streamrdf.StreamRDFUtils;
import org.aksw.jenax.arq.util.streamrdf.WriterStreamRDFBaseUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.hadoop.rdf.types.QuadWritable;
import org.apache.jena.hadoop.rdf.types.TripleWritable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.writer.WriterStreamRDFBase;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class RddRdfWriter<T>
extends RddRdfWriterSettings<RddRdfWriter<T>> {
    private static final Logger logger = LoggerFactory.getLogger(RddRdfWriter.class);
    protected RddRdfOpsImpl<T> dispatcher;
    protected JavaSparkContext sparkContext;
    protected JavaRDD<? extends T> rdd;
    protected Configuration hadoopConfiguration;

    public RddRdfWriter(RddRdfOpsImpl<T> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public RddRdfWriter<T> setRdd(JavaRDD<? extends T> rdd) {
        this.rdd = rdd;
        this.sparkContext = rdd == null ? null : JavaSparkContext.fromSparkContext((SparkContext)rdd.context());
        this.hadoopConfiguration = rdd == null ? null : this.sparkContext.hadoopConfiguration();
        return this;
    }

    public JavaRDD<? extends T> getRdd() {
        return this.rdd;
    }

    @Override
    protected RddRdfWriter<T> self() {
        return this;
    }

    public RddRdfWriter<T> mutate(Consumer<RddRdfWriter<T>> action) {
        action.accept(this);
        return this;
    }

    public void runUnchecked() {
        try {
            this.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run() throws IOException {
        if (this.isConsoleOutput()) {
            this.runOutputToConsole();
        } else {
            this.runSpark();
        }
    }

    public JavaRDD<T> getEffectiveRdd(RdfPostProcessingSettings settings) {
        JavaRDD result = this.rdd.map((Function & Serializable)x -> x);
        if (settings != null) {
            if (Boolean.TRUE.equals(settings.getDistinct())) {
                Integer n = settings.getDistinctPartitions();
                JavaRDD javaRDD = result = n == null ? result.distinct() : result.distinct(n.intValue());
            }
            if (Boolean.TRUE.equals(settings.getSort())) {
                boolean isAscending = Boolean.TRUE.equals(settings.getSortAscending());
                int numPartitions = Optional.ofNullable(settings.getSortPartitions()).orElse(this.rdd.getNumPartitions());
                result = result.sortBy(this.dispatcher.getKeyFunction()::apply, isAscending, numPartitions);
            }
            if (Boolean.TRUE.equals(settings.getOptimizePrefixes())) {
                result = result.cache();
                PrefixMapping declaredPrefixes = this.getGlobalPrefixMapping();
                if (!declaredPrefixes.getNsPrefixMap().isEmpty()) {
                    Map usedPm = (Map)JavaRddOps.aggregateUsingJavaCollector(this.dispatcher.convertToNode(result), NodeAnalytics.usedPrefixes((Map)declaredPrefixes.getNsPrefixMap()).asCollector());
                    this.setGlobalPrefixMapping(usedPm);
                }
            }
        }
        return result;
    }

    protected void runOutputToConsole() throws IOException {
        try (OutputStream out = (OutputStream)this.consoleOutSupplier.get();){
            StreamRDF coreWriter = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)this.outputFormat, null);
            if (coreWriter instanceof WriterStreamRDFBase) {
                WriterStreamRDFBaseUtils.setNodeToLabel((WriterStreamRDFBase)((WriterStreamRDFBase)coreWriter), (NodeToLabel)SyntaxLabels.createNodeToLabelAsGiven());
            }
            StreamRDFDeferred writer = new StreamRDFDeferred(coreWriter, true, this.globalPrefixMapping, this.deferOutputForUsedPrefixes, Long.MAX_VALUE, null);
            writer.start();
            StreamRDFOps.sendPrefixesToStream((PrefixMapping)this.globalPrefixMapping, (StreamRDF)writer);
            Iterator it = this.rdd.toLocalIterator();
            it.forEachRemaining(arg_0 -> this.lambda$runOutputToConsole$0((StreamRDF)writer, arg_0));
            writer.finish();
            out.flush();
        }
    }

    public static void safeDeletePartitionFolder(FileSystem fs, org.apache.hadoop.fs.Path folderPath, Configuration conf) throws IOException {
        String baseName = Optional.ofNullable(conf.get("mapreduce.output.basename")).orElse("part");
        if (baseName == null) {
            baseName = "part";
        }
        if (baseName.isBlank()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Deletion is disabled for blank base names as a safety measure");
            }
            return;
        }
        try {
            RemoteIterator it = fs.listFiles(folderPath, false);
            boolean allDeletable = true;
            org.apache.hadoop.fs.Path path = null;
            while (it.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)it.next();
                path = status.getPath();
                String fileName = path.getName();
                String effName = fileName.replaceAll("^\\.", "");
                boolean bl = allDeletable = allDeletable && (effName.startsWith(baseName) || effName.equals("_temporary") || effName.equals("_SUCCESS"));
                if (logger.isDebugEnabled()) {
                    logger.debug("Can delete " + path + ": " + allDeletable);
                }
                if (allDeletable) continue;
                break;
            }
            if (!allDeletable) {
                throw new DirectoryNotEmptyException("Safe delete refused to delete non-hadoop file: " + path);
            }
            fs.delete(folderPath, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runSpark() throws IOException {
        FileSystem partitionFolderFs;
        org.apache.hadoop.fs.Path effPartitionFolder = this.partitionFolder;
        if (this.targetFile != null && this.partitionFolder == null) {
            this.targetFile.getFileSystem(this.hadoopConfiguration);
            String targetFileName = this.targetFile.getName();
            effPartitionFolder = new org.apache.hadoop.fs.Path(this.targetFile.toUri().resolve("part-" + targetFileName));
        }
        if ((partitionFolderFs = effPartitionFolder.getFileSystem(this.hadoopConfiguration)).exists(effPartitionFolder)) {
            if (!this.allowOverwriteFiles) throw new IllegalArgumentException("Folder already exists: " + effPartitionFolder);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Attempting to safely remove existing file/folder: %s", effPartitionFolder));
            }
            RddRdfWriter.safeDeletePartitionFolder(partitionFolderFs, effPartitionFolder, this.hadoopConfiguration);
            if (partitionFolderFs.exists(effPartitionFolder)) {
                String msg = String.format("Could not safely remove partition folder '%s' because non-hadoop files exist. Please delete manually.", effPartitionFolder);
                throw new RuntimeException(msg);
            }
        }
        Object targetFileUri = null;
        FileSystem targetFileFs = null;
        if (this.targetFile != null && (targetFileFs = this.targetFile.getFileSystem(this.hadoopConfiguration)).exists(this.targetFile)) {
            if (!this.allowOverwriteFiles) throw new IllegalArgumentException("File already exists: " + this.targetFile);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Removing existing file: %s", this.targetFile));
            }
            targetFileFs.delete(this.targetFile, false);
        }
        JavaRDD effectiveRdd = this.getEffectiveRdd(this.postProcessingSettings);
        if (this.useCoalesceOne) {
            effectiveRdd = effectiveRdd.coalesce(1);
        }
        boolean useOldElephas = false;
        if (this.useElephas) {
            RddRdfWriter2 writer = new RddRdfWriter2(this.outputFormat, this.mapQuadsToTriplesForTripleLangs, this.globalPrefixMapping);
            Lang lang = this.outputFormat.getLang();
            if (RDFLanguages.isTriples((Lang)lang)) {
                JavaRDD triples = (JavaRDD)this.dispatcher.convertToTriple.apply(effectiveRdd);
                writer.writeTriples((RDD<Triple>)triples.rdd(), effPartitionFolder);
            } else {
                if (!RDFLanguages.isQuads((Lang)lang)) throw new IllegalStateException(String.format("Language %s is neiter triples nor quads", lang));
                JavaRDD quads = (JavaRDD)this.dispatcher.convertToQuad.apply(effectiveRdd);
                writer.writeQuads((RDD<Quad>)quads.rdd(), effPartitionFolder);
            }
        } else if (useOldElephas) {
            Lang lang = RDFLanguages.filenameToLang((String)effPartitionFolder.toString());
            Objects.requireNonNull(String.format("Could not determine language from path %s ", effPartitionFolder));
            if (RDFLanguages.isTriples((Lang)lang)) {
                JavaRDD triples = (JavaRDD)this.dispatcher.convertToTriple.apply(effectiveRdd);
                RddRdfWriter.saveUsingElephas(triples, effPartitionFolder, lang, TripleWritable::new);
            } else {
                if (!RDFLanguages.isQuads((Lang)lang)) throw new IllegalStateException(String.format("Language %s is neiter triples nor quads", lang));
                JavaRDD quads = (JavaRDD)this.dispatcher.convertToQuad.apply(effectiveRdd);
                RddRdfWriter.saveUsingElephas(quads, effPartitionFolder, lang, QuadWritable::new);
            }
        } else {
            PrefixMapping pmap = this.isPartitionsAsIndependentFiles() ? null : this.globalPrefixMapping;
            RddRdfWriter.saveToFolder(effectiveRdd, effPartitionFolder.toString(), this.outputFormat, this.mapQuadsToTriplesForTripleLangs, pmap, this.dispatcher.sendRecordToStreamRDF);
        }
        if (this.targetFile == null) return;
        if (!(partitionFolderFs instanceof LocalFileSystem) || !(targetFileFs instanceof LocalFileSystem)) {
            throw new IllegalArgumentException("Merge currently only supports local file system");
        }
        Path nioFolder = Paths.get(effPartitionFolder.toString(), new String[0]);
        Path nioFile = Paths.get(this.targetFile.toString(), new String[0]);
        RddRdfWriter.mergeFolder(nioFile, nioFolder, "part-*", null);
        if (!this.deletePartitionFolderAfterMerge) return;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Removing temporary output folder: %s", effPartitionFolder));
        }
        partitionFolderFs.delete(effPartitionFolder, true);
    }

    public static void validateOutFolder(org.apache.hadoop.fs.Path path, Configuration conf, boolean deleteIfExists) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        if (fs.exists(path)) {
            if (deleteIfExists) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Removing temporary output folder: %s", path));
                }
                fs.delete(path, true);
            } else {
                throw new IllegalArgumentException("File already exists: " + fs);
            }
        }
    }

    public static String toString(PrefixMapping prefixMapping, RDFFormat rdfFormat) {
        Model tmp = ModelFactory.createDefaultModel();
        tmp.setNsPrefixes(prefixMapping);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)baos, (Model)tmp, (RDFFormat)RDFFormat.TURTLE_PRETTY);
        String result = null;
        try {
            result = baos.toString("UTF-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void mergeFolder(Path outFile, Path srcFolder, String pattern, Comparator<? super Path> pathComparator) throws IOException {
        if (pathComparator == null) {
            pathComparator = (a, b) -> a.getFileName().toString().compareTo(b.getFileName().toString());
        }
        List partPaths = FileUtils.listPaths((Path)srcFolder, (String)pattern);
        Collections.sort(partPaths, pathComparator);
        logger.info(String.format("Creating file %s by merging %d files from %s", outFile, partPaths.size(), srcFolder));
        FileMerger merger = FileMerger.create((Path)outFile, (List)partPaths);
        merger.addProgressListener(self -> logger.info(String.format("Write progress for %s: %.2f%%", outFile.getFileName(), self.getProgress() * 100.0)));
        merger.run();
    }

    public static Iterator<String> partitionMapperNTriples(Iterator<Triple> it) {
        return WrappedIterator.create(it).mapWith(FmtUtils::stringForTriple);
    }

    public static Iterator<String> partitionMapperNQuads(Iterator<Quad> it) {
        return WrappedIterator.create(it).mapWith(FmtUtils::stringForQuad);
    }

    public static java.util.function.Function<OutputStream, StreamRDF> createStreamRDFFactory(RDFFormat rdfFormat, boolean mapQuadsToTriplesForTripleLangs, PrefixMapping prefixMapping) {
        return out -> {
            Object rawWriter = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)rdfFormat, null);
            StreamRDF coreWriter = StreamRDFUtils.unwrap((StreamRDF)rawWriter);
            if (coreWriter instanceof WriterStreamRDFBase) {
                WriterStreamRDFBase tmp = (WriterStreamRDFBase)coreWriter;
                WriterStreamRDFBaseUtils.setNodeToLabel((WriterStreamRDFBase)tmp, (NodeToLabel)SyntaxLabels.createNodeToLabelAsGiven());
                if (prefixMapping != null) {
                    WriterStreamRDFBaseUtils.setPrefixMap((WriterStreamRDFBase)tmp, (PrefixMap)new PrefixMapAdapter(prefixMapping));
                    rawWriter = StreamRDFUtils.wrapWithoutPrefixDelegation((StreamRDF)rawWriter);
                }
                WriterStreamRDFBaseUtils.updateFormatter((WriterStreamRDFBase)tmp);
            }
            if (RDFLanguages.isTriples((Lang)rdfFormat.getLang()) && mapQuadsToTriplesForTripleLangs) {
                rawWriter = new StreamRDFWrapper((StreamRDF)rawWriter){

                    public void quad(Quad quad) {
                        super.triple(quad.asTriple());
                    }
                };
            }
            return rawWriter;
        };
    }

    public static <T> ThrowingFunction<Iterator<T>, Iterator<String>> partitionMapperRDFStream(java.util.function.Function<OutputStream, StreamRDF> streamRDFFactory, BiConsumer<? super T, StreamRDF> sendRecordToWriter) {
        return (ThrowingFunction & Serializable)it -> {
            Iterator r;
            if (it.hasNext()) {
                PipedOutputStream out = new PipedOutputStream();
                PipedInputStream in = new PipedInputStream(out, 8192);
                StreamRDF writer = (StreamRDF)streamRDFFactory.apply(out);
                Thread thread = new Thread(() -> {
                    try {
                        writer.start();
                        while (it.hasNext()) {
                            Object record = it.next();
                            sendRecordToWriter.accept((Object)record, writer);
                        }
                        writer.finish();
                        out.flush();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            logger.warn("Failed to close a stream", (Throwable)e);
                        }
                    }
                });
                thread.start();
                r = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)).lines().iterator();
            } else {
                r = Collections.emptyIterator();
            }
            return r;
        };
    }

    public static <T> void saveToFolder(JavaRDD<T> javaRdd, String path, RDFFormat rdfFormat, boolean mapQuadsToTriplesForTripleLangs, PrefixMapping globalPrefixMapping, BiConsumer<T, StreamRDF> sendRecordToStreamRDF) throws IOException {
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)javaRdd.context());
        Lang lang = rdfFormat.getLang();
        boolean isPrefixesSupported = !Lang.NTRIPLES.equals((Object)lang);
        boolean isTurtleOrTrig = Arrays.asList(Lang.TURTLE, Lang.TRIG).contains(lang);
        String prefixStr = null;
        if (isPrefixesSupported && globalPrefixMapping != null && !globalPrefixMapping.hasNoMappings() && isTurtleOrTrig) {
            prefixStr = RddRdfWriter.toString(globalPrefixMapping, RDFFormat.TURTLE_PRETTY);
        }
        Broadcast prefixMappingBc = sparkContext.broadcast((Object)globalPrefixMapping);
        String rdfFormatStr = rdfFormat.toString();
        JavaRDD dataBlocks = javaRdd.mapPartitions((FlatMapFunction & Serializable)it -> {
            RDFFormat rdfFmt = RDFLanguagesEx.findRdfFormat((String)rdfFormatStr);
            PrefixMapping rawPmap = (PrefixMapping)prefixMappingBc.getValue();
            PrefixMappingTrie triePmap = new PrefixMappingTrie();
            triePmap.setNsPrefixes(rawPmap);
            java.util.function.Function<OutputStream, StreamRDF> streamRDFFactory = RddRdfWriter.createStreamRDFFactory(rdfFmt, mapQuadsToTriplesForTripleLangs, (PrefixMapping)triePmap);
            ThrowingFunction mapper = RddRdfWriter.partitionMapperRDFStream(streamRDFFactory, sendRecordToStreamRDF);
            Iterator r = (Iterator)mapper.apply(it);
            return r;
        });
        if (prefixStr != null) {
            JavaRDD prefixRdd = sparkContext.parallelize(Collections.singletonList(prefixStr));
            dataBlocks = prefixRdd.union(dataBlocks);
        }
        dataBlocks.saveAsTextFile(path);
    }

    public static <T> void saveUsingElephas(JavaRDD<T> rdd, org.apache.hadoop.fs.Path path, Lang lang, SerializableFunction<? super T, ?> recordToWritable) {
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)rdd.context());
        Configuration hadoopConfiguration = sparkContext.hadoopConfiguration();
        RddRdfWriterFormatRegistry.FormatEntry entry = RddRdfWriterFormatRegistry.getInstance().get(lang);
        Objects.requireNonNull(entry, String.format("No format registered for %s", lang));
        JavaPairRDD pairRdd = rdd.mapToPair((PairFunction & Serializable)v -> new Tuple2((Object)new LongWritable(0L), recordToWritable.apply(v)));
        pairRdd.saveAsNewAPIHadoopFile(path.toString(), entry.getKeyClass(), entry.getValueClass(), entry.getOutputFormatClass(), hadoopConfiguration);
    }

    public static RddRdfWriter<Triple> createForTriple() {
        return new RddRdfWriter<Triple>(RddRdfOpsImpl.createForTriple());
    }

    public static RddRdfWriter<Quad> createForQuad() {
        return new RddRdfWriter<Quad>(RddRdfOpsImpl.createForQuad());
    }

    public static RddRdfWriter<Graph> createForGraph() {
        return new RddRdfWriter<Graph>(RddRdfOpsImpl.createForGraph());
    }

    public static RddRdfWriter<DatasetGraphOneNg> createForDatasetGraph() {
        return new RddRdfWriter<DatasetGraphOneNg>(RddRdfOpsImpl.createForDatasetGraph());
    }

    public static RddRdfWriter<Model> createForModel() {
        return new RddRdfWriter<Model>(RddRdfOpsImpl.createForModel());
    }

    public static RddRdfWriter<DatasetOneNg> createForDataset() {
        return new RddRdfWriter<DatasetOneNg>(RddRdfOpsImpl.createForDataset());
    }

    public static void validate(RddRdfWriterSettings<?> settings) {
        RDFFormat outputFormat = settings.getOutputFormat();
        if (!StreamRDFWriter.registered((RDFFormat)outputFormat)) {
            throw new IllegalArgumentException(outputFormat + " is not a streaming format");
        }
    }

    public static <T> void sendToStreamRDF(JavaRDD<T> javaRdd, SerializableBiConsumer<T, StreamRDF> sendRecordToStreamRDF, SerializableSupplier<StreamRDF> streamRdfSupplier) {
        javaRdd.foreachPartition((VoidFunction & Serializable)it -> {
            StreamRDF streamRdf = (StreamRDF)streamRdfSupplier.get();
            streamRdf.start();
            while (it.hasNext()) {
                Object item = it.next();
                sendRecordToStreamRDF.accept(item, (Object)streamRdf);
            }
            streamRdf.finish();
        });
    }

    private /* synthetic */ void lambda$runOutputToConsole$0(StreamRDF writer, Object item) {
        this.dispatcher.sendRecordToStreamRDF.accept(item, writer);
    }
}

