/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.impl;

import java.io.Serializable;
import net.sansa_stack.spark.io.rdf.input.api.RddRdfLoader;
import net.sansa_stack.spark.io.rdf.input.api.RdfSourceFromResource;
import net.sansa_stack.spark.io.rdf.input.impl.RddRdfLoaderRegistryImpl;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOfNamedModelsOps;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOfQuadsOps;
import net.sansa_stack.spark.rdd.op.rdf.JavaRddOfTriplesOps;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.apache.hadoop.fs.Path;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.Quad;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfSourceFromResourceImpl
implements RdfSourceFromResource {
    private static final Logger logger = LoggerFactory.getLogger(RdfSourceFromResourceImpl.class);
    protected SparkSession sparkSession;
    protected Path path;
    protected Lang lang;

    public RdfSourceFromResourceImpl(SparkSession sparkSession, Path path, Lang lang) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.lang = lang;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    @Override
    public RDD<Triple> asTriples() {
        RDD result;
        RddRdfLoader<Triple> loader = RddRdfLoaderRegistryImpl.get().find(this.lang, Triple.class);
        if (loader != null) {
            result = loader.load(this.sparkSession.sparkContext(), this.path.toString());
        } else {
            if (RDFLanguages.isTriples((Lang)this.lang)) {
                throw new RuntimeException("No triple loader registered for " + this.lang);
            }
            result = this.asQuads().toJavaRDD().map(Quad::asTriple).rdd();
        }
        return result;
    }

    @Override
    public RDD<Model> asModels() {
        RddRdfLoader<Model> loader = RddRdfLoaderRegistryImpl.get().find(this.lang, Model.class);
        RDD result = loader != null ? loader.load(this.sparkSession.sparkContext(), this.path.toString()) : (RDFLanguages.isTriples((Lang)this.lang) ? JavaRddOfTriplesOps.groupBySubjects((JavaRDD<Triple>)this.asTriples().toJavaRDD()).values().rdd() : JavaRddOfQuadsOps.groupByNamedGraph((JavaRDD<Quad>)this.asQuads().toJavaRDD()).values().rdd());
        return result;
    }

    @Override
    public RDD<Quad> asQuads() {
        RDD result;
        RddRdfLoader<Quad> loader = RddRdfLoaderRegistryImpl.get().find(this.lang, Quad.class);
        if (loader != null) {
            result = loader.load(this.sparkSession.sparkContext(), this.path.toString());
        } else if (RDFLanguages.isTriples((Lang)this.lang)) {
            result = this.asTriples().toJavaRDD().map((Function & Serializable)t -> new Quad(Quad.defaultGraphNodeGenerated, t)).rdd();
        } else {
            throw new RuntimeException("No quad loader registered for " + this.lang);
        }
        return result;
    }

    @Override
    public RDD<DatasetOneNg> asDatasets() {
        RddRdfLoader<DatasetOneNg> loader = RddRdfLoaderRegistryImpl.get().find(this.lang, DatasetOneNg.class);
        RDD result = loader != null ? loader.load(this.sparkSession.sparkContext(), this.path.toString()) : (RDFLanguages.isTriples((Lang)this.lang) ? JavaRddOfNamedModelsOps.mapToDatasets(JavaRddOfTriplesOps.groupBySubjects((JavaRDD<Triple>)this.asTriples().toJavaRDD())).rdd() : JavaRddOfNamedModelsOps.mapToDatasets(JavaRddOfQuadsOps.groupByNamedGraph((JavaRDD<Quad>)this.asQuads().toJavaRDD())).rdd());
        return result;
    }

    public static <T> RddRdfLoader<T> requireLoader(Lang lang, Class<T> clazz) {
        RddRdfLoader<T> loader = RddRdfLoaderRegistryImpl.get().find(lang, clazz);
        if (loader == null) {
            throw new RuntimeException("No quad loader registered for " + lang + " as " + clazz);
        }
        return loader;
    }

    @Override
    public Model peekDeclaredPrefixes() {
        Model result;
        String pathStr = this.path.toString();
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            RddRdfLoader<Triple> loader = RdfSourceFromResourceImpl.requireLoader(this.lang, Triple.class);
            result = loader.peekPrefixes(this.sparkSession.sparkContext(), pathStr);
        } else if (RDFLanguages.isQuads((Lang)this.lang)) {
            RddRdfLoader<Quad> loader = RdfSourceFromResourceImpl.requireLoader(this.lang, Quad.class);
            result = loader.peekPrefixes(this.sparkSession.sparkContext(), pathStr);
        } else {
            logger.warn("Lang is neither triples nor quads; returning empty set of prefixes");
            result = ModelFactory.createDefaultModel();
        }
        return result;
    }
}

