/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sansa_stack.spark.io.rdf.input.api.NodeTupleSource;
import net.sansa_stack.spark.io.rdf.input.api.RdfSource;
import net.sansa_stack.spark.io.rdf.input.api.RdfSourceCollection;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.sparql.core.Quad;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;

public class RdfSourceCollectionImpl
implements RdfSourceCollection {
    public static final Lang MIXED_TRIPLE = LangBuilder.create((String)"mixed-triple", (String)"mixed-triple").build();
    public static final Lang MIXED_QUAD = LangBuilder.create((String)"mixed-quad", (String)"mixed-quad").build();
    protected SparkSession sparkSession;
    protected Collection<RdfSource> members;

    public RdfSourceCollectionImpl(SparkSession sparkSession) {
        this(sparkSession, new ArrayList<RdfSource>());
    }

    public RdfSourceCollectionImpl(SparkSession sparkSession, Collection<RdfSource> members) {
        this.sparkSession = sparkSession;
        this.members = members;
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public void add(RdfSource rdfSource) {
        this.members.add(rdfSource);
    }

    @Override
    public Collection<RdfSource> getMembers() {
        return this.members;
    }

    @Override
    public int getComponentCount() {
        int result = this.members.stream().mapToInt(NodeTupleSource::getComponentCount).max().orElse(3);
        return result;
    }

    public static <I, T> RDD<T> union(SparkSession sparkSession, Collection<I> members, Function<I, RDD<T>> mapper) {
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        RDD result = jsc.union(members.stream().map(mapper::apply).map(RDD::toJavaRDD).collect(Collectors.toList()).toArray(new JavaRDD[0])).rdd();
        return result;
    }

    @Override
    public RDD<Triple> asTriples() {
        return RdfSourceCollectionImpl.union(this.sparkSession, this.members, RdfSource::asTriples);
    }

    @Override
    public RDD<Quad> asQuads() {
        return RdfSourceCollectionImpl.union(this.sparkSession, this.members, RdfSource::asQuads);
    }

    @Override
    public RDD<Model> asModels() {
        return RdfSourceCollectionImpl.union(this.sparkSession, this.members, RdfSource::asModels);
    }

    @Override
    public RDD<DatasetOneNg> asDatasets() {
        return RdfSourceCollectionImpl.union(this.sparkSession, this.members, RdfSource::asDatasets);
    }

    @Override
    public Model peekDeclaredPrefixes() {
        Model result = ModelFactory.createDefaultModel();
        for (RdfSource source : this.members) {
            Model contrib = source.peekDeclaredPrefixes();
            if (contrib == null) continue;
            result.add(contrib);
        }
        return result;
    }
}

