/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.api;

import net.sansa_stack.spark.io.rdf.input.api.RdfSourceCollection;
import net.sansa_stack.spark.io.rdf.input.api.RdfSourceFromResource;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.jena.riot.Lang;

public interface RdfSourceFactory {
    default public RdfSourceFromResource get(String sourceStr) {
        return this.get(sourceStr, (Lang)null);
    }

    default public RdfSourceFromResource get(String sourceStr, Lang lang) {
        Path path = new Path(sourceStr);
        return this.get(path, null, lang);
    }

    default public RdfSourceFromResource get(String sourceStr, FileSystem fileSystem) {
        Path path = new Path(sourceStr);
        return this.get(path, fileSystem, null);
    }

    default public RdfSourceFromResource get(Path path, FileSystem fileSystem, Lang lang) {
        try {
            return this.create(path, fileSystem, lang);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RdfSourceFromResource create(Path var1, FileSystem var2, Lang var3) throws Exception;

    public RdfSourceCollection newRdfSourceCollection();
}

