/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.api;

import java.io.Serializable;
import net.sansa_stack.hadoop.core.InputFormatStats;
import net.sansa_stack.spark.io.rdf.input.api.HadoopInputData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class InputFormatUtils {
    public static HadoopInputData<LongWritable, Resource, JavaRDD<Model>> wrapWithAnalyzer(HadoopInputData<?, ?, ?> hid) {
        Class<InputFormat<?, ?>> inputFormatClass = hid.getInputFormatClass();
        Configuration conf = hid.getConfiguration();
        String delegateClassName = inputFormatClass.getName();
        conf.set("sansa.delegate", delegateClassName);
        String path = hid.getPath();
        return new HadoopInputData<LongWritable, Resource, JavaRDD<Model>>(path, InputFormatStats.class, LongWritable.class, Resource.class, conf, javaPairRdd -> javaPairRdd.map((Function & Serializable)x -> ((Resource)x._2).getModel()));
    }

    public static <K, V, X> X createRdd(JavaSparkContext sc, HadoopInputData<K, V, X> inputData) {
        JavaPairRDD pairRdd = sc.newAPIHadoopFile(inputData.getPath(), inputData.getInputFormatClass(), inputData.getKeyClass(), inputData.getValueClass(), inputData.getConfiguration());
        X result = inputData.getMapper().apply(pairRdd);
        return result;
    }
}

