/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.spark.io.rdf.input.api;

import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.api.java.JavaPairRDD;

public class HadoopInputData<K, V, X> {
    protected String path;
    protected Class<? extends InputFormat<K, V>> inputFormatClass;
    protected Class<K> keyClass;
    protected Class<V> valueClass;
    protected Configuration configuration;
    protected Function<JavaPairRDD<K, V>, X> mapper;

    public HadoopInputData(String path, Class<? extends InputFormat<K, V>> inputFormatClass, Class<K> keyClass, Class<V> valueClass, Configuration configuration, Function<JavaPairRDD<K, V>, X> mapper) {
        this.path = path;
        this.inputFormatClass = inputFormatClass;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.configuration = configuration;
        this.mapper = mapper;
    }

    public String getPath() {
        return this.path;
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public Class<? extends InputFormat<K, V>> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Function<JavaPairRDD<K, V>, X> getMapper() {
        return this.mapper;
    }

    public <Y> HadoopInputData<K, V, Y> map(Function<? super X, Y> nextMapper) {
        return new HadoopInputData<K, V, Y>(this.path, this.inputFormatClass, this.keyClass, this.valueClass, this.configuration, this.mapper.andThen(nextMapper));
    }
}

