/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import net.sansa_stack.rdf.spark.utils.Logging;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.api.Symbols;
import scala.reflect.api.Types;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class ScalaUtils$
implements Logging {
    public static ScalaUtils$ MODULE$;
    private transient Logger net$sansa_stack$rdf$spark$utils$Logging$$log_;

    static {
        new ScalaUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger net$sansa_stack$rdf$spark$utils$Logging$$log_() {
        return this.net$sansa_stack$rdf$spark$utils$Logging$$log_;
    }

    @Override
    public void net$sansa_stack$rdf$spark$utils$Logging$$log__$eq(Logger x$1) {
        this.net$sansa_stack$rdf$spark$utils$Logging$$log_ = x$1;
    }

    public Types.TypeApi getScalaType(Class<?> cls) {
        Symbols.ClassSymbolApi classSymbol = package$.MODULE$.universe().runtimeMirror(cls.getClassLoader()).classSymbol(cls);
        Types.TypeApi result = classSymbol.toType();
        return result;
    }

    public <T> T tryOrIOException(Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", iOException);
                throw iOException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", e);
                throw new IOException(e);
            }
            throw throwable;
        }
        return (T)object;
    }

    public <R extends Closeable, T> Try<T> tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        return this.cleanly(createResource.apply(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        }, f);
    }

    public <A, B> Try<B> cleanly(A resource, Function1<A, BoxedUnit> cleanup, Function1<A, B> doWork) {
        Success success;
        try {
            try {
                success = new Success(doWork.apply(resource));
            }
            catch (Exception e) {
                success = new Failure((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (resource != null) {
                    cleanup.apply(resource);
                }
            }
            catch (Exception e) {
                Predef$.MODULE$.println((Object)e);
            }
            throw throwable;
        }
        Success success2 = success;
        try {
            if (resource != null) {
                cleanup.apply(resource);
            }
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)e);
        }
        return success2;
    }

    public <R> R time(Function0<Tuple2<String, R>> block) {
        long t0 = System.nanoTime();
        Object result = ((Tuple2)block.apply())._2();
        long t1 = System.nanoTime();
        Predef$.MODULE$.println((Object)new StringBuilder(19).append(((Tuple2)block.apply())._1()).append(" - Elapsed time: ").append((double)(t1 - t0) / 1.0E7).append("ms").toString());
        return (R)result;
    }

    public <R> R time(String message, Function0<R> block) {
        return this.time((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)message, block.apply()));
    }

    public <R> R time(String startedMessage, String finishedMessage, Function0<R> block) {
        Predef$.MODULE$.println((Object)startedMessage);
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        Predef$.MODULE$.println((Object)new StringBuilder(17).append(finishedMessage).append("\nElapsed time: ").append((double)(t1 - t0) / 1.0E7).append("ms").toString());
        return (R)result;
    }

    public <R> R time(String startedMessage, String finishedMessage, Logger logger, Function0<R> block) {
        logger.debug(startedMessage);
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        logger.debug(new StringBuilder(17).append(finishedMessage).append("\nElapsed time: ").append((double)(t1 - t0) / 1.0E7).append("ms").toString());
        return (R)result;
    }

    public <R> R time(String startedMessage, String finishedMessage, com.typesafe.scalalogging.Logger logger, Function0<R> block) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (logger.underlying().isDebugEnabled()) {
            logger.underlying().debug(startedMessage);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        if (logger.underlying().isDebugEnabled()) {
            logger.underlying().debug(new StringBuilder(17).append(finishedMessage).append("\nElapsed time: ").append((double)(t1 - t0) / 1.0E7).append("ms").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (R)result;
    }

    public String unQuote(String s, char quoteChar) {
        return StringUtils.unwrap((String)s, (char)quoteChar);
    }

    public char unQuote$default$2() {
        return '\"';
    }

    private ScalaUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

