/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.stats;

import java.io.Serializable;
import java.io.StringWriter;
import net.sansa_stack.rdf.spark.model.package$;
import net.sansa_stack.rdf.spark.stats.DistinctEntities$;
import net.sansa_stack.rdf.spark.stats.DistinctObjects$;
import net.sansa_stack.rdf.spark.stats.DistinctSubjects$;
import net.sansa_stack.rdf.spark.stats.PropertyUsage$;
import net.sansa_stack.rdf.spark.stats.SPO_Vocabularies$;
import net.sansa_stack.rdf.spark.stats.Used_Classes$;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.apache.spark.graphx.Graph;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction2;

public final class RDFStatistics$
implements scala.Serializable {
    public static RDFStatistics$ MODULE$;
    private final transient SparkSession spark;

    static {
        new RDFStatistics$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public RDD<String> run(RDD<Triple> triples) {
        return Used_Classes$.MODULE$.apply(triples, this.spark()).Voidify().union(DistinctEntities$.MODULE$.apply(triples, this.spark()).Voidify()).union(DistinctSubjects$.MODULE$.apply(triples, this.spark()).Voidify()).union(DistinctObjects$.MODULE$.apply(triples, this.spark()).Voidify()).union(PropertyUsage$.MODULE$.apply(triples, this.spark()).Voidify()).union(SPO_Vocabularies$.MODULE$.apply(triples, this.spark()).Voidify());
    }

    public void voidify(RDD<String> stats, String source, String output) {
        StringWriter pw = new StringWriter();
        String prefix = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n                    @prefix void: <http://rdfs.org/ns/void#> .\n                    @prefix void-ext: <http://stats.lod2.eu/rdf/void-ext/> .\n                    @prefix qb: <http://purl.org/linked-data/cube#> .\n                    @prefix dcterms: <http://purl.org/dc/terms/> .\n                    @prefix ls-void: <http://stats.lod2.eu/rdf/void/> .\n                    @prefix ls-qb: <http://stats.lod2.eu/rdf/qb/> .\n                    @prefix ls-cr: <http://stats.lod2.eu/rdf/qb/criteria/> .\n                    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n                    @prefix xstats: <http://example.org/XStats#> .\n                    @prefix foaf: <http://xmlns.com/foaf/0.1/> .\n                    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .";
        String src = new StringBuilder(42).append("\n<http://stats.lod2.eu/rdf/void/?source=").append(source).append(">\n").toString();
        String end = "\na void:Dataset .";
        String voidify = prefix.concat(src).concat(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stats.coalesce(1, true, stats.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).collect())).mkString()).concat(end);
        Predef$.MODULE$.println((Object)new StringBuilder(1).append("\n").append(voidify).toString());
        pw.write(voidify);
        RDD vidifyStats = this.spark().sparkContext().parallelize((Seq)new .colon.colon((Object)pw.toString(), (List)Nil$.MODULE$), this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        vidifyStats.coalesce(1, true, vidifyStats.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).saveAsTextFile(output);
    }

    public void print(RDD<String> stats, String source) {
        String prefix = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n                    @prefix void: <http://rdfs.org/ns/void#> .\n                    @prefix void-ext: <http://stats.lod2.eu/rdf/void-ext/> .\n                    @prefix qb: <http://purl.org/linked-data/cube#> .\n                    @prefix dcterms: <http://purl.org/dc/terms/> .\n                    @prefix ls-void: <http://stats.lod2.eu/rdf/void/> .\n                    @prefix ls-qb: <http://stats.lod2.eu/rdf/qb/> .\n                    @prefix ls-cr: <http://stats.lod2.eu/rdf/qb/criteria/> .\n                    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n                    @prefix xstats: <http://example.org/XStats#> .\n                    @prefix foaf: <http://xmlns.com/foaf/0.1/> .\n                    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .";
        String src = new StringBuilder(42).append("\n<http://stats.lod2.eu/rdf/void/?source=").append(source).append(">\n").toString();
        String end = "\na void:Dataset .";
        String voidify = prefix.concat(src).concat(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stats.coalesce(1, true, stats.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).collect())).mkString()).concat(end);
        Predef$.MODULE$.println((Object)new StringBuilder(1).append("\n").append(voidify).toString());
    }

    public RDD<Tuple2<Iterable<Triple>, Object>> PropertyUsageDistinctPerSubject(RDD<Triple> triples) {
        RDD x$12 = triples.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSubject(), ClassTag$.MODULE$.apply(Node.class)).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(((TraversableLike)f._2()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$PropertyUsageDistinctPerSubject$3(p))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$22 = ClassTag$.MODULE$.apply(Iterable.class);
        ClassTag x$32 = ClassTag$.MODULE$.Int();
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$12);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$12, x$22, x$32, null).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 + x$3);
    }

    public RDD<Tuple2<Iterable<Triple>, Object>> PropertyUsageDistinctPerObject(RDD<Triple> triples) {
        RDD x$1 = triples.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getObject(), ClassTag$.MODULE$.apply(Node.class)).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(((TraversableLike)f._2()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$PropertyUsageDistinctPerObject$3(p))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$2 = ClassTag$.MODULE$.apply(Iterable.class);
        ClassTag x$3 = ClassTag$.MODULE$.Int();
        Null$ x$42 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6);
    }

    public RDD<Tuple2<Node, Object>> ClassHierarchyDepth(RDD<Triple> triples) {
        RDD subClassOf = triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$ClassHierarchyDepth$1(triple)));
        RDD root = triples.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$ClassHierarchyDepth$2(t)));
        Graph<Node, Node> graph = package$.MODULE$.GraphLoader(triples).asGraph();
        Graph<Node, Node> subClassOfGraph = package$.MODULE$.GraphLoader((RDD<Triple>)subClassOf).asGraph();
        subClassOfGraph.cache();
        Graph<Tuple3<Object, Object, Node>, Node> hrchyGraph = package$.MODULE$.GraphOperations(subClassOfGraph).hierarcyDepth();
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(graph.vertices().keyBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._1$mcJ$sp())), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join((RDD)hrchyGraph.vertices()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 v = (Tuple2)tuple2._2();
                return new Tuple2(((Tuple2)v._1())._2(), ((Tuple3)v._2())._2());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp());
        boolean x$2 = false;
        int x$3 = qual$1.sortBy$default$3();
        return qual$1.sortBy((Function1)x$1, x$2, x$3, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int());
    }

    public RDD<Tuple2<Node, Object>> PropertyHierarchyDepth(RDD<Triple> triples) {
        RDD subPropertyOf = triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$PropertyHierarchyDepth$1(triple)));
        RDD root = triples.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$PropertyHierarchyDepth$2(t)));
        Graph<Node, Node> graph = package$.MODULE$.GraphLoader(triples).asGraph();
        Graph<Node, Node> subPropertyOfGraph = package$.MODULE$.GraphLoader((RDD<Triple>)subPropertyOf).asGraph();
        subPropertyOfGraph.cache();
        Graph<Tuple3<Object, Object, Node>, Node> hrchyGraph = package$.MODULE$.GraphOperations(subPropertyOfGraph).hierarcyDepth();
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(graph.vertices().keyBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9._1$mcJ$sp())), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join((RDD)hrchyGraph.vertices()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 v = (Tuple2)tuple2._2();
                return new Tuple2(((Tuple2)v._1())._2(), ((Tuple3)v._2())._2());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10._2$mcI$sp());
        boolean x$2 = false;
        int x$3 = qual$1.sortBy$default$3();
        return qual$1.sortBy((Function1)x$1, x$2, x$3, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int());
    }

    public long SubclassUsage(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)triple.predicateMatches(RDFS.subClassOf.asNode()))).count();
    }

    public long Triples(RDD<Triple> triples) {
        return triples.count();
    }

    public long EntitiesMentioned(RDD<Triple> triples) {
        return triples.flatMap((Function1 & Serializable & scala.Serializable)t -> (Seq)new .colon.colon((Object)t.getSubject(), (List)new .colon.colon((Object)t.getPredicate(), (List)new .colon.colon((Object)t.getObject(), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Node.class)).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isURI())).distinct().count();
    }

    public RDD<Triple> Literals(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$Literals$1(x$12)));
    }

    public RDD<Triple> BlanksAsSubject(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$BlanksAsSubject$1(x$13)));
    }

    public RDD<Triple> BlanksAsObject(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$BlanksAsObject$1(x$14)));
    }

    public RDD<Tuple2<String, Object>> Datatypes(RDD<Triple> triples) {
        return RDD$.MODULE$.rddToPairRDDFunctions(triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$Datatypes$1(triple))).map((Function1 & Serializable & scala.Serializable)triple -> new Tuple2((Object)triple.getObject().getLiteralDatatype().getURI(), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$15, x$16) -> x$15 + x$16);
    }

    public RDD<Tuple2<String, Object>> Languages(RDD<Triple> triples) {
        return RDD$.MODULE$.rddToPairRDDFunctions(triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$Languages$1(triple))).map((Function1 & Serializable & scala.Serializable)triple -> new Tuple2((Object)triple.getObject().getLiteralLanguage(), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$17, x$18) -> x$17 + x$18);
    }

    public double AvgTypedStringLength(RDD<Triple> triples) {
        return RDD$.MODULE$.numericRDDToDoubleRDDFunctions(triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$AvgTypedStringLength$1(triple))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)RDFStatistics$.$anonfun$AvgTypedStringLength$2(x$19)), ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).mean();
    }

    public double AvgUntypedStringLength(RDD<Triple> triples) {
        return RDD$.MODULE$.numericRDDToDoubleRDDFunctions(triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$AvgUntypedStringLength$1(triple))).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)RDFStatistics$.$anonfun$AvgUntypedStringLength$2(x$20)), ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).mean();
    }

    public RDD<Node> TypedSubjects(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)triple.predicateMatches(RDF.type.asNode()))).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.getSubject(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> LabeledSubjects(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)triple.predicateMatches(RDFS.label.asNode()))).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.getSubject(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Triple> SameAs(RDD<Triple> triples) {
        return triples.filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.predicateMatches(OWL.sameAs.asNode())));
    }

    public RDD<Tuple3<String, String, Object>> Links(RDD<Triple> triples) {
        return RDD$.MODULE$.rddToPairRDDFunctions(triples.filter((Function1 & Serializable & scala.Serializable)triple -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$Links$1(triple))).map((Function1 & Serializable & scala.Serializable)triple -> new Tuple2((Object)new Tuple2((Object)triple.getSubject().getNameSpace(), (Object)triple.getObject().getNameSpace()), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Int(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$24, x$25) -> x$24 + x$25).map((Function1 & Serializable & scala.Serializable)e -> new Tuple3(((Tuple2)e._1())._1(), ((Tuple2)e._1())._2(), (Object)BoxesRunTime.boxToInteger((int)e._2$mcI$sp())), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public RDD<Tuple2<Node, Node>> MaxPerProperty(RDD<Triple> triples) {
        RDD x$1 = triples.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$MaxPerProperty$1(t))).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)t.getPredicate(), (Object)t.getObject()), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$2 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$3 = ClassTag$.MODULE$.apply(Node.class);
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).reduceByKey((Function2 & Serializable & scala.Serializable)(n1, n2) -> {
            int ret = NodeValue.compare((NodeValue)NodeValue.makeNode((Node)n1), (NodeValue)NodeValue.makeNode((Node)n2));
            if (ret > 0) {
                return n1;
            }
            return n2;
        });
    }

    public RDD<Tuple2<Node, Object>> AvgPerProperty(RDD<Triple> triples) {
        RDD x$1 = triples.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RDFStatistics$.$anonfun$AvgPerProperty$1(t))).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)t.getPredicate(), (Object)t.getObject()), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$2 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$3 = ClassTag$.MODULE$.apply(Node.class);
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).aggregateByKey((Object)new Tuple2.mcDI.sp(0.0, 0), (Function2 & Serializable & scala.Serializable)(elt, node) -> new Tuple2.mcDI.sp(elt._1$mcD$sp() + NodeValue.makeNode((Node)node).getDouble(), elt._2$mcI$sp() + 1), (Function2 & Serializable & scala.Serializable)(elt1, elt2) -> new Tuple2.mcDI.sp(elt1._1$mcD$sp() + elt2._1$mcD$sp(), elt1._2$mcI$sp() + elt2._2$mcI$sp()), ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e._1(), (Object)BoxesRunTime.boxToDouble((double)(((Tuple2)e._2())._1$mcD$sp() / (double)((Tuple2)e._2())._2$mcI$sp()))), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$PropertyUsageDistinctPerSubject$3(Triple p) {
        return new StringOps(Predef$.MODULE$.augmentString(p.getPredicate().getLiteralLexicalForm())).contains((Object)p);
    }

    public static final /* synthetic */ boolean $anonfun$PropertyUsageDistinctPerObject$3(Triple p) {
        return new StringOps(Predef$.MODULE$.augmentString(p.getPredicate().getLiteralLexicalForm())).contains((Object)p);
    }

    public static final /* synthetic */ boolean $anonfun$ClassHierarchyDepth$1(Triple triple) {
        return triple.predicateMatches(RDFS.subClassOf.asNode()) && triple.getSubject().isURI() && triple.getObject().isURI();
    }

    public static final /* synthetic */ boolean $anonfun$ClassHierarchyDepth$2(Triple t) {
        return t.getObject().isURI() && t.objectMatches(OWL.Class.asNode());
    }

    public static final /* synthetic */ boolean $anonfun$PropertyHierarchyDepth$1(Triple triple) {
        return triple.predicateMatches(RDFS.subPropertyOf.asNode()) && triple.getSubject().isURI() && triple.getObject().isURI();
    }

    public static final /* synthetic */ boolean $anonfun$PropertyHierarchyDepth$2(Triple t) {
        return t.getObject().isURI() && t.objectMatches(OWL.Class.asNode());
    }

    public static final /* synthetic */ boolean $anonfun$Literals$1(Triple x$12) {
        return x$12.getObject().isLiteral();
    }

    public static final /* synthetic */ boolean $anonfun$BlanksAsSubject$1(Triple x$13) {
        return x$13.getSubject().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$BlanksAsObject$1(Triple x$14) {
        return x$14.getObject().isBlank();
    }

    public static final /* synthetic */ boolean $anonfun$Datatypes$1(Triple triple) {
        return triple.getObject().isLiteral() && !triple.getObject().getLiteralDatatype().getURI().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$Languages$1(Triple triple) {
        return triple.getObject().isLiteral() && !triple.getObject().getLiteralLanguage().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$AvgTypedStringLength$1(Triple triple) {
        return triple.getObject().isLiteral() && triple.getObject().getLiteralDatatypeURI().equals(XSD.xstring.getURI());
    }

    public static final /* synthetic */ int $anonfun$AvgTypedStringLength$2(Triple x$19) {
        return x$19.getObject().getLiteralLexicalForm().length();
    }

    public static final /* synthetic */ boolean $anonfun$AvgUntypedStringLength$1(Triple triple) {
        return triple.getObject().isLiteral() && !triple.getObject().getLiteralLanguage().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$AvgUntypedStringLength$2(Triple x$20) {
        return x$20.getObject().getLiteralLexicalForm().length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$Links$1(Triple triple) {
        if (!triple.getSubject().isURI()) return false;
        if (!triple.getObject().isURI()) return false;
        String string = triple.getSubject().getNameSpace();
        String string2 = triple.getObject().getNameSpace();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$MaxPerProperty$1(Triple t) {
        return t.getObject().isLiteral();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$AvgPerProperty$1(Triple t) {
        if (!t.getObject().isLiteral()) return false;
        RDFDatatype rDFDatatype = t.getObject().getLiteralDatatype();
        XSDDatatype xSDDatatype = XSDDatatype.XSDint;
        if (rDFDatatype == null) {
            if (xSDDatatype == null) return true;
        } else if (rDFDatatype.equals(xSDDatatype)) return true;
        RDFDatatype rDFDatatype2 = t.getObject().getLiteralDatatype();
        XSDDatatype xSDDatatype2 = XSDDatatype.XSDinteger;
        if (rDFDatatype2 == null) {
            if (xSDDatatype2 == null) return true;
        } else if (rDFDatatype2.equals(xSDDatatype2)) return true;
        RDFDatatype rDFDatatype3 = t.getObject().getLiteralDatatype();
        XSDDatatype xSDDatatype3 = XSDDatatype.XSDshort;
        if (rDFDatatype3 == null) {
            if (xSDDatatype3 == null) return true;
        } else if (rDFDatatype3.equals(xSDDatatype3)) return true;
        RDFDatatype rDFDatatype4 = t.getObject().getLiteralDatatype();
        XSDDatatype xSDDatatype4 = XSDDatatype.XSDdecimal;
        if (rDFDatatype4 == null) {
            if (xSDDatatype4 == null) return true;
        } else if (rDFDatatype4.equals(xSDDatatype4)) return true;
        RDFDatatype rDFDatatype5 = t.getObject().getLiteralDatatype();
        XSDDatatype xSDDatatype5 = XSDDatatype.XSDfloat;
        if (rDFDatatype5 == null) {
            if (xSDDatatype5 == null) return true;
        } else if (rDFDatatype5.equals(xSDDatatype5)) return true;
        RDFDatatype rDFDatatype6 = t.getObject().getLiteralDatatype();
        XSDDatatype xSDDatatype6 = XSDDatatype.XSDdouble;
        if (rDFDatatype6 != null) {
            if (!rDFDatatype6.equals(xSDDatatype6)) return false;
            return true;
        }
        if (xSDDatatype6 == null) return true;
        return false;
    }

    private RDFStatistics$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

