/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.rdd.op;

import java.io.Serializable;
import net.sansa_stack.rdf.common.io.ntriples.JenaTripleToNTripleString;
import net.sansa_stack.rdf.spark.utils.NodeUtils$;
import net.sansa_stack.rdf.spark.utils.SchemaUtils$;
import net.sansa_stack.rdf.spark.utils.SparkSessionUtils$;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RddOfTriplesOps$ {
    public static RddOfTriplesOps$ MODULE$;

    static {
        new RddOfTriplesOps$();
    }

    public Dataset<Row> toDF(RDD<Triple> triples) {
        SparkSession spark = SparkSessionUtils$.MODULE$.getSessionFromRdd(triples);
        StructType schema = SchemaUtils$.MODULE$.SQLSchemaDefault();
        RDD rowRDD = triples.map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NodeUtils$.MODULE$.getNodeValue(t.getSubject()), NodeUtils$.MODULE$.getNodeValue(t.getPredicate()), NodeUtils$.MODULE$.getNodeValue(t.getObject())})), ClassTag$.MODULE$.apply(Row.class));
        Dataset df = spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("TRIPLES");
        return df;
    }

    public Dataset<Triple> toDS(RDD<Triple> triples) {
        SparkSession spark = SparkSessionUtils$.MODULE$.getSessionFromRdd(triples);
        Encoder encoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        return spark.createDataset(triples, encoder);
    }

    public RDD<Node> getSubjects(RDD<Triple> triples) {
        return triples.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSubject(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getPredicates(RDD<Triple> triples) {
        return triples.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPredicate(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getObjects(RDD<Triple> triples) {
        return triples.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getObject(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Triple> filterSubjects(RDD<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RddOfTriplesOps$.$anonfun$filterSubjects$1(func, f)));
    }

    public RDD<Triple> filterPredicates(RDD<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RddOfTriplesOps$.$anonfun$filterPredicates$1(func, f)));
    }

    public RDD<Triple> filterPredicates(RDD<Triple> triples, Set<String> predicateIris) {
        return triples.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)predicateIris.contains((Object)f.getPredicate().getURI())));
    }

    public RDD<Triple> filterObjects(RDD<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RddOfTriplesOps$.$anonfun$filterObjects$1(func, f)));
    }

    public RDD<Triple> find(RDD<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return triples.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RddOfTriplesOps$.$anonfun$find$1(subject, predicate, object, t)));
    }

    public RDD<Triple> find(RDD<Triple> triples, Triple triple) {
        return this.find(triples, (Option<Node>)(triple.getSubject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getSubject())), (Option<Node>)(triple.getPredicate().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getPredicate())), (Option<Node>)(triple.getObject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getObject())));
    }

    public Option<Node> find$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$4() {
        return None$.MODULE$;
    }

    public RDD<Triple> unionAll(RDD<Triple> triples, Seq<RDD<Triple>> others) {
        RDD first = (RDD)others.head();
        return first.sparkContext().union(triples, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[0]), ClassTag$.MODULE$.apply(Triple.class));
    }

    public boolean contains(RDD<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return this.find(triples, subject, predicate, object).count() > 0L;
    }

    public boolean contains(RDD<Triple> triples, Triple triple) {
        return this.find(triples, triple).count() > 0L;
    }

    public Option<Node> contains$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$4() {
        return None$.MODULE$;
    }

    public boolean containsAny(RDD<Triple> g1, RDD<Triple> g2) {
        return g1.intersection(g2).count() > 0L;
    }

    public boolean containsAll(RDD<Triple> g1, RDD<Triple> g2) {
        return g2.subtract(g1).isEmpty();
    }

    public RDD<Triple> add(RDD<Triple> triples, Triple triple) {
        SparkSession spark = SparkSessionUtils$.MODULE$.getSessionFromRdd(triples);
        RDD statement = spark.sparkContext().parallelize((Seq)new .colon.colon((Object)triple, (List)Nil$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return triples.union(statement);
    }

    public RDD<Triple> addAll(RDD<Triple> triples, Seq<Triple> triple) {
        SparkSession spark = SparkSessionUtils$.MODULE$.getSessionFromRdd(triples);
        RDD statements = spark.sparkContext().parallelize(triple, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return triples.union(statements);
    }

    public RDD<Triple> remove(RDD<Triple> triples, Triple triple) {
        SparkSession spark = SparkSessionUtils$.MODULE$.getSessionFromRdd(triples);
        RDD statement = spark.sparkContext().parallelize((Seq)new .colon.colon((Object)triple, (List)Nil$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return triples.subtract(statement);
    }

    public RDD<Triple> removeAll(RDD<Triple> triples, Seq<Triple> triple) {
        SparkSession spark = SparkSessionUtils$.MODULE$.getSessionFromRdd(triples);
        RDD statements = spark.sparkContext().parallelize(triple, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return triples.subtract(statements);
    }

    public void saveAsNTriplesFile(RDD<Triple> triples, String path) {
        triples.map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(path);
    }

    public Graph toGraph(Graph outGraph, RDD<Triple> triples) {
        Triple[] col = (Triple[])triples.collect();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            outGraph.add(x$1);
            return BoxedUnit.UNIT;
        });
        return outGraph;
    }

    public static final /* synthetic */ boolean $anonfun$filterSubjects$1(Function1 func$1, Triple f) {
        return BoxesRunTime.unboxToBoolean((Object)func$1.apply((Object)f.getSubject()));
    }

    public static final /* synthetic */ boolean $anonfun$filterPredicates$1(Function1 func$2, Triple f) {
        return BoxesRunTime.unboxToBoolean((Object)func$2.apply((Object)f.getPredicate()));
    }

    public static final /* synthetic */ boolean $anonfun$filterObjects$1(Function1 func$3, Triple f) {
        return BoxesRunTime.unboxToBoolean((Object)func$3.apply((Object)f.getSubject()));
    }

    public static final /* synthetic */ boolean $anonfun$find$1(Option subject$1, Option predicate$1, Option object$1, Triple t) {
        return !(!subject$1.isEmpty() && !t.getSubject().matches((Node)subject$1.get()) || !predicate$1.isEmpty() && !t.getPredicate().matches((Node)predicate$1.get()) || !object$1.isEmpty() && !t.getObject().matches((Node)object$1.get()));
    }

    private RddOfTriplesOps$() {
        MODULE$ = this;
    }
}

