/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.graph;

import java.io.Serializable;
import java.io.StringWriter;
import net.sansa_stack.rdf.spark.utils.NodeUtils$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.hashing.MurmurHash3$;

public final class GraphOps$ {
    public static GraphOps$ MODULE$;

    static {
        new GraphOps$();
    }

    public Graph<Node, Node> constructGraph(RDD<Triple> triples) {
        RDD tuples;
        RDD rs = triples.map((Function1 & Serializable & scala.Serializable)triple -> new Tuple3((Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject()), ClassTag$.MODULE$.apply(Tuple3.class));
        RDD indexedMap = rs.map((Function1 & Serializable & scala.Serializable)x$1 -> (Node)x$1._1(), ClassTag$.MODULE$.apply(Node.class)).union(rs.map((Function1 & Serializable & scala.Serializable)x$2 -> (Node)x$2._3(), ClassTag$.MODULE$.apply(Node.class))).distinct().zipWithUniqueId();
        RDD vertices = indexedMap.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp()), x._1()), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD x$12 = rs.keyBy((Function1 & Serializable & scala.Serializable)x$3 -> (Node)x$3._1());
        ClassTag x$22 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$32 = ClassTag$.MODULE$.apply(Tuple3.class);
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$12);
        RDD x$5 = tuples = RDD$.MODULE$.rddToPairRDDFunctions(x$12, x$22, x$32, null).join(indexedMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                long si = tuple2._2$mcJ$sp();
                if (tuple3 != null) {
                    Node p = (Node)tuple3._2();
                    Node o = (Node)tuple3._3();
                    return new Tuple2((Object)o, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)si), (Object)p));
                }
            }
            throw new MatchError((Object)tuple22);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$6 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$7 = ClassTag$.MODULE$.apply(Tuple2.class);
        Null$ x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
        RDD edges = RDD$.MODULE$.rddToPairRDDFunctions(x$5, x$6, x$7, null).join(indexedMap).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                long oi = tuple2._2$mcJ$sp();
                if (tuple23 != null) {
                    long si = tuple23._1$mcJ$sp();
                    Node p = (Node)tuple23._2();
                    return new Edge(si, oi, (Object)p);
                }
            }
            throw new MatchError((Object)tuple22);
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> constructHashedGraph(RDD<Triple> triples) {
        RDD rs = triples.map((Function1 & Serializable & scala.Serializable)triple -> new Tuple3((Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject()), ClassTag$.MODULE$.apply(Tuple3.class));
        RDD vertices = rs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                Node s = (Node)tuple3._1();
                Node p = (Node)tuple3._2();
                Node o = (Node)tuple3._3();
                if (s != null) {
                    Node node = s;
                    if (p != null) {
                        Node node2 = p;
                        if (o != null) {
                            Node node3 = o;
                            return (TraversableOnce)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphOps$.hash$1(node)), (Object)node), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphOps$.hash$1(node2)), (Object)node2), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphOps$.hash$1(node3)), (Object)node3), (List)Nil$.MODULE$)));
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = rs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 != null) {
                Node s = (Node)tuple3._1();
                Node p = (Node)tuple3._2();
                Node o = (Node)tuple3._3();
                if (s != null) {
                    Node node = s;
                    if (p != null) {
                        Node node2 = p;
                        if (o != null) {
                            Node node3 = o;
                            return new Edge(GraphOps$.hash$1(node), GraphOps$.hash$1(node3), (Object)node2);
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<String, String> constructStringGraph(RDD<Triple> triples) {
        RDD rs = triples.map((Function1 & Serializable & scala.Serializable)triple -> new Tuple3((Object)NodeUtils$.MODULE$.getNodeValue(triple.getSubject()), (Object)NodeUtils$.MODULE$.getNodeValue(triple.getPredicate()), (Object)NodeUtils$.MODULE$.getNodeValue(triple.getObject())), ClassTag$.MODULE$.apply(Tuple3.class));
        RDD indexedMap = rs.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1(), ClassTag$.MODULE$.apply(String.class)).union(rs.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._3(), ClassTag$.MODULE$.apply(String.class))).distinct().zipWithUniqueId();
        RDD vertices = indexedMap.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp()), x._1()), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD _nodeToId = indexedMap.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp())), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD tuples = RDD$.MODULE$.rddToPairRDDFunctions(rs.keyBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1()), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.String$.MODULE$).join(indexedMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                long si = tuple2._2$mcJ$sp();
                if (tuple3 != null) {
                    String p = (String)tuple3._2();
                    String o = (String)tuple3._3();
                    return new Tuple2((Object)o, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)si), (Object)p));
                }
            }
            throw new MatchError((Object)tuple22);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = RDD$.MODULE$.rddToPairRDDFunctions(tuples, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).join(indexedMap).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                long oi = tuple2._2$mcJ$sp();
                if (tuple23 != null) {
                    long si = tuple23._1$mcJ$sp();
                    String p = (String)tuple23._2();
                    return new Edge(si, oi, (Object)p);
                }
            }
            throw new MatchError((Object)tuple22);
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class));
    }

    public RDD<Triple> toRDD(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            EdgeTriplet edgeTriplet = x0$1;
            return Triple.create((Node)((Node)edgeTriplet.srcAttr()), (Node)((Node)edgeTriplet.attr()), (Node)((Node)edgeTriplet.dstAttr()));
        }, ClassTag$.MODULE$.apply(Triple.class));
    }

    public Dataset<Row> toDF(Graph<Node, Node> graph) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("subject", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("predicate", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("object", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        RDD rowRDD = this.toRDD(graph).map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getSubject(), t.getPredicate(), t.getObject()})), ClassTag$.MODULE$.apply(Row.class));
        Dataset df = spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("TRIPLES");
        return df;
    }

    public Dataset<Triple> toDS(Graph<Node, Node> graph) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Encoder encoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        return spark.createDataset(this.toRDD(graph), encoder);
    }

    public RDD<Triple> getTriples(Graph<Node, Node> graph) {
        return this.toRDD(graph);
    }

    public RDD<Node> getSubjects(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1 & Serializable & scala.Serializable)x$7 -> (Node)x$7.srcAttr(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getPredicates(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1 & Serializable & scala.Serializable)x$8 -> (Node)x$8.attr(), ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getObjects(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1 & Serializable & scala.Serializable)x$9 -> (Node)x$9.dstAttr(), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> find(Graph<Node, Node> graph, Node subject, Node predicate, Node object) {
        return graph.subgraph((Function1 & Serializable & scala.Serializable)triplet -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$find$1(subject, predicate, object, triplet)), (Function2 & Serializable & scala.Serializable)(x$10, x$11) -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$find$2(BoxesRunTime.unboxToLong((Object)x$10), x$11)));
    }

    public Graph<Node, Node> filterSubjects(Graph<Node, Node> graph, Function1<Node, Object> func) {
        return graph.subgraph((Function1 & Serializable & scala.Serializable)triplet -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$filterSubjects$1(func, triplet)), (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$filterSubjects$2(BoxesRunTime.unboxToLong((Object)x$12), x$13)));
    }

    public Graph<Node, Node> filterPredicates(Graph<Node, Node> graph, Function1<Node, Object> func) {
        return graph.subgraph((Function1 & Serializable & scala.Serializable)triplet -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$filterPredicates$1(func, triplet)), (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$filterPredicates$2(BoxesRunTime.unboxToLong((Object)x$14), x$15)));
    }

    public Graph<Node, Node> filterObjects(Graph<Node, Node> graph, Function1<Node, Object> func) {
        return graph.subgraph((Function1 & Serializable & scala.Serializable)triplet -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$filterObjects$1(func, triplet)), (Function2 & Serializable & scala.Serializable)(x$16, x$17) -> BoxesRunTime.boxToBoolean((boolean)GraphOps$.$anonfun$filterObjects$2(BoxesRunTime.unboxToLong((Object)x$16), x$17)));
    }

    public long size(Graph<Node, Node> graph) {
        return Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)).numEdges();
    }

    public Graph<Node, Node> union(Graph<Node, Node> graph, Graph<Node, Node> other) {
        return Graph$.MODULE$.apply(graph.vertices().union(other.vertices().distinct()), graph.edges().union(other.edges().distinct()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> intersection(Graph<Node, Node> graph, Graph<Node, Node> other) {
        return Graph$.MODULE$.apply(graph.vertices().intersection(other.vertices().distinct()), graph.edges().intersection(other.edges().distinct()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> difference(Graph<Node, Node> graph, Graph<Node, Node> other) {
        return Graph$.MODULE$.apply(graph.vertices().subtract(other.vertices().distinct()), graph.edges().subtract(other.edges().distinct()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Tuple3<Object, Object, Node>, Node> hierarcyDepth(Graph<Node, Node> graph) {
        Tuple3 initialMsg = new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToInteger((int)0), (Object)Node.ANY);
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(id, v) -> GraphOps$.$anonfun$hierarcyDepth$1(BoxesRunTime.unboxToLong((Object)id), v);
        ClassTag x$2 = ClassTag$.MODULE$.apply(Tuple3.class);
        Null$ x$3 = graph.mapVertices$default$3((Function2)x$1);
        Graph initialGraph = graph.mapVertices((Function2)x$1, x$2, null);
        return Graph$.MODULE$.graphToGraphOps(initialGraph, ClassTag$.MODULE$.apply(Tuple3.class), ClassTag$.MODULE$.apply(Node.class)).pregel((Object)initialMsg, Integer.MAX_VALUE, EdgeDirection$.MODULE$.Out(), (Function3 & Serializable & scala.Serializable)(vertexId, value, message) -> GraphOps$.setMsg$1(BoxesRunTime.unboxToLong((Object)vertexId), value, message), (Function1 & Serializable & scala.Serializable)triplet -> GraphOps$.sendMsg$1(triplet), (Function2 & Serializable & scala.Serializable)(msg1, msg2) -> GraphOps$.mergeMsg$1(msg1, msg2), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public void saveGraphToJson(Graph<?, ?> graph, String output) {
        StringWriter pw = new StringWriter();
        pw.write(this.toGraphJson(graph));
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        RDD graphAsJson = spark.sparkContext().parallelize((Seq)new .colon.colon((Object)pw.toString(), (List)Nil$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        graphAsJson.coalesce(1, true, graphAsJson.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).saveAsTextFile(output);
    }

    public String toGraphJson(Graph<?, ?> graph) {
        Tuple2[] verts = (Tuple2[])graph.vertices().collect();
        Edge[] edges = (Edge[])graph.edges().collect();
        Map nmap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])verts)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2.mcJI.sp(((Tuple2)v._1())._1$mcJ$sp(), v._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        String vtxt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])verts)).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(10).append("{\"val\":\"").append(v._2().toString()).append("\"}").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",\n");
        String etxt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(30).append("{\"source\":").append(nmap.apply((Object)BoxesRunTime.boxToLong((long)e.srcId())).toString()).append(",\"target\":").append(nmap.apply((Object)BoxesRunTime.boxToLong((long)e.dstId())).toString()).append(",\"value\":").append(e.attr().toString()).append("}").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",\n");
        return new StringBuilder(27).append("{ \"nodes\":[\n").append(vtxt).append("\n],\"links\":[").append(etxt).append("]\n}").toString();
    }

    private Map<Object, Object> makeMap(Seq<Tuple2<Object, Object>> x) {
        return (Map)Predef$.MODULE$.Map().apply(x);
    }

    private Map<Object, Object> incrementMap(Map<Object, Object> spmap) {
        return (Map)spmap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long v = tuple2._1$mcJ$sp();
                int d = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)v)), (Object)BoxesRunTime.boxToInteger((int)(d + 1)));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<Object, Object> addMaps(Map<Object, Object> spmap1, Map<Object, Object> spmap2) {
        return ((TraversableOnce)spmap1.keySet().$plus$plus((GenTraversableOnce)spmap2.keySet()).map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)k))), (Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToInt((Object)spmap1.getOrElse((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)k)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), BoxesRunTime.unboxToInt((Object)spmap2.getOrElse((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)k)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE))))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <VD, ED> Graph<Map<Object, Object>, ED> shortestPaths(Graph<VD, ED> graph, Seq<Object> landmarks, ClassTag<ED> evidence$1) {
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(vid, attr) -> GraphOps$.$anonfun$shortestPaths$1(landmarks, BoxesRunTime.unboxToLong((Object)vid), attr);
        ClassTag x$2 = ClassTag$.MODULE$.apply(Map.class);
        Null$ x$3 = graph.mapVertices$default$3((Function2)x$1);
        Graph spGraph = graph.mapVertices((Function2)x$1, x$2, null);
        Map<Object, Object> initialMessage = this.makeMap((Seq<Tuple2<Object, Object>>)Nil$.MODULE$);
        return Pregel$.MODULE$.apply(spGraph, initialMessage, Pregel$.MODULE$.apply$default$3(), Pregel$.MODULE$.apply$default$4(), (Function3 & Serializable & scala.Serializable)(id, attr, msg) -> this.vertexProgram$1(BoxesRunTime.unboxToLong((Object)id), attr, msg), (Function1 & Serializable & scala.Serializable)edge -> this.sendMessage$1((EdgeTriplet)edge), (Function2 & Serializable & scala.Serializable)(spmap1, spmap2) -> MODULE$.addMaps((Map<Object, Object>)spmap1, (Map<Object, Object>)spmap2), ClassTag$.MODULE$.apply(Map.class), evidence$1, ClassTag$.MODULE$.apply(Map.class));
    }

    private static final long hash$1(Node s) {
        return MurmurHash3$.MODULE$.stringHash(s.toString());
    }

    public static final /* synthetic */ boolean $anonfun$find$1(Node subject$1, Node predicate$1, Node object$1, EdgeTriplet triplet) {
        return ((Node)triplet.srcAttr()).matches(subject$1) && ((Node)triplet.attr()).matches(predicate$1) && ((Node)triplet.dstAttr()).matches(object$1);
    }

    public static final /* synthetic */ boolean $anonfun$find$2(long x$10, Node x$11) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filterSubjects$1(Function1 func$1, EdgeTriplet triplet) {
        return BoxesRunTime.unboxToBoolean((Object)func$1.apply(triplet.srcAttr()));
    }

    public static final /* synthetic */ boolean $anonfun$filterSubjects$2(long x$12, Node x$13) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filterPredicates$1(Function1 func$2, EdgeTriplet triplet) {
        return BoxesRunTime.unboxToBoolean((Object)func$2.apply(triplet.attr()));
    }

    public static final /* synthetic */ boolean $anonfun$filterPredicates$2(long x$14, Node x$15) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filterObjects$1(Function1 func$3, EdgeTriplet triplet) {
        return BoxesRunTime.unboxToBoolean((Object)func$3.apply(triplet.dstAttr()));
    }

    public static final /* synthetic */ boolean $anonfun$filterObjects$2(long x$16, Node x$17) {
        return true;
    }

    public static final /* synthetic */ Tuple3 $anonfun$hierarcyDepth$1(long id, Node v) {
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)id), (Object)BoxesRunTime.boxToInteger((int)0), (Object)v);
    }

    private static final Tuple3 setMsg$1(long vertexId, Tuple3 value, Tuple3 message) {
        if (BoxesRunTime.unboxToInt((Object)message._2()) < 1) {
            return new Tuple3(value._1(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)value._2()) + 1)), value._3());
        }
        return new Tuple3(message._1(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)value._2()) + 1)), message._3());
    }

    private static final Iterator sendMsg$1(EdgeTriplet triplet) {
        Tuple3 sourceVertex = (Tuple3)triplet.srcAttr();
        Tuple3 destinationVertex = (Tuple3)triplet.dstAttr();
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)triplet.dstId()), (Object)new Tuple3(sourceVertex._1(), sourceVertex._2(), sourceVertex._3()))}));
    }

    private static final Tuple3 mergeMsg$1(Tuple3 msg1, Tuple3 msg2) {
        return msg2;
    }

    public static final /* synthetic */ Map $anonfun$shortestPaths$1(Seq landmarks$1, long vid, Object attr) {
        if (landmarks$1.contains((Object)BoxesRunTime.boxToLong((long)vid))) {
            return MODULE$.makeMap((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)vid)), (Object)BoxesRunTime.boxToInteger((int)0))}));
        }
        return MODULE$.makeMap((Seq<Tuple2<Object, Object>>)Nil$.MODULE$);
    }

    private final Map vertexProgram$1(long id, Map attr, Map msg) {
        return this.addMaps((Map<Object, Object>)attr, (Map<Object, Object>)msg);
    }

    private final Iterator sendMessage$1(EdgeTriplet edge) {
        Map<Object, Object> newAttr = this.incrementMap((Map<Object, Object>)((Map)edge.dstAttr()));
        Object object = edge.srcAttr();
        Map<Object, Object> map = this.addMaps(newAttr, (Map<Object, Object>)((Map)edge.srcAttr()));
        if (object == null ? map != null : !object.equals(map)) {
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), newAttr)}));
        }
        return package$.MODULE$.Iterator().empty();
    }

    private GraphOps$() {
        MODULE$ = this;
    }
}

