/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.ds;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import net.sansa_stack.rdf.spark.model.package$;
import net.sansa_stack.rdf.spark.utils.NodeUtils$;
import net.sansa_stack.rdf.spark.utils.SchemaUtils$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TripleOps$ {
    public static TripleOps$ MODULE$;
    private transient SparkSession spark;

    static {
        new TripleOps$();
    }

    public RDD<Triple> toRDD(Dataset<Triple> triples) {
        return triples.rdd();
    }

    public Dataset<Row> toDF(Dataset<Triple> triples) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        StructType schema = SchemaUtils$.MODULE$.SQLSchemaDefault();
        RDD rowRDD = triples.rdd().map((Function1 & Serializable & scala.Serializable)t -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NodeUtils$.MODULE$.getNodeValue(t.getSubject()), NodeUtils$.MODULE$.getNodeValue(t.getPredicate()), NodeUtils$.MODULE$.getNodeValue(t.getObject())})), ClassTag$.MODULE$.apply(Row.class));
        Dataset df = spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("TRIPLES");
        return df;
    }

    public Dataset<Triple> getTriples(Dataset<Triple> triples) {
        return triples;
    }

    public Dataset<Triple> find(Dataset<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return this.find(triples, Triple.create((Node)((Node)subject.getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.ANY)), (Node)((Node)predicate.getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.ANY)), (Node)((Node)object.getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.ANY))));
    }

    public Dataset<Triple> find(Dataset<Triple> triples, Triple triple) {
        return triples.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)triple.matches(x$1)));
    }

    public Option<Node> find$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$4() {
        return None$.MODULE$;
    }

    public Dataset<Triple> union(Dataset<Triple> triples, Dataset<Triple> other) {
        return triples.union(other);
    }

    public Dataset<Triple> unionAll(Dataset<Triple> triples, Seq<Dataset<Triple>> others) {
        return (Dataset)others.reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.union(x$3));
    }

    public Dataset<Triple> intersection(Dataset<Triple> triples, Dataset<Triple> other) {
        return triples.intersect(other);
    }

    public Dataset<Triple> difference(Dataset<Triple> triples, Dataset<Triple> other) {
        return triples.except(other);
    }

    public boolean contains(Dataset<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return this.contains(triples, Triple.create((Node)((Node)subject.getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.ANY)), (Node)((Node)predicate.getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.ANY)), (Node)((Node)object.getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.ANY))));
    }

    public boolean contains(Dataset<Triple> triples, Triple triple) {
        return !triples.mapPartitions((Function1 & Serializable & scala.Serializable)p -> {
            if (p.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)triple.matches(x$1)))) {
                return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
            }
            return scala.package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        }, triples.sparkSession().implicits().newIntEncoder()).isEmpty();
    }

    public Option<Node> contains$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$4() {
        return None$.MODULE$;
    }

    public boolean containsAny(Dataset<Triple> triples, Dataset<Triple> other) {
        return !this.difference(triples, other).isEmpty();
    }

    public boolean containsAll(Dataset<Triple> triples, Dataset<Triple> other) {
        return this.difference(triples, other).isEmpty();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Dataset<Triple> add(Dataset<Triple> triples, Triple triple) {
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = (Seq)new .colon.colon((Object)triple, (List)Nil$.MODULE$);
        int x$2 = qual$1.parallelize$default$2();
        RDD statement = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statement).toDS());
    }

    public Dataset<Triple> addAll(Dataset<Triple> triples, Seq<Triple> triple) {
        SparkContext qual$1 = this.spark().sparkContext();
        Seq<Triple> x$1 = triple;
        int x$2 = qual$1.parallelize$default$2();
        RDD statements = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statements).toDS());
    }

    public Dataset<Triple> remove(Dataset<Triple> triples, Triple triple) {
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = (Seq)new .colon.colon((Object)triple, (List)Nil$.MODULE$);
        int x$2 = qual$1.parallelize$default$2();
        RDD statement = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statement).toDS());
    }

    public Dataset<Triple> removeAll(Dataset<Triple> triples, Seq<Triple> triple) {
        SparkContext qual$1 = this.spark().sparkContext();
        Seq<Triple> x$1 = triple;
        int x$2 = qual$1.parallelize$default$2();
        RDD statements = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statements).toDS());
    }

    public void saveAsNTriplesFile(Dataset<Triple> triples, String path) {
        triples.mapPartitions((Function1 & Serializable & scala.Serializable)p -> {
            if (p.hasNext()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                RDFDataMgr.writeTriples((OutputStream)os, (java.util.Iterator)((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(p).asJava()));
                return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Collections.singleton(os.toString("UTF-8").trim()).iterator()).asScala();
            }
            return scala.package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        }, triples.sparkSession().implicits().newStringEncoder()).write().format("text").save(path);
    }

    private TripleOps$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

