/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.mappings;

import net.sansa_stack.rdf.common.partition.core.RdfPartitionStateDefault;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionerDefault$;
import net.sansa_stack.rdf.spark.partition.package$;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;

public final class R2RMLMappings$
implements Serializable {
    public static R2RMLMappings$ MODULE$;
    private final transient SparkSession spark;

    static {
        new R2RMLMappings$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public scala.collection.Iterable<String> loadSQLTables(RDD<Triple> triples, SparkSession spark) {
        Map<RdfPartitionStateDefault, RDD<Row>> partitions = package$.MODULE$.RDFPartition(triples).partitionGraph();
        Iterable schemaSQLTable = (Iterable)partitions.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                RdfPartitionStateDefault p = (RdfPartitionStateDefault)tuple2._1();
                return new StringBuilder(58).append("CREATE TABLE IF NOT EXISTS ").append(p.predicate().replaceAll("[^A-Za-z0-9]", "_")).append(" (s STRING, o STRING, l STRING)").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        return schemaSQLTable;
    }

    public RDD<String> insertSQLTables(RDD<Triple> triples, SparkSession spark) {
        RDD insertSQL = triples.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            String string;
            Triple triple = x0$1;
            String tablename = triple.getPredicate().toString().replaceAll("[^A-Za-z0-9]", "_");
            String subj = RdfPartitionerDefault$.MODULE$.getUriOrBNodeString(triple.getSubject());
            if (triple.getObject().isLiteral()) {
                String string2 = triple.getObject().getLiteralLanguage();
                String string3 = "";
                string = (string2 == null ? string3 != null : !string2.equals(string3)) ? new StringBuilder(7).append("\"").append(triple.getObject().getLiteralLexicalForm()).append("\" , \"").append(triple.getObject().getLiteralLanguage()).append("\"").toString() : new StringBuilder(7).append("\"").append(triple.getObject().getLiteralLexicalForm()).append("\" , \"").append(triple.getObject().getLiteralDatatypeURI()).append("\"").toString();
            } else {
                string = new StringBuilder(7).append("\"").append(RdfPartitionerDefault$.MODULE$.getUriOrBNodeString(triple.getObject())).append("\" , \"\"").toString();
            }
            String complement = string;
            String statement = new StringBuilder(30).append("INSERT INTO ").append(tablename).append(" VALUES ( \"").append(subj).append("\" , ").append(complement).append(" ) ").toString();
            return statement;
        }, ClassTag$.MODULE$.apply(String.class));
        return insertSQL;
    }

    public scala.collection.Iterable<String> generateR2RMLMappings(RDD<Triple> triples, SparkSession spark) {
        IntRef mappingNumber = IntRef.create((int)1);
        Map<RdfPartitionStateDefault, RDD<Row>> partitions = package$.MODULE$.RDFPartition(triples).partitionGraph();
        Iterable r2rmlMappings = (Iterable)partitions.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                RdfPartitionStateDefault p = (RdfPartitionStateDefault)tuple2._1();
                String string = RdfPartitionerDefault$.MODULE$.determineLayout(p).schema().toString();
                String mapping = new StringBuilder(36).append("<TriplesMap").append(Integer.toString(mappingNumber$1.elem)).append("> a rr:TriplesMapClass ; ").toString();
                mapping = new StringBuilder(62).append(mapping).append("rr:logicalTable [rr:SQLQuery \"\"\"SELECT s , o , l FROM ").append(p.predicate().replaceAll("[^A-Za-z0-9]", "_")).append(" \"\"\"] ; ").toString();
                mapping = new StringBuilder(33).append(mapping).append("rr:subjectMap [ rr:column \"s\"] ; ").toString();
                mapping = new StringBuilder(74).append(mapping).append("rr:predicateObjectMap [ rr:predicate ").append(p.predicate()).append(" ; rr:objectMap [ rr:column \"o\"] ] . ").toString();
                ++mappingNumber$1.elem;
                return mapping;
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        return r2rmlMappings;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private R2RMLMappings$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

