/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.hdt;

import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TripleOps$ {
    public static final TripleOps$ MODULE$;
    private final SparkSession spark;

    static {
        new TripleOps$();
    }

    private SparkSession spark() {
        return this.spark;
    }

    public StructType hdtSchema() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("s", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("p", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("o", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
    }

    public StructType dictionarySchema() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("index", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
    }

    public Dataset<Row> asHDT(RDD<Triple> triple) {
        return this.spark().createDataFrame(triple.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Triple t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getSubject().toString(), t.getObject().toString(), t.getPredicate().toString()}));
            }
        }, ClassTag$.MODULE$.apply(Row.class)), this.hdtSchema());
    }

    public Dataset<Row> getDistinctSubjectDictDF(RDD<Triple> triples) {
        return this.spark().createDataFrame(triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Triple x$1) {
                return x$1.getSubject().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().zipWithIndex().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<String, Object> t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t._1(), BoxesRunTime.boxToLong((long)t._2$mcJ$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Row.class)), this.dictionarySchema()).cache();
    }

    public Dataset<Row> getDistinctPredicateDictDF(RDD<Triple> triples) {
        return this.spark().createDataFrame(triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Triple x$2) {
                return x$2.getPredicate().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().zipWithIndex().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<String, Object> t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t._1(), BoxesRunTime.boxToLong((long)t._2$mcJ$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Row.class)), this.dictionarySchema()).cache();
    }

    public Dataset<Row> getDistinctObjectDictDF(RDD<Triple> triples) {
        return this.spark().createDataFrame(triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Triple x$3) {
                return x$3.getObject().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().zipWithIndex().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<String, Object> t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t._1(), BoxesRunTime.boxToLong((long)t._2$mcJ$sp())}));
            }
        }, ClassTag$.MODULE$.apply(Row.class)), this.dictionarySchema()).cache();
    }

    public Dataset<Row> getHDT(RDD<Triple> triples) {
        Dataset<Row> hdtDF = this.asHDT(triples);
        this.getDistinctObjectDictDF(triples).createOrReplaceTempView("objects_hdt");
        BoxedUnit object_hdt = BoxedUnit.UNIT;
        this.getDistinctPredicateDictDF(triples).createOrReplaceTempView("predicates_hdt");
        BoxedUnit predicate_hdt = BoxedUnit.UNIT;
        this.getDistinctSubjectDictDF(triples).createOrReplaceTempView("subjects_hdt");
        BoxedUnit subjectHDT = BoxedUnit.UNIT;
        hdtDF.createOrReplaceTempView("triples_hdt");
        String sqlQuery = "\n        SELECT subjects_hdt.index as s, predicates_hdt.index as p, objects_hdt.index as o\n        FROM triples_hdt\n             JOIN subjects_hdt ON triples_hdt.s = subjects_hdt.name\n             JOIN objects_hdt ON triples_hdt.o = objects_hdt.name\n             JOIN predicates_hdt ON triples_hdt.p =predicates_hdt.name\n        ";
        Dataset hdt = this.spark().sql(sqlQuery);
        hdt.createOrReplaceTempView("hdt");
        return hdt;
    }

    public Tuple4<Dataset<Row>, Dataset<Row>, Dataset<Row>, Dataset<Row>> readHDTFromDisk(String input) {
        Dataset hdt = this.spark().read().schema(this.hdtSchema()).csv(new StringBuilder().append((Object)input).append((Object)"/triples").toString());
        hdt.createOrReplaceTempView("hdt");
        Dataset subjectDF = this.spark().read().schema(this.dictionarySchema()).csv(new StringBuilder().append((Object)input).append((Object)"/subject").toString());
        subjectDF.createOrReplaceTempView("subjects_hdt");
        Dataset objectDF = this.spark().read().schema(this.dictionarySchema()).csv(new StringBuilder().append((Object)input).append((Object)"/object").toString());
        objectDF.createOrReplaceTempView("objects_hdt");
        Dataset predicateDF = this.spark().read().schema(this.dictionarySchema()).csv(new StringBuilder().append((Object)input).append((Object)"/predicate").toString());
        predicateDF.createOrReplaceTempView("predicates_hdt");
        return new Tuple4((Object)hdt, (Object)subjectDF, (Object)objectDF, (Object)predicateDF);
    }

    public void saveAsCSV(Dataset<Row> hdt, Dataset<Row> subjectDF, Dataset<Row> predicateDF, Dataset<Row> objectDF, String output, SaveMode mode) {
        hdt.write().mode(mode).csv(new StringBuilder().append((Object)output).append((Object)"/triples").toString());
        subjectDF.write().mode(mode).csv(new StringBuilder().append((Object)output).append((Object)"/subject").toString());
        objectDF.write().mode(mode).csv(new StringBuilder().append((Object)output).append((Object)"/object").toString());
        predicateDF.write().mode(mode).csv(new StringBuilder().append((Object)output).append((Object)"/predicate").toString());
    }

    private TripleOps$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

