/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.stats;

import java.io.StringWriter;
import net.sansa_stack.rdf.spark.model.graph.package$;
import net.sansa_stack.rdf.spark.stats.DistinctEntities$;
import net.sansa_stack.rdf.spark.stats.DistinctObjects$;
import net.sansa_stack.rdf.spark.stats.DistinctSubjects$;
import net.sansa_stack.rdf.spark.stats.PropertyUsage$;
import net.sansa_stack.rdf.spark.stats.SPO_Vocabularies$;
import net.sansa_stack.rdf.spark.stats.Used_Classes$;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.apache.spark.graphx.Graph;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RDFStatistics$
implements Serializable {
    public static final RDFStatistics$ MODULE$;
    private final transient SparkSession spark;

    static {
        new RDFStatistics$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public RDD<String> run(RDD<Triple> triples) {
        return Used_Classes$.MODULE$.apply(triples, this.spark()).Voidify().union(DistinctEntities$.MODULE$.apply(triples, this.spark()).Voidify()).union(DistinctSubjects$.MODULE$.apply(triples, this.spark()).Voidify()).union(DistinctObjects$.MODULE$.apply(triples, this.spark()).Voidify()).union(PropertyUsage$.MODULE$.apply(triples, this.spark()).Voidify()).union(SPO_Vocabularies$.MODULE$.apply(triples, this.spark()).Voidify());
    }

    public void voidify(RDD<String> stats, String source, String output) {
        StringWriter pw = new StringWriter();
        String prefix = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n                    @prefix void: <http://rdfs.org/ns/void#> .\n                    @prefix void-ext: <http://stats.lod2.eu/rdf/void-ext/> .\n                    @prefix qb: <http://purl.org/linked-data/cube#> .\n                    @prefix dcterms: <http://purl.org/dc/terms/> .\n                    @prefix ls-void: <http://stats.lod2.eu/rdf/void/> .\n                    @prefix ls-qb: <http://stats.lod2.eu/rdf/qb/> .\n                    @prefix ls-cr: <http://stats.lod2.eu/rdf/qb/criteria/> .\n                    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n                    @prefix xstats: <http://example.org/XStats#> .\n                    @prefix foaf: <http://xmlns.com/foaf/0.1/> .\n                    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .";
        String src = new StringBuilder().append((Object)"\n<http://stats.lod2.eu/rdf/void/?source=").append((Object)source).append((Object)">\n").toString();
        String end = "\na void:Dataset .";
        String voidify = prefix.concat(src).concat(Predef$.MODULE$.refArrayOps((Object[])stats.coalesce(1, true, stats.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).collect()).mkString()).concat(end);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\n").append((Object)voidify).toString());
        pw.write(voidify);
        RDD vidifyStats = this.spark().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pw.toString()})), this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        vidifyStats.coalesce(1, true, vidifyStats.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).saveAsTextFile(output);
    }

    public void print(RDD<String> stats, String source) {
        String prefix = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n                    @prefix void: <http://rdfs.org/ns/void#> .\n                    @prefix void-ext: <http://stats.lod2.eu/rdf/void-ext/> .\n                    @prefix qb: <http://purl.org/linked-data/cube#> .\n                    @prefix dcterms: <http://purl.org/dc/terms/> .\n                    @prefix ls-void: <http://stats.lod2.eu/rdf/void/> .\n                    @prefix ls-qb: <http://stats.lod2.eu/rdf/qb/> .\n                    @prefix ls-cr: <http://stats.lod2.eu/rdf/qb/criteria/> .\n                    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n                    @prefix xstats: <http://example.org/XStats#> .\n                    @prefix foaf: <http://xmlns.com/foaf/0.1/> .\n                    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .";
        String src = new StringBuilder().append((Object)"\n<http://stats.lod2.eu/rdf/void/?source=").append((Object)source).append((Object)">\n").toString();
        String end = "\na void:Dataset .";
        String voidify = prefix.concat(src).concat(Predef$.MODULE$.refArrayOps((Object[])stats.coalesce(1, true, stats.coalesce$default$3(), (Ordering)Ordering.String$.MODULE$).collect()).mkString()).concat(end);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\n").append((Object)voidify).toString());
    }

    public RDD<Tuple2<Iterable<Triple>, Object>> PropertyUsageDistinctPerSubject(RDD<Triple> triples) {
        RDD x$49 = triples.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$1) {
                return x$1.getSubject();
            }
        }, ClassTag$.MODULE$.apply(Node.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Iterable<Triple>, Object> apply(Tuple2<Node, Iterable<Triple>> f) {
                return new Tuple2(((TraversableLike)f._2()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Triple p) {
                        return new StringOps(Predef$.MODULE$.augmentString(p.getPredicate().getLiteralLexicalForm())).contains((Object)p);
                    }
                }), (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$50 = ClassTag$.MODULE$.apply(Iterable.class);
        ClassTag x$51 = ClassTag$.MODULE$.Int();
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$49);
        Object x$52 = null;
        return RDD$.MODULE$.rddToPairRDDFunctions(x$49, x$50, x$51, null).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$2, int x$3) {
                return this.apply$mcIII$sp(x$2, x$3);
            }

            public int apply$mcIII$sp(int x$2, int x$3) {
                return x$2 + x$3;
            }
        });
    }

    public RDD<Tuple2<Iterable<Triple>, Object>> PropertyUsageDistinctPerObject(RDD<Triple> triples) {
        RDD x$53 = triples.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$4) {
                return x$4.getObject();
            }
        }, ClassTag$.MODULE$.apply(Node.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Iterable<Triple>, Object> apply(Tuple2<Node, Iterable<Triple>> f) {
                return new Tuple2(((TraversableLike)f._2()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Triple p) {
                        return new StringOps(Predef$.MODULE$.augmentString(p.getPredicate().getLiteralLexicalForm())).contains((Object)p);
                    }
                }), (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$54 = ClassTag$.MODULE$.apply(Iterable.class);
        ClassTag x$55 = ClassTag$.MODULE$.Int();
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$53);
        Object x$56 = null;
        return RDD$.MODULE$.rddToPairRDDFunctions(x$53, x$54, x$55, null).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$5, int x$6) {
                return this.apply$mcIII$sp(x$5, x$6);
            }

            public int apply$mcIII$sp(int x$5, int x$6) {
                return x$5 + x$6;
            }
        });
    }

    public RDD<Tuple2<Node, Object>> ClassHierarchyDepth(RDD<Triple> triples) {
        RDD subClassOf = triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.predicateMatches(RDFS.subClassOf.asNode()) && triple.getSubject().isURI() && triple.getObject().isURI();
            }
        });
        RDD root = triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple t) {
                return t.getObject().isURI() && t.objectMatches(OWL.Class.asNode());
            }
        });
        Graph<Node, Node> graph = package$.MODULE$.GraphLoader(triples).asGraph();
        Graph<Node, Node> subClassOfGraph = package$.MODULE$.GraphLoader((RDD<Triple>)subClassOf).asGraph();
        subClassOfGraph.cache();
        Graph<Tuple3<Object, Object, Node>, Node> hrchyGraph = package$.MODULE$.GraphOperations(subClassOfGraph).hierarcyDepth();
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(graph.vertices().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Node> x$7) {
                return x$7._1$mcJ$sp();
            }
        }), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join((RDD)hrchyGraph.vertices()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Object> apply(Tuple2<Object, Tuple2<Tuple2<Object, Node>, Tuple3<Object, Object, Node>>> x0$1) {
                Tuple2<Object, Tuple2<Tuple2<Object, Node>, Tuple3<Object, Object, Node>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 v = (Tuple2)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(((Tuple2)v._1())._2(), ((Tuple3)v._2())._2());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Serializable x$57 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Node, Object> x$8) {
                return x$8._2$mcI$sp();
            }
        };
        boolean x$58 = false;
        int x$59 = qual$1.sortBy$default$3();
        return qual$1.sortBy((Function1)x$57, x$58, x$59, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int());
    }

    public RDD<Tuple2<Node, Object>> PropertyHierarchyDepth(RDD<Triple> triples) {
        RDD subPropertyOf = triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.predicateMatches(RDFS.subPropertyOf.asNode()) && triple.getSubject().isURI() && triple.getObject().isURI();
            }
        });
        RDD root = triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple t) {
                return t.getObject().isURI() && t.objectMatches(OWL.Class.asNode());
            }
        });
        Graph<Node, Node> graph = package$.MODULE$.GraphLoader(triples).asGraph();
        Graph<Node, Node> subPropertyOfGraph = package$.MODULE$.GraphLoader((RDD<Triple>)subPropertyOf).asGraph();
        subPropertyOfGraph.cache();
        Graph<Tuple3<Object, Object, Node>, Node> hrchyGraph = package$.MODULE$.GraphOperations(subPropertyOfGraph).hierarcyDepth();
        RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(graph.vertices().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Node> x$9) {
                return x$9._1$mcJ$sp();
            }
        }), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join((RDD)hrchyGraph.vertices()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Object> apply(Tuple2<Object, Tuple2<Tuple2<Object, Node>, Tuple3<Object, Object, Node>>> x0$2) {
                Tuple2<Object, Tuple2<Tuple2<Object, Node>, Tuple3<Object, Object, Node>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 v = (Tuple2)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(((Tuple2)v._1())._2(), ((Tuple3)v._2())._2());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Serializable x$60 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Node, Object> x$10) {
                return x$10._2$mcI$sp();
            }
        };
        boolean x$61 = false;
        int x$62 = qual$2.sortBy$default$3();
        return qual$2.sortBy((Function1)x$60, x$61, x$62, (Ordering)Ordering.Int$.MODULE$, ClassTag$.MODULE$.Int());
    }

    public long SubclassUsage(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.predicateMatches(RDFS.subClassOf.asNode());
            }
        }).count();
    }

    public long Triples(RDD<Triple> triples) {
        return triples.count();
    }

    public long EntitiesMentioned(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.getSubject().isURI() && triple.getPredicate().isURI() && triple.getObject().isURI();
            }
        }).count();
    }

    public RDD<Triple> Literals(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$11) {
                return x$11.getObject().isLiteral();
            }
        });
    }

    public RDD<Triple> BlanksAsSubject(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$12) {
                return x$12.getSubject().isBlank();
            }
        });
    }

    public RDD<Triple> BlanksAsObject(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$13) {
                return x$13.getObject().isBlank();
            }
        });
    }

    public RDD<Tuple2<String, Object>> Datatypes(RDD<Triple> triples) {
        return RDD$.MODULE$.rddToPairRDDFunctions(triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.getObject().isLiteral() && !triple.getObject().getLiteralDatatype().getURI().isEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Triple triple) {
                return new Tuple2((Object)triple.getObject().getLiteralDatatype().getURI(), (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$14, int x$15) {
                return this.apply$mcIII$sp(x$14, x$15);
            }

            public int apply$mcIII$sp(int x$14, int x$15) {
                return x$14 + x$15;
            }
        });
    }

    public RDD<Tuple2<String, Object>> Languages(RDD<Triple> triples) {
        return RDD$.MODULE$.rddToPairRDDFunctions(triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.getObject().isLiteral() && !triple.getObject().getLiteralLanguage().isEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Triple triple) {
                return new Tuple2((Object)triple.getObject().getLiteralLanguage(), (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$16, int x$17) {
                return this.apply$mcIII$sp(x$16, x$17);
            }

            public int apply$mcIII$sp(int x$16, int x$17) {
                return x$16 + x$17;
            }
        });
    }

    public double AvgTypedStringLength(RDD<Triple> triples) {
        return RDD$.MODULE$.numericRDDToDoubleRDDFunctions(triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.getObject().isLiteral() && triple.getObject().getLiteralDatatypeURI().equals(XSD.xstring.getURI());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Triple x$18) {
                return x$18.getObject().getLiteralLexicalForm().length();
            }
        }, ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).mean();
    }

    public double AvgUntypedStringLength(RDD<Triple> triples) {
        return RDD$.MODULE$.numericRDDToDoubleRDDFunctions(triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.getObject().isLiteral() && !triple.getObject().getLiteralLanguage().isEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Triple x$19) {
                return x$19.getObject().getLiteralLexicalForm().length();
            }
        }, ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).mean();
    }

    public RDD<Node> TypedSubjects(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.predicateMatches(RDF.type.asNode());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$20) {
                return x$20.getSubject();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> LabeledSubjects(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple triple) {
                return triple.predicateMatches(RDFS.label.asNode());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$21) {
                return x$21.getSubject();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Triple> SameAs(RDD<Triple> triples) {
        return triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$22) {
                return x$22.predicateMatches(OWL.sameAs.asNode());
            }
        });
    }

    public RDD<Tuple3<String, String, Object>> Links(RDD<Triple> triples) {
        return RDD$.MODULE$.rddToPairRDDFunctions(triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Triple triple) {
                if (!triple.getSubject().isURI()) return false;
                if (!triple.getObject().isURI()) return false;
                String string = triple.getSubject().getNameSpace();
                String string2 = triple.getObject().getNameSpace();
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<String, String>, Object> apply(Triple triple) {
                return new Tuple2((Object)new Tuple2((Object)triple.getSubject().getNameSpace(), (Object)triple.getObject().getNameSpace()), (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Int(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$23, int x$24) {
                return this.apply$mcIII$sp(x$23, x$24);
            }

            public int apply$mcIII$sp(int x$23, int x$24) {
                return x$23 + x$24;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, Object> apply(Tuple2<Tuple2<String, String>, Object> e) {
                return new Tuple3(((Tuple2)e._1())._1(), ((Tuple2)e._1())._2(), (Object)BoxesRunTime.boxToInteger((int)e._2$mcI$sp()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public RDD<Tuple2<Node, Node>> MaxPerProperty(RDD<Triple> triples) {
        RDD x$63 = triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple t) {
                return t.getObject().isLiteral();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Node> apply(Triple t) {
                return new Tuple2((Object)t.getPredicate(), (Object)t.getObject());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$64 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$65 = ClassTag$.MODULE$.apply(Node.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$63);
        Object x$66 = null;
        return RDD$.MODULE$.rddToPairRDDFunctions(x$63, x$64, x$65, null).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Node n1, Node n2) {
                int ret = NodeValue.compare((NodeValue)NodeValue.makeNode((Node)n1), (NodeValue)NodeValue.makeNode((Node)n2));
                return ret > 0 ? n1 : n2;
            }
        });
    }

    public RDD<Tuple2<Node, Object>> AvgPerProperty(RDD<Triple> triples) {
        RDD x$67 = triples.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Triple t) {
                if (!t.getObject().isLiteral()) return false;
                RDFDatatype rDFDatatype = t.getObject().getLiteralDatatype();
                XSDDatatype xSDDatatype = XSDDatatype.XSDint;
                if (rDFDatatype == null) {
                    if (xSDDatatype == null) return true;
                } else if (rDFDatatype.equals(xSDDatatype)) return true;
                RDFDatatype rDFDatatype2 = t.getObject().getLiteralDatatype();
                XSDDatatype xSDDatatype2 = XSDDatatype.XSDinteger;
                if (rDFDatatype2 == null) {
                    if (xSDDatatype2 == null) return true;
                } else if (rDFDatatype2.equals(xSDDatatype2)) return true;
                RDFDatatype rDFDatatype3 = t.getObject().getLiteralDatatype();
                XSDDatatype xSDDatatype3 = XSDDatatype.XSDshort;
                if (rDFDatatype3 == null) {
                    if (xSDDatatype3 == null) return true;
                } else if (rDFDatatype3.equals(xSDDatatype3)) return true;
                RDFDatatype rDFDatatype4 = t.getObject().getLiteralDatatype();
                XSDDatatype xSDDatatype4 = XSDDatatype.XSDdecimal;
                if (rDFDatatype4 == null) {
                    if (xSDDatatype4 == null) return true;
                } else if (rDFDatatype4.equals(xSDDatatype4)) return true;
                RDFDatatype rDFDatatype5 = t.getObject().getLiteralDatatype();
                XSDDatatype xSDDatatype5 = XSDDatatype.XSDfloat;
                if (rDFDatatype5 == null) {
                    if (xSDDatatype5 == null) return true;
                } else if (rDFDatatype5.equals(xSDDatatype5)) return true;
                RDFDatatype rDFDatatype6 = t.getObject().getLiteralDatatype();
                XSDDatatype xSDDatatype6 = XSDDatatype.XSDdouble;
                if (rDFDatatype6 != null) {
                    if (!rDFDatatype6.equals(xSDDatatype6)) return false;
                    return true;
                }
                if (xSDDatatype6 == null) return true;
                return false;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Node> apply(Triple t) {
                return new Tuple2((Object)t.getPredicate(), (Object)t.getObject());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$68 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$69 = ClassTag$.MODULE$.apply(Node.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$67);
        Object x$70 = null;
        return RDD$.MODULE$.rddToPairRDDFunctions(x$67, x$68, x$69, null).aggregateByKey((Object)new Tuple2.mcDI.sp(0.0, 0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> elt, Node node) {
                return new Tuple2.mcDI.sp(elt._1$mcD$sp() + NodeValue.makeNode((Node)node).getDouble(), elt._2$mcI$sp() + 1);
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> elt1, Tuple2<Object, Object> elt2) {
                return new Tuple2.mcDI.sp(elt1._1$mcD$sp() + elt2._1$mcD$sp(), elt1._2$mcI$sp() + elt2._2$mcI$sp());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Object> apply(Tuple2<Node, Tuple2<Object, Object>> e) {
                return new Tuple2(e._1(), (Object)BoxesRunTime.boxToDouble((double)(((Tuple2)e._2())._1$mcD$sp() / (double)((Tuple2)e._2())._2$mcI$sp())));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RDFStatistics$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

