/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.riot.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sansa_stack.rdf.spark.riot.lang.NoErrorProfile;
import net.sansa_stack.rdf.spark.riot.tokens.TokenizerTextForgiving;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LangNTriplesSkipBad
implements Iterator<Triple> {
    private static Logger messageLog = LoggerFactory.getLogger(LangNTriplesSkipBad.class);
    private RiotException bad = null;
    private PeekIterator<Triple> base = null;

    @Override
    public boolean hasNext() {
        if (this.base == null) {
            return false;
        }
        try {
            while (this.base.peek() == null) {
                this.base.next();
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return this.base.hasNext();
    }

    @Override
    public Triple next() {
        if (this.bad != null) {
            throw this.bad;
        }
        while (this.base.peek() == null) {
            this.base.next();
        }
        return (Triple)this.base.next();
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public LangNTriplesSkipBad(TokenizerTextForgiving tokens, ParserProfile profile, StreamRDF dest) {
        try {
            this.base = new PeekIterator((Iterator)((Object)new Wrapper(tokens, profile, dest)));
        }
        catch (RiotException e) {
            this.bad = e;
            profile.getErrorHandler().warning(e.getMessage(), -1L, -1L);
        }
    }

    static class Wrapper
    extends LangNTuple<Triple> {
        private ErrorHandler errorHandler;

        Wrapper(Tokenizer tokens, ParserProfile profile, StreamRDF dest) {
            super(tokens, (ParserProfile)new NoErrorProfile(profile), dest);
            this.errorHandler = profile.getErrorHandler();
        }

        protected final void runParser() {
            while (this.hasNext()) {
                Triple x = this.parseOne();
                if (x == null) continue;
                this.dest.triple(x);
            }
        }

        protected final Triple parseOne() {
            Triple triple = null;
            boolean needSkip = false;
            try {
                Token sToken = this.nextToken();
                if (sToken.isEOF()) {
                    this.exception(sToken, "Premature end of file: %s", new Object[]{sToken});
                }
                needSkip = true;
                this.checkIRIOrBNode(sToken);
                needSkip = false;
                Token pToken = this.nextToken();
                if (pToken.isEOF()) {
                    this.exception(pToken, "Premature end of file: %s", new Object[]{pToken});
                }
                needSkip = true;
                this.checkIRI(pToken);
                needSkip = false;
                Token oToken = this.nextToken();
                if (oToken.isEOF()) {
                    this.exception(oToken, "Premature end of file: %s", new Object[]{oToken});
                }
                needSkip = true;
                this.checkRDFTerm(oToken);
                needSkip = false;
                Token x = this.nextToken();
                if (x.getType() != TokenType.DOT) {
                    this.exception(x, "Triple not terminated by DOT: %s", new Object[]{x});
                }
                Node s = this.tokenAsNode(sToken);
                Node p = this.tokenAsNode(pToken);
                Node o = this.tokenAsNode(oToken);
                triple = this.profile.createTriple(s, p, o, sToken.getLine(), sToken.getColumn());
            }
            catch (RiotParseException e) {
                if (needSkip) {
                    ((TokenizerTextForgiving)this.tokens).skipLine();
                    this.nextToken();
                }
            }
            catch (NullPointerException e2) {
                this.errorHandler.warning(e2.getMessage(), this.currLine, this.currCol);
            }
            return triple;
        }

        protected final Node tokenAsNode(Token token) {
            return this.profile.create(null, token);
        }

        public Lang getLang() {
            return RDFLanguages.NTRIPLES;
        }
    }
}

