/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.qualityassessment.utils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import net.sansa_stack.rdf.spark.qualityassessment.utils.DatasetUtils$;
import net.sansa_stack.rdf.spark.qualityassessment.vocabularies.DQV$;
import net.sansa_stack.rdf.spark.utils.StatsPrefixes$;
import org.apache.jena.graph.Node;
import org.apache.jena.vocabulary.RDFS;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class NodeUtils$
implements Serializable {
    public static final NodeUtils$ MODULE$;
    private final Regex isLicenseDefination;
    private final Seq<Object> licenceIndications;
    private final Seq<String> licenceAssociated;

    static {
        new NodeUtils$();
    }

    public boolean isInternal(Node node) {
        return DatasetUtils$.MODULE$.prefixes().exists((Function1)new Serializable(node){
            public static final long serialVersionUID = 0L;
            private final Node node$1;

            public final boolean apply(String prefix) {
                return (this.node$1.isLiteral() ? this.node$1.getLiteralLexicalForm() : this.node$1.toString()).startsWith(prefix);
            }
            {
                this.node$1 = node$1;
            }
        });
    }

    public boolean isExternal(Node node) {
        return !this.isInternal(node);
    }

    public boolean isLexicalFormCompatibleWithDatatype(Node node) {
        return node.getLiteralDatatype().isValid(node.getLiteralLexicalForm());
    }

    public Regex isLicenseDefination() {
        return this.isLicenseDefination;
    }

    public Seq<Object> licenceIndications() {
        return this.licenceIndications;
    }

    public boolean isLicenseStatement(Node node) {
        return Option$.MODULE$.option2Iterable(this.isLicenseDefination().findFirstIn((CharSequence)node.getLiteralLexicalForm())).size() != 0;
    }

    public boolean hasLicenceIndications(Node node) {
        return this.licenceIndications().contains((Object)node.getURI());
    }

    public Seq<String> licenceAssociated() {
        return this.licenceAssociated;
    }

    public boolean hasLicenceAssociated(Node node) {
        return this.licenceAssociated().contains((Object)node.getURI());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBroken(Node node) {
        void var2_2;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Boolean bl2;
        boolean isBroken = false;
        URL extUrl = null;
        try {
            extUrl = new URL(node.getURI());
            bl2 = BoxedUnit.UNIT;
        }
        catch (MalformedURLException malformedURLException) {
            isBroken = true;
            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
        }
        HttpURLConnection urlConn = null;
        try {
            urlConn = (HttpURLConnection)extUrl.openConnection();
            object3 = BoxedUnit.UNIT;
        }
        catch (Exception exception) {
            isBroken = true;
            object3 = BoxesRunTime.boxToBoolean((boolean)true);
        }
        catch (IOException iOException) {
            isBroken = true;
            object3 = BoxesRunTime.boxToBoolean((boolean)true);
        }
        try {
            urlConn.setRequestMethod("HEAD");
            object2 = BoxedUnit.UNIT;
        }
        catch (ProtocolException protocolException) {
            isBroken = true;
            object2 = BoxesRunTime.boxToBoolean((boolean)true);
        }
        int responseCode = 0;
        try {
            urlConn.connect();
            responseCode = urlConn.getResponseCode();
            object = BoxedUnit.UNIT;
        }
        catch (IOException iOException) {
            isBroken = true;
            object = BoxesRunTime.boxToBoolean((boolean)true);
        }
        if (responseCode >= 200 && responseCode < 400) {
            isBroken = false;
            bl = false;
        } else {
            isBroken = true;
            bl = true;
        }
        return (boolean)var2_2;
    }

    public boolean isHashUri(Node node) {
        return node.getURI().indexOf("#") > -1;
    }

    /*
     * WARNING - void declaration
     */
    public String getParentURI(Node node) {
        void var2_2;
        String parentURI = "";
        if (node.isURI()) {
            String string = node.getURI().toString();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                int lastSlashIx = node.getURI().lastIndexOf(47);
                parentURI = lastSlashIx > 0 ? node.getURI().substring(0, lastSlashIx) : "";
            }
        }
        return var2_2;
    }

    public String checkLiteral(Node node) {
        return node.isLiteral() ? node.getLiteralLexicalForm() : node.toString();
    }

    public boolean isLabeled(Node node) {
        return (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString()).contains(StatsPrefixes$.MODULE$.RDFS_LABEL());
    }

    public boolean isRDFSClass(Node node) {
        return (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString()).contains(StatsPrefixes$.MODULE$.RDFS_CLASS());
    }

    public boolean isOWLClass(Node node) {
        return (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString()).contains(StatsPrefixes$.MODULE$.OWL_CLASS());
    }

    public boolean resourceTooLong(Node node) {
        return (double)node.getURI().length() >= DatasetUtils$.MODULE$.shortURIThreshold();
    }

    public boolean hasQueryString(Node node) {
        String uri = node.getURI();
        int qMarkIndex = uri.indexOf("?");
        int hashTagIndex = uri.indexOf("#");
        return qMarkIndex > -1 && (hashTagIndex == -1 || qMarkIndex < hashTagIndex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NodeUtils$() {
        MODULE$ = this;
        this.isLicenseDefination = new Regex(".*(licensed?|copyrighte?d?).*(under|grante?d?|rights?).*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.licenceIndications = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{DQV$.MODULE$.dqv_description(), RDFS.comment, RDFS.label}));
        this.licenceAssociated = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DQV$.MODULE$.cclicence(), DQV$.MODULE$.dbolicense(), DQV$.MODULE$.xhtmllicense(), DQV$.MODULE$.dclicence(), DQV$.MODULE$.dcrights(), DQV$.MODULE$.dctlicense(), DQV$.MODULE$.dbplicence(), DQV$.MODULE$.doaplicense(), DQV$.MODULE$.dctrights(), DQV$.MODULE$.schemalicense(), "wrcc:license", "sz:license_text"}));
    }
}

