/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.rdd;

import net.sansa_stack.rdf.spark.io.ntriples.JenaTripleToNTripleString;
import net.sansa_stack.rdf.spark.utils.NodeUtils$;
import net.sansa_stack.rdf.spark.utils.SchemaUtils$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TripleOps$ {
    public static final TripleOps$ MODULE$;
    private transient SparkSession spark;

    static {
        new TripleOps$();
    }

    public Dataset<Row> toDF(RDD<Triple> triples) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        StructType schema = SchemaUtils$.MODULE$.SQLSchemaDefault();
        RDD rowRDD = triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Triple t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NodeUtils$.MODULE$.getNodeValue(t.getSubject()), NodeUtils$.MODULE$.getNodeValue(t.getPredicate()), NodeUtils$.MODULE$.getNodeValue(t.getObject())}));
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Dataset df = spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("TRIPLES");
        return df;
    }

    public Dataset<Triple> toDS(RDD<Triple> triples) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Encoder encoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        return spark.createDataset(triples, encoder);
    }

    public RDD<Triple> getTriples(RDD<Triple> triples) {
        return triples;
    }

    public RDD<Node> getSubjects(RDD<Triple> triples) {
        return triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$1) {
                return x$1.getSubject();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getPredicates(RDD<Triple> triples) {
        return triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$2) {
                return x$2.getPredicate();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getObjects(RDD<Triple> triples) {
        return triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$3) {
                return x$3.getObject();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Triple> filterSubjects(RDD<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final boolean apply(Triple f) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$1.apply((Object)f.getSubject()));
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public RDD<Triple> filterPredicates(RDD<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$2;

            public final boolean apply(Triple f) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$2.apply((Object)f.getPredicate()));
            }
            {
                this.func$2 = func$2;
            }
        });
    }

    public RDD<Triple> filterObjects(RDD<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$3;

            public final boolean apply(Triple f) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$3.apply((Object)f.getSubject()));
            }
            {
                this.func$3 = func$3;
            }
        });
    }

    public RDD<Triple> find(RDD<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return triples.filter((Function1)new Serializable(subject, predicate, object){
            public static final long serialVersionUID = 0L;
            private final Option subject$1;
            private final Option predicate$1;
            private final Option object$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Triple t) {
                Option option = this.subject$1;
                None$ none$ = None$.MODULE$;
                if (option == null ? none$ != null : !option.equals(none$)) {
                    if (!t.getSubject().matches((Node)this.subject$1.get())) return false;
                }
                Option option2 = this.predicate$1;
                None$ none$2 = None$.MODULE$;
                if (option2 == null ? none$2 != null : !option2.equals(none$2)) {
                    if (!t.getPredicate().matches((Node)this.predicate$1.get())) return false;
                }
                Option option3 = this.object$1;
                None$ none$3 = None$.MODULE$;
                if (option3 == null) {
                    if (none$3 == null) return true;
                } else if (option3.equals(none$3)) return true;
                if (!t.getObject().matches((Node)this.object$1.get())) return false;
                return true;
            }
            {
                this.subject$1 = subject$1;
                this.predicate$1 = predicate$1;
                this.object$1 = object$1;
            }
        });
    }

    public RDD<Triple> find(RDD<Triple> triples, Triple triple) {
        return this.find(triples, (Option<Node>)(triple.getSubject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getSubject())), (Option<Node>)(triple.getPredicate().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getPredicate())), (Option<Node>)(triple.getObject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getObject())));
    }

    public Option<Node> find$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$4() {
        return None$.MODULE$;
    }

    public long size(RDD<Triple> triples) {
        return triples.count();
    }

    public RDD<Triple> union(RDD<Triple> triples, RDD<Triple> other) {
        return triples.union(other);
    }

    public RDD<Triple> unionAll(RDD<Triple> triples, Seq<RDD<Triple>> others) {
        RDD first = (RDD)others.head();
        return first.sparkContext().union(triples, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[0]), ClassTag$.MODULE$.apply(Triple.class));
    }

    public RDD<Triple> intersection(RDD<Triple> triples, RDD<Triple> other) {
        return triples.intersection(other);
    }

    public RDD<Triple> difference(RDD<Triple> triples, RDD<Triple> other) {
        return triples.subtract(other);
    }

    public boolean contains(RDD<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return this.find(triples, subject, predicate, object).count() > 0L;
    }

    public boolean contains(RDD<Triple> triples, Triple triple) {
        return this.find(triples, triple).count() > 0L;
    }

    public Option<Node> contains$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$4() {
        return None$.MODULE$;
    }

    public boolean containsAny(RDD<Triple> triples, RDD<Triple> other) {
        return this.difference(triples, other).count() > 0L;
    }

    public boolean containsAll(RDD<Triple> triples, RDD<Triple> other) {
        return this.difference(triples, other).count() == 0L;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public RDD<Triple> add(RDD<Triple> triples, Triple triple) {
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple}));
        int x$5 = qual$1.parallelize$default$2();
        RDD statement = qual$1.parallelize(x$4, x$5, ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, (RDD<Triple>)statement);
    }

    public RDD<Triple> addAll(RDD<Triple> triples, Seq<Triple> triple) {
        SparkContext qual$2 = this.spark().sparkContext();
        Seq<Triple> x$6 = triple;
        int x$7 = qual$2.parallelize$default$2();
        RDD statements = qual$2.parallelize(x$6, x$7, ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, (RDD<Triple>)statements);
    }

    public RDD<Triple> remove(RDD<Triple> triples, Triple triple) {
        SparkContext qual$3 = this.spark().sparkContext();
        Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple}));
        int x$9 = qual$3.parallelize$default$2();
        RDD statement = qual$3.parallelize(x$8, x$9, ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, (RDD<Triple>)statement);
    }

    public RDD<Triple> removeAll(RDD<Triple> triples, Seq<Triple> triple) {
        SparkContext qual$4 = this.spark().sparkContext();
        Seq<Triple> x$10 = triple;
        int x$11 = qual$4.parallelize$default$2();
        RDD statements = qual$4.parallelize(x$10, x$11, ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, (RDD<Triple>)statements);
    }

    public void saveAsNTriplesFile(RDD<Triple> triples, String path) {
        triples.map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(path);
    }

    private TripleOps$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

