/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.graph;

import net.sansa_stack.rdf.spark.utils.NodeUtils$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public final class GraphOps$ {
    public static final GraphOps$ MODULE$;

    static {
        new GraphOps$();
    }

    public Graph<Node, Node> constructGraph(RDD<Triple> triples) {
        RDD tuples;
        RDD rs = triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Node, Node, Node> apply(Triple triple) {
                return new Tuple3((Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD indexedMap = rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Tuple3<Node, Node, Node> x$1) {
                return (Node)x$1._1();
            }
        }, ClassTag$.MODULE$.apply(Node.class)).union(rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Tuple3<Node, Node, Node> x$2) {
                return (Node)x$2._3();
            }
        }, ClassTag$.MODULE$.apply(Node.class))).distinct().zipWithUniqueId();
        RDD vertices = indexedMap.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Node> apply(Tuple2<Node, Object> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp()), x._1());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD _nodeToId = indexedMap.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Object> apply(Tuple2<Node, Object> x) {
                return new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD x$18 = rs.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Tuple3<Node, Node, Node> x$3) {
                return (Node)x$3._1();
            }
        });
        ClassTag x$19 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$20 = ClassTag$.MODULE$.apply(Tuple3.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$18);
        Object x$21 = null;
        RDD x$22 = tuples = RDD$.MODULE$.rddToPairRDDFunctions(x$18, x$19, x$20, null).join(indexedMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Node, Tuple2<Object, Node>> apply(Tuple2<Node, Tuple2<Tuple3<Node, Node, Node>, Object>> x0$1) {
                Tuple2 tuple2;
                Tuple2<Node, Tuple2<Tuple3<Node, Node, Node>, Object>> tuple22 = x0$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    long si = tuple2._2$mcJ$sp();
                    if (tuple3 != null) {
                        Node p = (Node)tuple3._2();
                        Node o = (Node)tuple3._3();
                        Tuple2 tuple23 = new Tuple2((Object)o, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)si), (Object)p));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple22);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$23 = ClassTag$.MODULE$.apply(Node.class);
        ClassTag x$24 = ClassTag$.MODULE$.apply(Tuple2.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$22);
        Object x$25 = null;
        RDD edges = RDD$.MODULE$.rddToPairRDDFunctions(x$22, x$23, x$24, null).join(indexedMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Edge<Node> apply(Tuple2<Node, Tuple2<Tuple2<Object, Node>, Object>> x0$2) {
                Tuple2 tuple2;
                Tuple2<Node, Tuple2<Tuple2<Object, Node>, Object>> tuple22 = x0$2;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Tuple2 tuple23 = (Tuple2)tuple2._1();
                    long oi = tuple2._2$mcJ$sp();
                    if (tuple23 != null) {
                        long si = tuple23._1$mcJ$sp();
                        Node p = (Node)tuple23._2();
                        Edge edge = new Edge(si, oi, (Object)p);
                        return edge;
                    }
                }
                throw new MatchError(tuple22);
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> constructHashedGraph(RDD<Triple> triples) {
        RDD rs = triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Node, Node, Node> apply(Triple triple) {
                return new Tuple3((Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD vertices = rs.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TraversableOnce<Tuple2<Object, Node>> apply(Tuple3<Node, Node, Node> x0$3) {
                Tuple3<Node, Node, Node> tuple3 = x0$3;
                if (tuple3 != null) {
                    Node s = (Node)tuple3._1();
                    Node p = (Node)tuple3._2();
                    Node o = (Node)tuple3._3();
                    if (s != null) {
                        Node node = s;
                        if (p != null) {
                            Node node2 = p;
                            if (o != null) {
                                Node node3 = o;
                                TraversableOnce traversableOnce = (TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$hash$1(node)), (Object)node), new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$hash$1(node2)), (Object)node2), new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$hash$1(node3)), (Object)node3)}));
                                return traversableOnce;
                            }
                        }
                    }
                }
                throw new MatchError(tuple3);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Edge<Node> apply(Tuple3<Node, Node, Node> x0$4) {
                Tuple3<Node, Node, Node> tuple3 = x0$4;
                if (tuple3 != null) {
                    Node s = (Node)tuple3._1();
                    Node p = (Node)tuple3._2();
                    Node o = (Node)tuple3._3();
                    if (s != null) {
                        Node node = s;
                        if (p != null) {
                            Node node2 = p;
                            if (o != null) {
                                Node node3 = o;
                                Edge edge = new Edge(GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$hash$1(node), GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$hash$1(node3), (Object)node2);
                                return edge;
                            }
                        }
                    }
                }
                throw new MatchError(tuple3);
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<String, String> constructStringGraph(RDD<Triple> triples) {
        RDD rs = triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, String> apply(Triple triple) {
                return new Tuple3((Object)NodeUtils$.MODULE$.getNodeValue(triple.getSubject()), (Object)NodeUtils$.MODULE$.getNodeValue(triple.getPredicate()), (Object)NodeUtils$.MODULE$.getNodeValue(triple.getObject()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD indexedMap = rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<String, String, String> x$4) {
                return (String)x$4._1();
            }
        }, ClassTag$.MODULE$.apply(String.class)).union(rs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<String, String, String> x$5) {
                return (String)x$5._3();
            }
        }, ClassTag$.MODULE$.apply(String.class))).distinct().zipWithUniqueId();
        RDD vertices = indexedMap.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Tuple2<String, Object> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp()), x._1());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD _nodeToId = indexedMap.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x) {
                return new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD tuples = RDD$.MODULE$.rddToPairRDDFunctions(rs.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<String, String, String> x$6) {
                return (String)x$6._1();
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.String$.MODULE$).join(indexedMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Tuple2<Object, String>> apply(Tuple2<String, Tuple2<Tuple3<String, String, String>, Object>> x0$5) {
                Tuple2 tuple2;
                Tuple2<String, Tuple2<Tuple3<String, String, String>, Object>> tuple22 = x0$5;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    long si = tuple2._2$mcJ$sp();
                    if (tuple3 != null) {
                        String p = (String)tuple3._2();
                        String o = (String)tuple3._3();
                        Tuple2 tuple23 = new Tuple2((Object)o, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)si), (Object)p));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple22);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = RDD$.MODULE$.rddToPairRDDFunctions(tuples, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).join(indexedMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Edge<String> apply(Tuple2<String, Tuple2<Tuple2<Object, String>, Object>> x0$6) {
                Tuple2 tuple2;
                Tuple2<String, Tuple2<Tuple2<Object, String>, Object>> tuple22 = x0$6;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Tuple2 tuple23 = (Tuple2)tuple2._1();
                    long oi = tuple2._2$mcJ$sp();
                    if (tuple23 != null) {
                        long si = tuple23._1$mcJ$sp();
                        String p = (String)tuple23._2();
                        Edge edge = new Edge(si, oi, (Object)p);
                        return edge;
                    }
                }
                throw new MatchError(tuple22);
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class));
    }

    public RDD<Triple> toRDD(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Triple apply(EdgeTriplet<Node, Node> x0$7) {
                EdgeTriplet<Node, Node> edgeTriplet = x0$7;
                Triple triple = Triple.create((Node)((Node)edgeTriplet.srcAttr()), (Node)((Node)edgeTriplet.attr()), (Node)((Node)edgeTriplet.dstAttr()));
                return triple;
            }
        }, ClassTag$.MODULE$.apply(Triple.class));
    }

    public Dataset<Row> toDF(Graph<Node, Node> graph) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("subject", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("predicate", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("object", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
        RDD rowRDD = this.toRDD(graph).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Triple t) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getSubject(), t.getPredicate(), t.getObject()}));
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Dataset df = spark.createDataFrame(rowRDD, schema);
        df.createOrReplaceTempView("TRIPLES");
        return df;
    }

    public Dataset<Triple> toDS(Graph<Node, Node> graph) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Encoder encoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        return spark.createDataset(this.toRDD(graph), encoder);
    }

    public RDD<Triple> getTriples(Graph<Node, Node> graph) {
        return this.toRDD(graph);
    }

    public RDD<Node> getSubjects(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(EdgeTriplet<Node, Node> x$7) {
                return (Node)x$7.srcAttr();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getPredicates(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(EdgeTriplet<Node, Node> x$8) {
                return (Node)x$8.attr();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public RDD<Node> getObjects(Graph<Node, Node> graph) {
        return graph.triplets().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(EdgeTriplet<Node, Node> x$9) {
                return (Node)x$9.dstAttr();
            }
        }, ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> find(Graph<Node, Node> graph, Node subject, Node predicate, Node object) {
        return graph.subgraph((Function1)new Serializable(subject, predicate, object){
            public static final long serialVersionUID = 0L;
            private final Node subject$1;
            private final Node predicate$1;
            private final Node object$1;

            public final boolean apply(EdgeTriplet<Node, Node> triplet) {
                return ((Node)triplet.srcAttr()).matches(this.subject$1) && ((Node)triplet.attr()).matches(this.predicate$1) && ((Node)triplet.dstAttr()).matches(this.object$1);
            }
            {
                this.subject$1 = subject$1;
                this.predicate$1 = predicate$1;
                this.object$1 = object$1;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$10, Node x$11) {
                return true;
            }
        });
    }

    public Graph<Node, Node> filterSubjects(Graph<Node, Node> graph, Function1<Node, Object> func) {
        return graph.subgraph((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final boolean apply(EdgeTriplet<Node, Node> triplet) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$1.apply(triplet.srcAttr()));
            }
            {
                this.func$1 = func$1;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$12, Node x$13) {
                return true;
            }
        });
    }

    public Graph<Node, Node> filterPredicates(Graph<Node, Node> graph, Function1<Node, Object> func) {
        return graph.subgraph((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$2;

            public final boolean apply(EdgeTriplet<Node, Node> triplet) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$2.apply(triplet.attr()));
            }
            {
                this.func$2 = func$2;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$14, Node x$15) {
                return true;
            }
        });
    }

    public Graph<Node, Node> filterObjects(Graph<Node, Node> graph, Function1<Node, Object> func) {
        return graph.subgraph((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$3;

            public final boolean apply(EdgeTriplet<Node, Node> triplet) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$3.apply(triplet.dstAttr()));
            }
            {
                this.func$3 = func$3;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$16, Node x$17) {
                return true;
            }
        });
    }

    public long size(Graph<Node, Node> graph) {
        return Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)).numEdges();
    }

    public Graph<Node, Node> union(Graph<Node, Node> graph, Graph<Node, Node> other) {
        return Graph$.MODULE$.apply(graph.vertices().union(other.vertices().distinct()), graph.edges().union(other.edges().distinct()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> intersection(Graph<Node, Node> graph, Graph<Node, Node> other) {
        return Graph$.MODULE$.apply(graph.vertices().intersection(other.vertices().distinct()), graph.edges().intersection(other.edges().distinct()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Node, Node> difference(Graph<Node, Node> graph, Graph<Node, Node> other) {
        return Graph$.MODULE$.apply(graph.vertices().subtract(other.vertices().distinct()), graph.edges().subtract(other.edges().distinct()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public Graph<Tuple3<Object, Object, Node>, Node> hierarcyDepth(Graph<Node, Node> graph) {
        Tuple3 initialMsg = new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToInteger((int)0), (Object)Node.ANY);
        Serializable x$26 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Node> apply(long id, Node v) {
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)id), (Object)BoxesRunTime.boxToInteger((int)0), (Object)v);
            }
        };
        ClassTag x$27 = ClassTag$.MODULE$.apply(Tuple3.class);
        graph.mapVertices$default$3((Function2)x$26);
        Object x$28 = null;
        Graph initialGraph = graph.mapVertices((Function2)x$26, x$27, null);
        return Graph$.MODULE$.graphToGraphOps(initialGraph, ClassTag$.MODULE$.apply(Tuple3.class), ClassTag$.MODULE$.apply(Node.class)).pregel((Object)initialMsg, Integer.MAX_VALUE, EdgeDirection$.MODULE$.Out(), (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Node> apply(long vertexId, Tuple3<Object, Object, Node> value, Tuple3<Object, Object, Node> message) {
                return GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$setMsg$1(vertexId, value, message);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Object, Tuple3<Object, Object, Node>>> apply(EdgeTriplet<Tuple3<Object, Object, Node>, ?> triplet) {
                return GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$sendMsg$1(triplet);
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Node> apply(Tuple3<Object, Object, Node> msg1, Tuple3<Object, Object, Node> msg2) {
                return GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$mergeMsg$1(msg1, msg2);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public Map<Object, Object> net$sansa_stack$rdf$spark$model$graph$GraphOps$$makeMap(Seq<Tuple2<Object, Object>> x) {
        return (Map)Predef$.MODULE$.Map().apply(x);
    }

    private Map<Object, Object> incrementMap(Map<Object, Object> spmap) {
        return (Map)spmap.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$8) {
                Tuple2<Object, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    long v = tuple2._1$mcJ$sp();
                    int d = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)v)), (Object)BoxesRunTime.boxToInteger((int)(d + 1)));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> net$sansa_stack$rdf$spark$model$graph$GraphOps$$addMaps(Map<Object, Object> spmap1, Map<Object, Object> spmap2) {
        return ((TraversableOnce)spmap1.keySet().$plus$plus((GenTraversableOnce)spmap2.keySet()).map((Function1)new Serializable(spmap1, spmap2){
            public static final long serialVersionUID = 0L;
            private final Map spmap1$1;
            private final Map spmap2$1;

            public final Tuple2<Object, Object> apply(long k) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)k)), (Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToInt((Object)this.spmap1$1.getOrElse((Object)BoxesRunTime.boxToLong((long)k), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return Integer.MAX_VALUE;
                    }
                })), BoxesRunTime.unboxToInt((Object)this.spmap2$1.getOrElse((Object)BoxesRunTime.boxToLong((long)k), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return Integer.MAX_VALUE;
                    }
                })))));
            }
            {
                this.spmap1$1 = spmap1$1;
                this.spmap2$1 = spmap2$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <VD, ED> Graph<Map<Object, Object>, ED> shortestPaths(Graph<VD, ED> graph, Seq<Object> landmarks, ClassTag<ED> evidence$1) {
        Serializable x$29 = new Serializable(landmarks){
            public static final long serialVersionUID = 0L;
            private final Seq landmarks$1;

            public final Map<Object, Object> apply(long vid, VD attr) {
                return this.landmarks$1.contains((Object)BoxesRunTime.boxToLong((long)vid)) ? GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$makeMap((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)vid)), (Object)BoxesRunTime.boxToInteger((int)0))})) : GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$makeMap((Seq<Tuple2<Object, Object>>)Nil$.MODULE$);
            }
            {
                this.landmarks$1 = landmarks$1;
            }
        };
        ClassTag x$30 = ClassTag$.MODULE$.apply(Map.class);
        graph.mapVertices$default$3((Function2)x$29);
        Object x$31 = null;
        Graph spGraph = graph.mapVertices((Function2)x$29, x$30, null);
        Map<Object, Object> initialMessage = this.net$sansa_stack$rdf$spark$model$graph$GraphOps$$makeMap((Seq<Tuple2<Object, Object>>)Nil$.MODULE$);
        return Pregel$.MODULE$.apply(spGraph, initialMessage, Pregel$.MODULE$.apply$default$3(), Pregel$.MODULE$.apply$default$4(), (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(long id, Map<Object, Object> attr, Map<Object, Object> msg) {
                return GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$vertexProgram$1(id, attr, msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Object, Map<Object, Object>>> apply(EdgeTriplet<Map<Object, Object>, ?> edge) {
                return GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$sendMessage$1(edge);
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Map<Object, Object> spmap1, Map<Object, Object> spmap2) {
                return GraphOps$.MODULE$.net$sansa_stack$rdf$spark$model$graph$GraphOps$$addMaps(spmap1, spmap2);
            }
        }, ClassTag$.MODULE$.apply(Map.class), evidence$1, ClassTag$.MODULE$.apply(Map.class));
    }

    public final long net$sansa_stack$rdf$spark$model$graph$GraphOps$$hash$1(Node s) {
        return MurmurHash3$.MODULE$.stringHash(s.toString());
    }

    public final Tuple3 net$sansa_stack$rdf$spark$model$graph$GraphOps$$setMsg$1(long vertexId, Tuple3 value, Tuple3 message) {
        return BoxesRunTime.unboxToInt((Object)message._2()) < 1 ? new Tuple3(value._1(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)value._2()) + 1)), value._3()) : new Tuple3(message._1(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)value._2()) + 1)), message._3());
    }

    public final Iterator net$sansa_stack$rdf$spark$model$graph$GraphOps$$sendMsg$1(EdgeTriplet triplet) {
        Tuple3 sourceVertex = (Tuple3)triplet.srcAttr();
        Tuple3 destinationVertex = (Tuple3)triplet.dstAttr();
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)triplet.dstId()), (Object)new Tuple3(sourceVertex._1(), sourceVertex._2(), sourceVertex._3()))}));
    }

    public final Tuple3 net$sansa_stack$rdf$spark$model$graph$GraphOps$$mergeMsg$1(Tuple3 msg1, Tuple3 msg2) {
        return msg2;
    }

    public final Map net$sansa_stack$rdf$spark$model$graph$GraphOps$$vertexProgram$1(long id, Map attr, Map msg) {
        return this.net$sansa_stack$rdf$spark$model$graph$GraphOps$$addMaps((Map<Object, Object>)attr, (Map<Object, Object>)msg);
    }

    public final Iterator net$sansa_stack$rdf$spark$model$graph$GraphOps$$sendMessage$1(EdgeTriplet edge) {
        Map<Object, Object> newAttr = this.incrementMap((Map<Object, Object>)((Map)edge.dstAttr()));
        Object object = edge.srcAttr();
        Map<Object, Object> map = this.net$sansa_stack$rdf$spark$model$graph$GraphOps$$addMaps(newAttr, (Map<Object, Object>)((Map)edge.srcAttr()));
        return !(object != null ? !object.equals(map) : map != null) ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), newAttr)}));
    }

    private GraphOps$() {
        MODULE$ = this;
    }
}

