/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model.df;

import net.sansa_stack.rdf.spark.io.ntriples.JenaTripleToNTripleString;
import net.sansa_stack.rdf.spark.model.package$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class TripleOps$ {
    public static final TripleOps$ MODULE$;

    static {
        new TripleOps$();
    }

    public RDD<Triple> toRDD(Dataset<Row> triples) {
        return triples.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Triple apply(Row row) {
                return Triple.create((Node)NodeFactory.createURI((String)row.getString(0)), (Node)NodeFactory.createURI((String)row.getString(1)), (Node)(row.getString(2).startsWith("http:") ? NodeFactory.createURI((String)row.getString(2)) : NodeFactory.createLiteral((String)row.getString(2))));
            }
        }, ClassTag$.MODULE$.apply(Triple.class));
    }

    public Dataset<Triple> toDS(Dataset<Row> triples) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Encoder encoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        return spark.createDataset(this.toRDD(triples), encoder);
    }

    public Dataset<Row> getTriples(Dataset<Row> triples) {
        return triples;
    }

    public Dataset<Row> getSubjects(Dataset<Row> triples) {
        return triples.select("s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public Dataset<Row> getPredicates(Dataset<Row> triples) {
        return triples.select("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public Dataset<Row> getObjects(Dataset<Row> triples) {
        return triples.select("o", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public Dataset<Row> find(Dataset<Row> triples, Option<String> subject, Option<String> predicate, Option<String> object) {
        String sql = this.getSQL(subject, predicate, object);
        return triples.sqlContext().sql(sql);
    }

    public String getSQL(Option<String> subject, Option<String> predicate, Option<String> object) {
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT s, p, o FROM TRIPLES"})).s((Seq)Nil$.MODULE$);
        if (subject.isDefined() || predicate.isDefined() || object.isDefined()) {
            sql = new StringBuilder().append((Object)sql).append((Object)" WHERE ").toString();
            ListBuffer conditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Object object2 = subject.isDefined() ? conditions.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subject.get()}))) : BoxedUnit.UNIT;
            Object object3 = predicate.isDefined() ? conditions.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{predicate.get()}))) : BoxedUnit.UNIT;
            Object object4 = object.isDefined() ? conditions.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"o = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object.get()}))) : BoxedUnit.UNIT;
            sql = new StringBuilder().append((Object)sql).append((Object)conditions.mkString(" AND ")).toString();
        }
        return sql;
    }

    public Option<String> getSQL$default$1() {
        return None$.MODULE$;
    }

    public Option<String> getSQL$default$2() {
        return None$.MODULE$;
    }

    public Option<String> getSQL$default$3() {
        return None$.MODULE$;
    }

    public Dataset<Row> find(Dataset<Row> triples, Triple triple) {
        return this.find(triples, (Option<String>)(triple.getSubject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getSubject().getURI())), (Option<String>)(triple.getPredicate().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getPredicate().getURI())), (Option<String>)(triple.getObject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)(triple.getObject().isLiteral() ? triple.getObject().getLiteralLexicalForm() : triple.getObject().getURI()))));
    }

    public Option<String> find$default$2() {
        return None$.MODULE$;
    }

    public Option<String> find$default$3() {
        return None$.MODULE$;
    }

    public Option<String> find$default$4() {
        return None$.MODULE$;
    }

    public long size(Dataset<Row> triples) {
        return triples.count();
    }

    public Dataset<Row> union(Dataset<Row> triples, Dataset<Row> other) {
        return triples.union(other);
    }

    /*
     * Unable to fully structure code
     */
    public Dataset<Row> unionAll(Dataset<Row> triples, Seq<Dataset<Row>> others) {
        var4_3 = false;
        var5_4 = null;
        var6_5 = others;
        if (!(var6_5 instanceof .colon.colon)) ** GOTO lbl-1000
        var4_3 = true;
        var5_4 = (.colon.colon)var6_5;
        g = (Dataset)var5_4.head();
        var8_7 = var5_4.tl$1();
        if (Nil$.MODULE$.equals(var8_7)) {
            var9_8 = new Some((Object)g.toDF());
        } else if (var4_3) {
            g = (Dataset)var5_4.head();
            var9_8 = new Some((Object)g.toDF().sqlContext().createDataFrame(g.toDF().sqlContext().sparkContext().union((Seq)others.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final RDD<Row> apply(Dataset<Row> x$1) {
                    return x$1.toDF().rdd();
                }
            }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Row.class)), g.toDF().schema()));
        } else {
            var9_8 = None$.MODULE$;
        }
        df = var9_8;
        return (Dataset)df.get();
    }

    public Dataset<Row> intersection(Dataset<Row> triples, Dataset<Row> other) {
        return triples.intersect(other);
    }

    public Dataset<Row> difference(Dataset<Row> triples, Dataset<Row> other) {
        return triples.except(other);
    }

    public boolean contains(Dataset<Row> triples, Option<String> subject, Option<String> predicate, Option<String> object) {
        return this.find(triples, subject, predicate, object).count() > 0L;
    }

    public boolean contains(Dataset<Row> triples, Triple triple) {
        return this.find(triples, triple).count() > 0L;
    }

    public Option<String> contains$default$2() {
        return None$.MODULE$;
    }

    public Option<String> contains$default$3() {
        return None$.MODULE$;
    }

    public Option<String> contains$default$4() {
        return None$.MODULE$;
    }

    public boolean containsAny(Dataset<Row> triples, Dataset<Row> other) {
        return this.difference(triples, other).count() > 0L;
    }

    public boolean containsAll(Dataset<Row> triples, Dataset<Row> other) {
        return this.difference(triples, other).count() == 0L;
    }

    public Dataset<Row> add(Dataset<Row> triples, Triple triple) {
        RDD statement = triples.sparkSession().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple})), triples.sparkSession().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statement).toDF());
    }

    public Dataset<Row> addAll(Dataset<Row> triples, Seq<Triple> triple) {
        RDD statements = triples.sparkSession().sparkContext().parallelize(triple, triples.sparkSession().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return this.union(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statements).toDF());
    }

    public Dataset<Row> remove(Dataset<Row> triples, Triple triple) {
        RDD statement = triples.sparkSession().sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple})), triples.sparkSession().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statement).toDF());
    }

    public Dataset<Row> removeAll(Dataset<Row> triples, Seq<Triple> triple) {
        RDD statements = triples.sparkSession().sparkContext().parallelize(triple, triples.sparkSession().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Triple.class));
        return this.difference(triples, package$.MODULE$.TripleOperations((RDD<Triple>)statements).toDF());
    }

    public void saveAsNTriplesFile(Dataset<Row> triples, String path) {
        this.toRDD(triples).map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(path);
    }

    private TripleOps$() {
        MODULE$ = this;
    }
}

