/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.partition.sparqlify;

import java.util.ArrayList;
import java.util.Arrays;
import net.sansa_stack.rdf.partition.core.RdfPartitionDefault;
import org.aksw.jena_sparql_api.utils.Vars;
import org.aksw.jena_sparql_api.views.Constraint;
import org.aksw.jena_sparql_api.views.E_RdfTerm;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpTable;
import org.aksw.sparqlify.config.syntax.ViewDefinition;
import org.aksw.sparqlify.config.syntax.ViewTemplateDefinition;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SparqlifyUtils2$ {
    public static final SparqlifyUtils2$ MODULE$;

    static {
        new SparqlifyUtils2$();
    }

    public ExprVar newExprVar(String varName) {
        return new ExprVar(Var.alloc((String)varName));
    }

    public ExprVar newExprVar(int varId) {
        return this.newExprVar(new StringBuilder().append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)varId)).toString());
    }

    public ViewDefinition createViewDefinition(RdfPartitionDefault p) {
        String pred = p.predicate();
        String predPart = pred.substring(pred.lastIndexOf("/") + 1);
        Node pn = NodeFactory.createURI((String)p.predicate());
        String dt = p.datatype();
        String dtPart = dt == null || dt.isEmpty() ? "" : new StringBuilder().append((Object)"_").append((Object)dt.substring(dt.lastIndexOf("/") + 1)).toString();
        String langPart = p.langTagPresent() ? "_lang" : "";
        String tableName = new StringBuilder().append((Object)predPart).append((Object)dtPart.replace("#", "_")).append((Object)langPart).toString();
        Quad quad = new Quad(Quad.defaultGraphIRI, (Node)Vars.s, pn, (Node)Vars.o);
        QuadPattern quadPattern = new QuadPattern();
        quadPattern.add(quad);
        E_RdfTerm sTerm = this.createExprForNode(0, p.subjectType(), "", p.langTagPresent());
        E_RdfTerm oTerm = this.createExprForNode(1, p.objectType(), p.datatype(), p.langTagPresent());
        E_Equals se = new E_Equals((Expr)new ExprVar(Vars.s), (Expr)sTerm);
        E_Equals oe = new E_Equals((Expr)new ExprVar(Vars.o), (Expr)oTerm);
        ArrayList<E_Equals> varDefs = new ArrayList<E_Equals>();
        varDefs.add(se);
        varDefs.add(oe);
        SqlOpTable sqlOp = new SqlOpTable(null, tableName);
        ViewTemplateDefinition vtd = new ViewTemplateDefinition(quadPattern, varDefs);
        ViewDefinition vd = new ViewDefinition(tableName, vtd, (SqlOp)sqlOp, Arrays.asList((Object[])new Constraint[0]));
        return vd;
    }

    public E_RdfTerm createExprForNode(int offset, byte termType, String datatype, boolean langTagPresent) {
        E_RdfTerm e_RdfTerm;
        int o = offset + 1;
        byte by = termType;
        switch (by) {
            default: {
                throw new RuntimeException("Unhandled case");
            }
            case 2: {
                if (langTagPresent) {
                    e_RdfTerm = E_RdfTerm.createPlainLiteral((Expr)this.newExprVar(o), (Expr)this.newExprVar(o + 1));
                    break;
                }
                e_RdfTerm = E_RdfTerm.createTypedLiteral((Expr)this.newExprVar(o), (Expr)NodeValue.makeString((String)datatype));
                break;
            }
            case 1: {
                e_RdfTerm = E_RdfTerm.createUri((Expr)this.newExprVar(o));
                break;
            }
            case 0: {
                e_RdfTerm = E_RdfTerm.createBlankNode((Expr)this.newExprVar(o));
            }
        }
        return e_RdfTerm;
    }

    private SparqlifyUtils2$() {
        MODULE$ = this;
    }
}

