/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.flink.model.dataset;

import java.util.Collection;
import net.sansa_stack.rdf.flink.io.ntriples.JenaTripleToNTripleString;
import net.sansa_stack.rdf.flink.utils.DataSetUtils$;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.core.fs.FileSystem;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TripleOps$ {
    public static final TripleOps$ MODULE$;
    private transient ExecutionEnvironment env;

    static {
        new TripleOps$();
    }

    public DataSet<Triple> getTriples(DataSet<Triple> triples) {
        return triples;
    }

    public DataSet<Node> getSubjects(DataSet<Triple> triples) {
        return triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$1) {
                return x$1.getSubject();
            }
        }, TypeExtractor.createTypeInfo(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public DataSet<Node> getPredicates(DataSet<Triple> triples) {
        return triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$2) {
                return x$2.getPredicate();
            }
        }, TypeExtractor.createTypeInfo(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public DataSet<Node> getObjects(DataSet<Triple> triples) {
        return triples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(Triple x$3) {
                return x$3.getObject();
            }
        }, TypeExtractor.createTypeInfo(Node.class), ClassTag$.MODULE$.apply(Node.class));
    }

    public DataSet<Triple> filterSubjects(DataSet<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final boolean apply(Triple f) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$1.apply((Object)f.getSubject()));
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public DataSet<Triple> filterPredicates(DataSet<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$2;

            public final boolean apply(Triple f) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$2.apply((Object)f.getPredicate()));
            }
            {
                this.func$2 = func$2;
            }
        });
    }

    public DataSet<Triple> filterObjects(DataSet<Triple> triples, Function1<Node, Object> func) {
        return triples.filter((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$3;

            public final boolean apply(Triple f) {
                return BoxesRunTime.unboxToBoolean((Object)this.func$3.apply((Object)f.getSubject()));
            }
            {
                this.func$3 = func$3;
            }
        });
    }

    public DataSet<Triple> find(DataSet<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return triples.filter((Function1)new Serializable(subject, predicate, object){
            public static final long serialVersionUID = 0L;
            private final Option subject$1;
            private final Option predicate$1;
            private final Option object$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Triple t) {
                Option option = this.subject$1;
                None$ none$ = None$.MODULE$;
                if (option == null ? none$ != null : !option.equals(none$)) {
                    if (!t.getSubject().matches((Node)this.subject$1.get())) return false;
                }
                Option option2 = this.predicate$1;
                None$ none$2 = None$.MODULE$;
                if (option2 == null ? none$2 != null : !option2.equals(none$2)) {
                    if (!t.getPredicate().matches((Node)this.predicate$1.get())) return false;
                }
                Option option3 = this.object$1;
                None$ none$3 = None$.MODULE$;
                if (option3 == null) {
                    if (none$3 == null) return true;
                } else if (option3.equals(none$3)) return true;
                if (!t.getObject().matches((Node)this.object$1.get())) return false;
                return true;
            }
            {
                this.subject$1 = subject$1;
                this.predicate$1 = predicate$1;
                this.object$1 = object$1;
            }
        });
    }

    public DataSet<Triple> find(DataSet<Triple> triples, Triple triple) {
        return this.find(triples, (Option<Node>)(triple.getSubject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getSubject())), (Option<Node>)(triple.getPredicate().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getPredicate())), (Option<Node>)(triple.getObject().isVariable() ? None$.MODULE$ : Option$.MODULE$.apply((Object)triple.getObject())));
    }

    public Option<Node> find$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> find$default$4() {
        return None$.MODULE$;
    }

    public long size(DataSet<Triple> triples) {
        return triples.count();
    }

    public DataSet<Triple> union(DataSet<Triple> triples, DataSet<Triple> other) {
        return triples.union(other);
    }

    public DataSet<Triple> unionAll(DataSet<Triple> triples, Seq<DataSet<Triple>> others) {
        DataSet first = (DataSet)others.head();
        return first.union(triples);
    }

    public DataSet<Triple> intersect(DataSet<Triple> triples, DataSet<Triple> other) {
        return DataSetUtils$.MODULE$.DataSetOps(triples, ClassTag$.MODULE$.apply(Triple.class), TypeExtractor.createTypeInfo(Triple.class)).intersect(other);
    }

    public DataSet<Triple> difference(DataSet<Triple> triples, DataSet<Triple> other) {
        return DataSetUtils$.MODULE$.DataSetOps(triples, ClassTag$.MODULE$.apply(Triple.class), TypeExtractor.createTypeInfo(Triple.class)).subtract(other);
    }

    public boolean contains(DataSet<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> object) {
        return this.find(triples, subject, predicate, object).count() > 0L;
    }

    public boolean contains(DataSet<Triple> triples, Triple triple) {
        return this.find(triples, triple).count() > 0L;
    }

    public Option<Node> contains$default$2() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$3() {
        return None$.MODULE$;
    }

    public Option<Node> contains$default$4() {
        return None$.MODULE$;
    }

    public boolean containsAny(DataSet<Triple> triples, DataSet<Triple> other) {
        return this.difference(triples, other).count() > 0L;
    }

    public boolean containsAll(DataSet<Triple> triples, DataSet<Triple> other) {
        return this.difference(triples, other).count() == 0L;
    }

    public ExecutionEnvironment env() {
        return this.env;
    }

    public void env_$eq(ExecutionEnvironment x$1) {
        this.env = x$1;
    }

    public DataSet<Triple> add(DataSet<Triple> triples, Triple triple) {
        DataSet statement = (DataSet)this.env().fromCollection((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple}))).asJava());
        return this.union(triples, (DataSet<Triple>)statement);
    }

    public DataSet<Triple> addAll(DataSet<Triple> triples, Seq<Triple> triple) {
        DataSet statements = (DataSet)this.env().fromCollection((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(triple).asJava());
        return this.union(triples, (DataSet<Triple>)statements);
    }

    public DataSet<Triple> remove(DataSet<Triple> triples, Triple triple) {
        DataSet statement = (DataSet)this.env().fromCollection((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Triple[]{triple}))).asJava());
        return this.difference(triples, (DataSet<Triple>)statement);
    }

    public DataSet<Triple> removeAll(DataSet<Triple> triples, Seq<Triple> triple) {
        DataSet statements = (DataSet)this.env().fromCollection((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(triple).asJava());
        return this.difference(triples, (DataSet<Triple>)statements);
    }

    public void saveAsNTriplesFile(DataSet<Triple> triples, String path) {
        DataSet qual$1 = triples.map((Function1)new JenaTripleToNTripleString(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        String x$4 = path;
        FileSystem.WriteMode x$5 = qual$1.writeAsText$default$2();
        qual$1.writeAsText(x$4, x$5);
    }

    private TripleOps$() {
        MODULE$ = this;
        this.env = ExecutionEnvironment.getExecutionEnvironment();
    }
}

