/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.flink.qualityassessment.metrics.completeness;

import net.sansa_stack.rdf.flink.data.RDFGraph;
import net.sansa_stack.rdf.flink.model.RDFTriple;
import net.sansa_stack.rdf.flink.qualityassessment.dataset.DatasetUtils$;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.jena.graph.Node;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;

public final class InterlinkingCompleteness$
implements Serializable {
    public static final InterlinkingCompleteness$ MODULE$;
    private transient ExecutionEnvironment env;
    private final List<String> prefixes;

    static {
        new InterlinkingCompleteness$();
    }

    public ExecutionEnvironment env() {
        return this.env;
    }

    public void env_$eq(ExecutionEnvironment x$1) {
        this.env = x$1;
    }

    public List<String> prefixes() {
        return this.prefixes;
    }

    public long apply(RDFGraph rdfgraph) {
        DataSet<RDFTriple> dataset = rdfgraph.triples();
        DataSet Interlinked = dataset.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RDFTriple f) {
                return f.getSubject().isURI() && InterlinkingCompleteness$.MODULE$.isInternal(f.getSubject()) && f.getObject().isURI() && InterlinkingCompleteness$.MODULE$.isExternal(f.getObject());
            }
        }).union(dataset.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RDFTriple f) {
                return f.getSubject().isURI() && InterlinkingCompleteness$.MODULE$.isExternal(f.getSubject()) && f.getObject().isURI() && InterlinkingCompleteness$.MODULE$.isInternal(f.getObject());
            }
        }));
        long numSubj = Interlinked.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(RDFTriple x$1) {
                return x$1.getSubject();
            }
        }, TypeExtractor.createTypeInfo(Node.class), ClassTag$.MODULE$.apply(Node.class)).distinct().count();
        long numObj = Interlinked.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(RDFTriple x$2) {
                return x$2.getSubject();
            }
        }, TypeExtractor.createTypeInfo(Node.class), ClassTag$.MODULE$.apply(Node.class)).distinct().count();
        long numResources = numSubj + numObj;
        long numInterlinkedResources = Interlinked.count();
        long value = numResources > 0L ? numInterlinkedResources / numResources : 0L;
        return value;
    }

    public boolean isInternal(Node node) {
        return this.prefixes().contains((Object)(node.isLiteral() ? node.getLiteralLexicalForm() : node.toString()));
    }

    public boolean isExternal(Node node) {
        return !this.prefixes().contains((Object)(node.isLiteral() ? node.getLiteralLexicalForm() : node.toString()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InterlinkingCompleteness$() {
        MODULE$ = this;
        this.prefixes = DatasetUtils$.MODULE$.getPrefixes();
    }
}

