/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.common.qualityassessment.utils;

import java.io.Serializable;
import net.sansa_stack.rdf.common.qualityassessment.utils.DatasetUtils$;
import net.sansa_stack.rdf.common.qualityassessment.utils.vocabularies.DQV$;
import org.apache.jena.graph.Node;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import scalaj.http.Http$;
import scalaj.http.HttpResponse;

public final class NodeUtils$
implements scala.Serializable {
    public static NodeUtils$ MODULE$;
    private final Regex isLicenseDefination;
    private final Seq<String> licenceIndications;
    private final Seq<String> licenceAssociated;

    static {
        new NodeUtils$();
    }

    public boolean isInternal(Node node) {
        return DatasetUtils$.MODULE$.prefixes().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)NodeUtils$.$anonfun$isInternal$1(node, prefix)));
    }

    public boolean isExternal(Node node) {
        return !this.isInternal(node);
    }

    public boolean isLexicalFormCompatibleWithDatatype(Node node) {
        return node.getLiteralDatatype().isValid(node.getLiteralLexicalForm());
    }

    public Regex isLicenseDefination() {
        return this.isLicenseDefination;
    }

    public Seq<String> licenceIndications() {
        return this.licenceIndications;
    }

    public boolean isLicenseStatement(Node node) {
        return this.isLicenseDefination().findFirstIn((CharSequence)node.getLiteralLexicalForm()).isDefined();
    }

    public boolean hasLicenceIndications(Node node) {
        return this.licenceIndications().contains((Object)node.getURI());
    }

    public Seq<String> licenceAssociated() {
        return this.licenceAssociated;
    }

    public boolean hasLicenceAssociated(Node node) {
        return this.licenceAssociated().contains((Object)node.getURI());
    }

    public boolean isBroken(Node node) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Http$.MODULE$.apply(node.getURI()).method("HEAD").asString());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            bl = response.code() < 200 || response.code() >= 400;
        } else if (try_ instanceof Failure) {
            bl = true;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public boolean isHashUri(Node node) {
        return node.getURI().indexOf("#") > -1;
    }

    /*
     * WARNING - void declaration
     */
    public String getParentURI(Node node) {
        void var2_2;
        block1: {
            String parentURI = "";
            if (!node.isURI()) break block1;
            String string = node.getURI();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                int lastSlashIx = node.getURI().lastIndexOf(47);
                parentURI = lastSlashIx > 0 ? node.getURI().substring(0, lastSlashIx) : "";
            }
        }
        return var2_2;
    }

    public String checkLiteral(Node node) {
        return node.isLiteral() ? node.getLiteralLexicalForm() : node.toString();
    }

    public boolean isLabeled(Node node) {
        return new StringOps(Predef$.MODULE$.augmentString(node.isLiteral() ? node.getLiteralLexicalForm() : node.toString())).contains((Object)RDFS.label);
    }

    public boolean isRDFSClass(Node node) {
        return new StringOps(Predef$.MODULE$.augmentString(node.isLiteral() ? node.getLiteralLexicalForm() : node.toString())).contains((Object)RDFS.Class);
    }

    public boolean isOWLClass(Node node) {
        return new StringOps(Predef$.MODULE$.augmentString(node.isLiteral() ? node.getLiteralLexicalForm() : node.toString())).contains((Object)OWL.Class);
    }

    public boolean resourceTooLong(Node node) {
        return (double)node.getURI().length() >= DatasetUtils$.MODULE$.shortURIThreshold();
    }

    public boolean hasQueryString(Node node) {
        String uri = node.getURI();
        int qMarkIndex = uri.indexOf("?");
        int hashTagIndex = uri.indexOf("#");
        return qMarkIndex > -1 && (hashTagIndex == -1 || qMarkIndex < hashTagIndex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$isInternal$1(Node node$1, String prefix) {
        return (node$1.isLiteral() ? node$1.getLiteralLexicalForm() : node$1.toString()).startsWith(prefix);
    }

    private NodeUtils$() {
        MODULE$ = this;
        this.isLicenseDefination = new Regex(".*(licensed?|copyrighte?d?).*(under|grante?d?|rights?).*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.licenceIndications = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DQV$.MODULE$.dqv_description(), RDFS.comment.getURI(), RDFS.label.getURI()}));
        this.licenceAssociated = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DQV$.MODULE$.cclicence(), DQV$.MODULE$.dbolicense(), DQV$.MODULE$.xhtmllicense(), DQV$.MODULE$.dclicence(), DQV$.MODULE$.dcrights(), DQV$.MODULE$.dctlicense(), DQV$.MODULE$.dbplicence(), DQV$.MODULE$.doaplicense(), DQV$.MODULE$.dctrights(), DQV$.MODULE$.schemalicense(), "wrcc:license", "sz:license_text"}));
    }
}

