/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.common.partition.utils;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionStateDefault;
import net.sansa_stack.rdf.common.partition.utils.TableIdentifier;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class SQLUtils$ {
    public static SQLUtils$ MODULE$;
    private final Regex qualifiedTableNameDoubleQuotesRegex;
    private final Regex qualifiedTableNameBackticksRegex;

    static {
        new SQLUtils$();
    }

    public Regex qualifiedTableNameDoubleQuotesRegex() {
        return this.qualifiedTableNameDoubleQuotesRegex;
    }

    public Regex qualifiedTableNameBackticksRegex() {
        return this.qualifiedTableNameBackticksRegex;
    }

    public TableIdentifier parseTableIdentifier(String tableName) {
        TableIdentifier tableIdentifier;
        Option option = this.qualifiedTableNameDoubleQuotesRegex().findFirstMatchIn((CharSequence)tableName);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match i = (Regex.Match)some.value();
            String tn = i.group(3);
            Option dn = Option$.MODULE$.apply((Object)i.group(2));
            tableIdentifier = new TableIdentifier(tn, (Option<String>)dn);
        } else if (None$.MODULE$.equals(option)) {
            tableIdentifier = new TableIdentifier(tableName, (Option<String>)None$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        return tableIdentifier;
    }

    public String encodeTablename(String name) {
        return URLEncoder.encode(name, StandardCharsets.UTF_8.toString()).toLowerCase().replace('%', 'p').replace('.', 'c').replace("-", "dash");
    }

    public String createDefaultTableName(RdfPartitionStateDefault p) {
        String predPart = p.predicate();
        Node pn = NodeFactory.createURI((String)p.predicate());
        String dt = p.datatype();
        String dtPart = dt != null && new StringOps(Predef$.MODULE$.augmentString(dt)).nonEmpty() ? new StringBuilder(1).append("_").append(dt.substring(dt.lastIndexOf("/") + 1)).toString() : "";
        String langPart = p.langTagPresent() ? "_lang" : "";
        String sTermTypePart = p.subjectType() == 0 ? "sbn" : "";
        String oTermTypePart = p.objectType() == 0 ? "obn" : "";
        String tableName = new StringBuilder(0).append(predPart).append(dtPart).append(langPart).append(sTermTypePart).append(oTermTypePart).toString();
        return tableName;
    }

    private SQLUtils$() {
        MODULE$ = this;
        this.qualifiedTableNameDoubleQuotesRegex = new StringOps(Predef$.MODULE$.augmentString("^(\"(.*)\".)?\"(.*)\"$")).r();
        this.qualifiedTableNameBackticksRegex = new StringOps(Predef$.MODULE$.augmentString("^(`(.*)`.)?`(.*)`$")).r();
    }
}

