/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.common.partition.utils;

import net.sansa_stack.rdf.common.partition.utils.RdfTerm;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class RdfTerm$
implements Serializable {
    public static RdfTerm$ MODULE$;

    static {
        new RdfTerm$();
    }

    public String toLexicalForm(Object o) {
        return String.valueOf(o);
    }

    /*
     * WARNING - void declaration
     */
    public Node termToNode(RdfTerm term) {
        void var3_7;
        Node node;
        String lexicalForm = this.toLexicalForm(term.v());
        int n = term.t();
        switch (n) {
            case 0: {
                node = NodeFactory.createBlankNode((String)lexicalForm);
                break;
            }
            case 1: {
                node = NodeFactory.createURI((String)lexicalForm);
                break;
            }
            case 2: {
                String dt = term.dt();
                if (term.dt() == null || new StringOps(Predef$.MODULE$.augmentString(term.dt())).nonEmpty()) {
                    // empty if block
                }
                node = NodeFactory.createLiteral((String)lexicalForm, (String)term.lang());
                break;
            }
            case 3: {
                String lang = term.lang();
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(term.dt());
                node = NodeFactory.createLiteral((String)lexicalForm, (RDFDatatype)dt);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        Node result = node;
        return var3_7;
    }

    public RdfTerm nodeToTerm(Node node) {
        int t = 0;
        Object v = "";
        String lang = null;
        String dt = null;
        if (node.isBlank()) {
            t = 0;
            v = node.getBlankNodeId().getLabelString();
        } else if (node.isURI()) {
            t = 1;
            v = node.getURI();
        } else if (node.isLiteral()) {
            v = node.getLiteral().getValue();
            dt = node.getLiteralDatatypeURI();
            if (dt == null || dt.isEmpty()) {
                t = 2;
                lang = node.getLiteralLanguage();
            } else {
                t = 3;
                dt = node.getLiteralDatatypeURI();
            }
        } else {
            throw new RuntimeException("Should not happen");
        }
        String dtStr = dt == null ? "" : dt;
        String langStr = lang == null ? "" : lang;
        return new RdfTerm(t, String.valueOf(v), lang, dt);
    }

    public RdfTerm apply(int t, String v, String lang, String dt) {
        return new RdfTerm(t, v, lang, dt);
    }

    public Option<Tuple4<Object, String, String, String>> unapply(RdfTerm x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)x$0.t()), (Object)x$0.v(), (Object)x$0.lang(), (Object)x$0.dt()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RdfTerm$() {
        MODULE$ = this;
    }
}

