/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.common.partition.r2rml;

import java.io.Serializable;
import net.sansa_stack.rdf.common.partition.core.RdfPartitionStateDefault;
import net.sansa_stack.rdf.common.partition.core.RdfPartitioner;
import net.sansa_stack.rdf.common.partition.core.TermType$;
import net.sansa_stack.rdf.common.partition.utils.SQLUtils$;
import org.aksw.commons.codec.entity.api.EntityCodec;
import org.aksw.commons.sql.codec.api.SqlCodec;
import org.aksw.commons.sql.codec.util.SqlCodecUtils;
import org.aksw.r2rml.jena.arq.lib.R2rmlLib;
import org.aksw.r2rml.jena.domain.api.ObjectMap;
import org.aksw.r2rml.jena.domain.api.PredicateMap;
import org.aksw.r2rml.jena.domain.api.PredicateObjectMap;
import org.aksw.r2rml.jena.domain.api.SubjectMap;
import org.aksw.r2rml.jena.domain.api.TermMap;
import org.aksw.r2rml.jena.domain.api.TriplesMap;
import org.aksw.r2rml.jena.vocab.RR;
import org.aksw.r2rmlx.domain.api.TermMapX;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprVar;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.api.Symbols;
import scala.reflect.api.Types;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class R2rmlUtils$ {
    public static R2rmlUtils$ MODULE$;

    static {
        new R2rmlUtils$();
    }

    public ExprVar newExprVar(String varName) {
        return new ExprVar(Var.alloc((String)varName));
    }

    public ExprVar newExprVar(int varId) {
        return this.newExprVar(new StringBuilder(1).append("_").append(varId).toString());
    }

    public ExprVar newExprVar(int i, List<String> attrNames) {
        String attrName = (String)attrNames.apply(i);
        return this.newExprVar(attrName);
    }

    public Seq<TriplesMap> createR2rmlMappings(RdfPartitioner<RdfPartitionStateDefault> partitioner, Seq<RdfPartitionStateDefault> partitionStates, Model outModel, boolean explodeLanguageTags) {
        return (Seq)partitionStates.flatMap((Function1 & Serializable & scala.Serializable)p -> MODULE$.createR2rmlMappings(partitioner, (RdfPartitionStateDefault)p, outModel, explodeLanguageTags), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<TriplesMap> createR2rmlMappings(RdfPartitioner<RdfPartitionStateDefault> partitioner, Seq<RdfPartitionStateDefault> partitionStates, Function1<RdfPartitionStateDefault, String> extractTableName, Option<String> tableNameQualifier, SqlCodec sqlCodec, Model outModel, boolean explodeLanguageTags) {
        return (Seq)partitionStates.flatMap((Function1 & Serializable & scala.Serializable)p -> MODULE$.createR2rmlMappings(partitioner, (RdfPartitionStateDefault)p, extractTableName, tableNameQualifier, sqlCodec, outModel, explodeLanguageTags), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<TriplesMap> createR2rmlMappings(RdfPartitioner<RdfPartitionStateDefault> partitioner, RdfPartitionStateDefault partitionState, Model outModel, boolean explodeLanguageTags) {
        return this.createR2rmlMappings(partitioner, partitionState, (Function1<RdfPartitionStateDefault, String>)(Function1 & Serializable & scala.Serializable)p -> SQLUtils$.MODULE$.createDefaultTableName((RdfPartitionStateDefault)p), (Option<String>)None$.MODULE$, SqlCodecUtils.createSqlCodecDefault(), outModel, explodeLanguageTags);
    }

    public Seq<TriplesMap> createR2rmlMappings(RdfPartitioner<RdfPartitionStateDefault> partitioner, RdfPartitionStateDefault partitionState, Function1<RdfPartitionStateDefault, String> extractTableName, Option<String> tableNameQualifier, SqlCodec sqlCodec, Model outModel, boolean explodeLanguageTags) {
        Seq seq;
        RdfPartitionStateDefault p = partitionState;
        Types.TypeApi t = partitioner.determineLayout(partitionState).schema();
        List columnNames = (List)t.members().sorted().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Symbols.SymbolApi, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Symbols.MethodSymbolApi methodSymbolApi;
                A1 A1 = x1;
                Object object = A1 instanceof Symbols.MethodSymbolApi && (methodSymbolApi = (Symbols.MethodSymbolApi)A1).isCaseAccessor() ? methodSymbolApi.name().toString() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Symbols.SymbolApi x1) {
                Symbols.MethodSymbolApi methodSymbolApi;
                Symbols.SymbolApi symbolApi = x1;
                boolean bl = symbolApi instanceof Symbols.MethodSymbolApi && (methodSymbolApi = (Symbols.MethodSymbolApi)symbolApi).isCaseAccessor();
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
        EntityCodec entityCodec = sqlCodec.forColumnName();
        List encodedColumnNames = (List)columnNames.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)entityCodec.encode(x$1), List$.MODULE$.canBuildFrom());
        String predicateIri = partitionState.predicate();
        String tableName = (String)extractTableName.apply((Object)partitionState);
        String encodedTableName = new StringBuilder(0).append((String)tableNameQualifier.map((Function1 & Serializable & scala.Serializable)tnq -> new StringBuilder(1).append((String)sqlCodec.forSchemaName().encode(tnq)).append(".").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(sqlCodec.forTableName().encode((Object)tableName)).toString();
        if (explodeLanguageTags && encodedColumnNames.length() == 3) {
            List projectedColumns = encodedColumnNames.slice(0, 2);
            String columnsSql = projectedColumns.mkString(", ");
            String langColSql = (String)encodedColumnNames.apply(2);
            if (p.languages().size() == 1) {
                TriplesMap tm = (TriplesMap)outModel.createResource().as(TriplesMap.class);
                PredicateObjectMap pom = tm.addNewPredicateObjectMap();
                pom.addPredicate(predicateIri);
                SubjectMap sm = tm.getOrSetSubjectMap();
                this.setTermMapForNode((TermMap)sm, 0, (List<String>)encodedColumnNames, p.subjectType(), "", false);
                ObjectMap om = pom.addNewObjectMap();
                om.setColumn((String)encodedColumnNames.apply(1));
                Object object = new StringOps(Predef$.MODULE$.augmentString(((String)p.languages().head()).trim())).nonEmpty() ? om.setLanguage((String)p.languages().head()) : BoxedUnit.UNIT;
                tm.getOrSetLogicalTable().asBaseTableOrView().setTableName(encodedTableName);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TriplesMap[]{tm}));
            } else {
                seq = ((SetLike)p.languages().map((Function1 & Serializable & scala.Serializable)lang -> {
                    String langSql = (String)sqlCodec.forStringLiteral().encode(lang);
                    TriplesMap tm = (TriplesMap)outModel.createResource().as(TriplesMap.class);
                    SubjectMap sm = tm.getOrSetSubjectMap();
                    MODULE$.setTermMapForNode((TermMap)sm, 0, (List<String>)encodedColumnNames, p.subjectType(), "", false);
                    PredicateObjectMap pom = tm.addNewPredicateObjectMap();
                    pom.addPredicate(predicateIri);
                    ObjectMap om = pom.addNewObjectMap();
                    om.setColumn((String)encodedColumnNames.apply(1));
                    Object object = new StringOps(Predef$.MODULE$.augmentString(lang.trim())).nonEmpty() ? om.setLanguage(lang) : BoxedUnit.UNIT;
                    tm.getOrSetLogicalTable().asR2rmlView().setSqlQuery(new StringBuilder(23).append("SELECT ").append(columnsSql).append(" FROM ").append(encodedTableName).append(" WHERE ").append(langColSql).append(" = ").append(langSql).toString());
                    return tm;
                }, Set$.MODULE$.canBuildFrom())).toSeq();
            }
        } else {
            TriplesMap tm = (TriplesMap)outModel.createResource().as(TriplesMap.class);
            SubjectMap sm = tm.getOrSetSubjectMap();
            this.setTermMapForNode((TermMap)sm, 0, (List<String>)encodedColumnNames, p.subjectType(), "", false);
            PredicateObjectMap pom = tm.addNewPredicateObjectMap();
            pom.addPredicate(predicateIri);
            ObjectMap om = pom.addNewObjectMap();
            this.setTermMapForNode((TermMap)om, 1, (List<String>)encodedColumnNames, p.objectType(), p.datatype(), p.langTagPresent());
            tm.getOrSetLogicalTable().asBaseTableOrView().setTableName(encodedTableName);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TriplesMap[]{tm}));
        }
        return seq;
    }

    public Option<String> createR2rmlMappings$default$4() {
        return None$.MODULE$;
    }

    public TermMap setTermMapForNode(TermMap target, int offset, List<String> attrNames, byte termType, String datatype, boolean langTagPresent) {
        TermMap termMap;
        int o = offset;
        ExprVar on = this.newExprVar(o, attrNames);
        byte by = termType;
        if (TermType$.MODULE$.BLANK() == by) {
            termMap = target.setColumn((String)attrNames.apply(o)).setTermType(RR.BlankNode.inModel(target.getModel()));
        } else if (TermType$.MODULE$.IRI() == by) {
            termMap = target.setColumn((String)attrNames.apply(o)).setTermType(RR.IRI.inModel(target.getModel()));
        } else if (TermType$.MODULE$.LITERAL() == by) {
            target.setColumn((String)attrNames.apply(o));
            termMap = langTagPresent ? ((TermMapX)target.as(TermMapX.class)).setLangColumn((String)attrNames.apply(o + 1)) : target.setDatatype((Resource)ResourceFactory.createProperty((String)datatype));
        } else {
            throw new RuntimeException("Unhandled case");
        }
        return target;
    }

    public Iterator<TriplesMap> streamTriplesMaps(Model model) {
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(R2rmlLib.streamTriplesMaps((Model)model).iterator()).asScala();
    }

    public Iterator<TriplesMap> triplesMapsForPredicate(Property predicate, Model model) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)model.listResourcesWithProperty(RR.subjectMap)).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (TriplesMap)x$1.as(TriplesMap.class)).filter((Function1 & Serializable & scala.Serializable)tm -> BoxesRunTime.boxToBoolean((boolean)R2rmlUtils$.$anonfun$triplesMapsForPredicate$2(predicate, tm)));
    }

    public static final /* synthetic */ boolean $anonfun$triplesMapsForPredicate$4(Property predicate$1, PredicateMap pm) {
        return Option$.MODULE$.apply((Object)pm.getConstant()).contains((Object)predicate$1);
    }

    public static final /* synthetic */ boolean $anonfun$triplesMapsForPredicate$3(Property predicate$1, PredicateObjectMap x$2) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$2.getPredicateMaps()).asScala()).exists((Function1 & Serializable & scala.Serializable)pm -> BoxesRunTime.boxToBoolean((boolean)R2rmlUtils$.$anonfun$triplesMapsForPredicate$4(predicate$1, pm)));
    }

    public static final /* synthetic */ boolean $anonfun$triplesMapsForPredicate$2(Property predicate$1, TriplesMap tm) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tm.getPredicateObjectMaps()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)R2rmlUtils$.$anonfun$triplesMapsForPredicate$3(predicate$1, x$2)));
    }

    private R2rmlUtils$() {
        MODULE$ = this;
    }
}

