/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.common.io.riot.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sansa_stack.rdf.common.io.riot.lang.NoErrorProfile;
import net.sansa_stack.rdf.common.io.riot.tokens.TokenizerTextForgiving;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LangNQuadsSkipBad
implements Iterator<Quad> {
    private static Logger messageLog = LoggerFactory.getLogger(LangNQuadsSkipBad.class);
    private RiotException bad = null;
    private PeekIterator<Quad> base = null;

    public LangNQuadsSkipBad(TokenizerTextForgiving tokens, ParserProfile profile, StreamRDF dest) {
        try {
            this.base = new PeekIterator((Iterator)((Object)new Wrapper(tokens, profile, dest)));
        }
        catch (RiotException e) {
            this.bad = e;
            profile.getErrorHandler().warning(e.getMessage(), -1L, -1L);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.base == null) {
            return false;
        }
        try {
            while (this.base.peek() == null) {
                this.base.next();
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return this.base.hasNext();
    }

    @Override
    public Quad next() {
        if (this.bad != null) {
            throw this.bad;
        }
        while (this.base.peek() == null) {
            this.base.next();
        }
        return (Quad)this.base.next();
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    static class Wrapper
    extends LangNTuple<Quad> {
        private Node currentGraph = null;
        private ErrorHandler errorHandler;

        Wrapper(Tokenizer tokens, ParserProfile profile, StreamRDF dest) {
            super(tokens, (ParserProfile)new NoErrorProfile(profile), dest);
            this.errorHandler = profile.getErrorHandler();
        }

        protected final void runParser() {
            while (this.hasNext()) {
                Quad x = this.parseOne();
                if (x == null) continue;
                this.dest.quad(x);
            }
        }

        protected final Quad parseOne() {
            boolean needSkip = false;
            try {
                Token sToken = this.nextToken();
                if (sToken.getType() == TokenType.EOF) {
                    this.exception(sToken, "Premature end of file: %s", new Object[]{sToken});
                }
                needSkip = true;
                this.checkIRIOrBNode(sToken);
                needSkip = false;
                Token pToken = this.nextToken();
                if (pToken.getType() == TokenType.EOF) {
                    this.exception(pToken, "Premature end of file: %s", new Object[]{pToken});
                }
                needSkip = true;
                this.checkIRI(pToken);
                needSkip = false;
                Token oToken = this.nextToken();
                if (oToken.getType() == TokenType.EOF) {
                    this.exception(oToken, "Premature end of file: %s", new Object[]{oToken});
                }
                needSkip = true;
                this.checkRDFTerm(oToken);
                needSkip = false;
                Token xToken = this.nextToken();
                if (xToken.getType() == TokenType.EOF) {
                    this.exception(xToken, "Premature end of file: Quad not terminated by DOT: %s", new Object[]{xToken});
                }
                Node c = null;
                if (xToken.getType() != TokenType.DOT) {
                    needSkip = true;
                    this.checkIRIOrBNode(xToken);
                    needSkip = false;
                    c = this.tokenAsNode(xToken);
                    xToken = this.nextToken();
                    this.currentGraph = c;
                } else {
                    c = Quad.defaultGraphNodeGenerated;
                    this.currentGraph = null;
                }
                Node s = this.tokenAsNode(sToken);
                Node p = this.tokenAsNode(pToken);
                Node o = this.tokenAsNode(oToken);
                needSkip = true;
                if (xToken.getType() != TokenType.DOT) {
                    this.exception(xToken, "Quad not terminated by DOT: %s", new Object[]{xToken});
                }
                return this.profile.createQuad(c, s, p, o, sToken.getLine(), sToken.getColumn());
            }
            catch (RiotParseException e) {
                this.errorHandler.warning("skipping line " + e.getOriginalMessage(), e.getLine(), e.getCol());
                if (needSkip) {
                    ((TokenizerTextForgiving)this.tokens).skipLine();
                    this.nextToken();
                }
            }
            catch (NullPointerException e2) {
                this.errorHandler.warning(e2.getMessage(), this.currLine, this.currCol);
            }
            return null;
        }

        protected final Node tokenAsNode(Token token) {
            return this.profile.create(null, token);
        }

        public Lang getLang() {
            return RDFLanguages.NQUADS;
        }
    }
}

