/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.common.io.riot.tokens;

import java.io.Closeable;
import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenChecker;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.ARQInternalErrorException;

public final class TokenizerTextForgiving
implements Tokenizer {
    public static final int CTRL_CHAR = 42;
    public static boolean Checking = false;
    protected Token token = null;
    protected final StringBuilder stringBuilder = new StringBuilder(200);
    protected final PeekReader reader;
    protected final boolean lineMode;
    protected boolean finished = false;
    protected TokenChecker checker = null;
    protected RiotException bad = null;
    public static final ErrorHandler defaultErrorHandler = new ErrorHandlerTokenizer();
    protected ErrorHandler errorHandler = defaultErrorHandler;
    protected static final boolean VeryVeryLaxIRI = false;
    protected static final boolean AllowSpacesInIRI = false;
    protected static char[] extraCharsWord = new char[]{'_', '.', '-'};
    protected static char[] extraCharsVar = new char[]{'_', '.', '-', '?', '@', '+'};

    public TokenizerTextForgiving(PeekReader reader) {
        this(reader, false);
    }

    public TokenizerTextForgiving(PeekReader reader, boolean lineMode) {
        this.reader = reader;
        this.lineMode = lineMode;
    }

    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.token != null) {
            return true;
        }
        if (this.bad != null) {
            RiotException bad2 = this.bad;
            this.bad = null;
            throw bad2;
        }
        try {
            this.skip();
            if (this.reader.eof()) {
                this.finished = true;
                return false;
            }
            this.token = this.parseToken();
            if (this.token == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (AtlasException ex) {
            if (ex.getCause() != null) {
                if (ex.getCause().getClass() == MalformedInputException.class) {
                    throw new RiotParseException("Bad character encoding", this.reader.getLineNum(), this.reader.getColNum());
                }
                throw new RiotParseException("Bad input stream [" + ex.getCause() + "]", this.reader.getLineNum(), this.reader.getColNum());
            }
            throw new RiotParseException("Bad input stream", this.reader.getLineNum(), this.reader.getColNum());
        }
        catch (RiotException e) {
            RiotException bad3 = e;
            this.skipLine();
            this.token = null;
            this.bad = null;
            boolean ret = this.hasNext();
            this.bad = bad3;
            return ret;
        }
    }

    public final boolean eof() {
        return !this.hasNext();
    }

    public final Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.token;
        this.token = null;
        return t;
    }

    public final Token peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.token;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public TokenChecker getChecker() {
        return this.checker;
    }

    public void setChecker(TokenChecker checker) {
        this.checker = checker;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void close() {
        IO.close((Closeable)this.reader);
    }

    public void skipLine() {
        int ch;
        while ((ch = this.reader.peekChar()) != -1 && !RiotChars.isNewlineChar((int)ch)) {
            this.reader.readChar();
        }
    }

    protected void skip() {
        int ch = -1;
        while (true) {
            if (this.reader.eof()) {
                return;
            }
            ch = this.reader.peekChar();
            if (ch == 35) {
                this.reader.readChar();
                while ((ch = this.reader.peekChar()) != -1 && !RiotChars.isNewlineChar((int)ch)) {
                    this.reader.readChar();
                }
            }
            if (this.lineMode ? !RiotChars.isHorizontalWhitespace((int)ch) : !RiotChars.isWhitespace((int)ch)) break;
            this.reader.readChar();
        }
    }

    protected Token parseToken() {
        this.token = new Token(this.getLine(), this.getColumn());
        int ch = this.reader.peekChar();
        if (ch == 60) {
            this.reader.readChar();
            this.token.setImage(this.readIRI());
            this.token.setType(TokenType.IRI);
            if (Checking) {
                this.checkURI(this.token.getImage());
            }
            return this.token;
        }
        if (ch == 39 || ch == 34) {
            this.token.setType(TokenType.STRING);
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (ch2 == ch) {
                StringType st;
                this.reader.readChar();
                int ch3 = this.reader.peekChar();
                if (ch3 == ch) {
                    this.reader.readChar();
                    this.token.setImage(this.readLongString(ch, false));
                    st = ch == 39 ? StringType.LONG_STRING1 : StringType.LONG_STRING2;
                    this.token.setStringType(st);
                } else {
                    this.token.setImage("");
                    st = ch == 39 ? StringType.STRING1 : StringType.STRING2;
                    this.token.setStringType(st);
                }
            } else {
                this.token.setImage(this.readString(ch, ch));
                StringType st = ch == 39 ? StringType.STRING1 : StringType.STRING2;
                this.token.setStringType(st);
            }
            this.skip();
            if (this.reader.peekChar() == 64) {
                this.reader.readChar();
                Token mainToken = new Token(this.token);
                mainToken.setType(TokenType.LITERAL_LANG);
                mainToken.setSubToken1(this.token);
                mainToken.setImage2(this.langTag());
                this.token = mainToken;
                if (Checking) {
                    this.checkLiteralLang(this.token.getImage(), this.token.getImage2());
                }
            } else if (this.reader.peekChar() == 94) {
                this.expect("^^");
                this.skip();
                Token mainToken = new Token(this.token);
                mainToken.setSubToken1(this.token);
                mainToken.setImage(this.token.getImage());
                Token subToken = this.parseToken();
                if (!subToken.isIRI()) {
                    this.error("Datatype URI required after ^^ - URI or prefixed name expected", new Object[0]);
                }
                mainToken.setSubToken2(subToken);
                mainToken.setType(TokenType.LITERAL_DT);
                this.token = mainToken;
                if (Checking) {
                    this.checkLiteralDT(this.token.getImage(), subToken);
                }
            } else if (Checking) {
                this.checkString(this.token.getImage());
            }
            return this.token;
        }
        if (ch == 95) {
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (ch2 == 58) {
                this.reader.readChar();
                this.token.setImage(this.readBlankNodeLabel());
                this.token.setType(TokenType.BNODE);
                if (Checking) {
                    this.checkBlankNode(this.token.getImage());
                }
                return this.token;
            }
            this.token.setType(TokenType.UNDERSCORE);
            return this.token;
        }
        if (ch == 64) {
            this.reader.readChar();
            this.token.setType(TokenType.DIRECTIVE);
            this.token.setImage(this.readWord(false));
            if (Checking) {
                this.checkDirective(this.token.cntrlCode);
            }
            return this.token;
        }
        if (ch == 63) {
            this.reader.readChar();
            this.token.setType(TokenType.VAR);
            this.token.setImage(this.readVarName());
            if (Checking) {
                this.checkVariable(this.token.getImage());
            }
            return this.token;
        }
        switch (ch) {
            case 46: {
                this.reader.readChar();
                ch = this.reader.peekChar();
                if (RiotChars.range((int)ch, (char)'0', (char)'9')) {
                    this.reader.pushbackChar(46);
                    this.readNumber();
                    if (Checking) {
                        this.checkNumber(this.token.getImage(), this.token.getImage2());
                    }
                    return this.token;
                }
                this.token.setType(TokenType.DOT);
                return this.token;
            }
            case 59: {
                this.reader.readChar();
                this.token.setType(TokenType.SEMICOLON);
                return this.token;
            }
            case 44: {
                this.reader.readChar();
                this.token.setType(TokenType.COMMA);
                return this.token;
            }
            case 123: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACE);
                return this.token;
            }
            case 125: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACE);
                return this.token;
            }
            case 40: {
                this.reader.readChar();
                this.token.setType(TokenType.LPAREN);
                return this.token;
            }
            case 41: {
                this.reader.readChar();
                this.token.setType(TokenType.RPAREN);
                return this.token;
            }
            case 91: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACKET);
                return this.token;
            }
            case 93: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACKET);
                return this.token;
            }
            case 61: {
                this.reader.readChar();
                this.token.setType(TokenType.EQUALS);
                return this.token;
            }
            case 47: {
                this.reader.readChar();
                this.token.setType(TokenType.SLASH);
                return this.token;
            }
            case 92: {
                this.reader.readChar();
                this.token.setType(TokenType.RSLASH);
                return this.token;
            }
            case 124: {
                this.reader.readChar();
                this.token.setType(TokenType.VBAR);
                return this.token;
            }
            case 38: {
                this.reader.readChar();
                this.token.setType(TokenType.AMPHERSAND);
                return this.token;
            }
            case 60: {
                this.reader.readChar();
                this.token.setType(TokenType.LT);
                return this.token;
            }
            case 62: {
                this.reader.readChar();
                this.token.setType(TokenType.GT);
                return this.token;
            }
            case 42: {
                this.reader.readChar();
                this.token.setType(TokenType.STAR);
                return this.token;
            }
        }
        int signCh = 0;
        if (ch == 43 || ch == 45) {
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (!RiotChars.range((int)ch2, (char)'0', (char)'9')) {
                if (ch == 43) {
                    this.token.setType(TokenType.PLUS);
                } else {
                    this.token.setType(TokenType.MINUS);
                }
                return this.token;
            }
            this.reader.pushbackChar(ch);
            signCh = ch;
        }
        if (ch == 43 || ch == 45 || RiotChars.range((int)ch, (char)'0', (char)'9')) {
            this.readNumber();
            if (Checking) {
                this.checkNumber(this.token.getImage(), this.token.getImage2());
            }
            return this.token;
        }
        if (RiotChars.isNewlineChar((int)ch)) {
            do {
                int n = this.reader.readChar();
            } while (RiotChars.isNewlineChar((int)this.reader.peekChar()));
            this.token.setType(TokenType.NL);
            return this.token;
        }
        this.readPrefixedNameOrKeyword(this.token);
        if (Checking) {
            this.checkKeyword(this.token.getImage());
        }
        return this.token;
    }

    protected String readIRI() {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch = this.reader.readChar();
            switch (ch) {
                case -1: {
                    this.error("Broken IRI (End of file)", new Object[0]);
                    return null;
                }
                case 10: {
                    this.error("Broken IRI (newline): %s", this.stringBuilder.toString());
                    return null;
                }
                case 13: {
                    this.error("Broken IRI (CR): %s", this.stringBuilder.toString());
                    return null;
                }
                case 62: {
                    return this.stringBuilder.toString();
                }
                case 92: {
                    ch = this.readUnicodeEscape();
                    break;
                }
                case 60: {
                    this.error("Bad character in IRI (bad character: '<'): <%s[<]...>", this.stringBuilder.toString());
                    return null;
                }
                case 9: {
                    this.error("Bad character in IRI (Tab character): <%s[tab]...>", this.stringBuilder.toString());
                    return null;
                }
                case 34: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: {
                    this.warning("Illegal character in IRI (codepoint 0x%02X, '%c'): <%s[%c]...>", ch, Character.valueOf((char)ch), this.stringBuilder.toString(), Character.valueOf((char)ch));
                    break;
                }
                case 32: {
                    this.warning("Bad character in IRI (space): <%s[space]...>", this.stringBuilder.toString());
                    break;
                }
                default: {
                    if (ch > 25) break;
                    this.warning("Illegal character in IRI (control char 0x%02X): <%s[0x%02X]...>", ch, this.stringBuilder.toString(), ch);
                }
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    protected final int readUnicodeEscape() {
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.error("Broken escape sequence", new Object[0]);
        }
        switch (ch) {
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.error("Illegal unicode escape sequence value: \\%c (0x%02X)", ch, ch);
        return 0;
    }

    protected void readPrefixedNameOrKeyword(Token token) {
        long posn = this.reader.getPosition();
        String prefixPart = this.readPrefixPart();
        token.setImage(prefixPart);
        token.setType(TokenType.KEYWORD);
        int ch = this.reader.peekChar();
        if (ch == 58) {
            this.reader.readChar();
            token.setType(TokenType.PREFIXED_NAME);
            String ln = this.readLocalPart();
            token.setImage2(ln);
            if (Checking) {
                this.checkPrefixedName(token.getImage(), token.getImage2());
            }
        }
        if (posn == this.reader.getPosition()) {
            this.error("Failed to find a prefix name or keyword: %c(%d;0x%04X)", ch, ch, ch);
        }
        if (Checking) {
            this.checkKeyword(token.getImage());
        }
    }

    protected String readPrefixPart() {
        return this.readSegment(false);
    }

    protected String readLocalPart() {
        return this.readSegment(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String readSegment(boolean isLocalPart) {
        this.stringBuilder.setLength(0);
        int ch = this.reader.peekChar();
        if (ch == -1) {
            return "";
        }
        if (isLocalPart) {
            if (ch == 58) {
                this.reader.readChar();
                this.stringBuilder.append((char)ch);
            } else if (ch == 37 || ch == 92) {
                this.reader.readChar();
                this.processPLX(ch);
            } else {
                if (!RiotChars.isPNChars_U_N((int)ch)) return "";
                this.stringBuilder.append((char)ch);
                this.reader.readChar();
            }
        } else {
            if (!RiotChars.isPNCharsBase((int)ch)) {
                return "";
            }
            this.stringBuilder.append((char)ch);
            this.reader.readChar();
        }
        int chDot = 0;
        while (true) {
            ch = this.reader.peekChar();
            boolean valid = false;
            if (isLocalPart && (ch == 37 || ch == 92)) {
                this.reader.readChar();
                if (chDot != 0) {
                    this.stringBuilder.append((char)chDot);
                }
                this.processPLX(ch);
                chDot = 0;
                continue;
            }
            valid = isLocalPart && ch == 58 ? true : (RiotChars.isPNChars((int)ch) ? true : ch == 46);
            if (!valid) break;
            this.reader.readChar();
            if (chDot != 0) {
                this.stringBuilder.append((char)chDot);
                chDot = 0;
            }
            if (ch != 46) {
                this.stringBuilder.append((char)ch);
                continue;
            }
            chDot = ch;
        }
        if (chDot != 46) return this.stringBuilder.toString();
        this.reader.pushbackChar(chDot);
        return this.stringBuilder.toString();
    }

    protected void processPLX(int ch) {
        if (ch == 37) {
            this.stringBuilder.append((char)ch);
            ch = this.reader.peekChar();
            if (!RiotChars.isHexChar((int)ch)) {
                this.error("Not a hex character: '%c'", ch);
            }
            this.stringBuilder.append((char)ch);
            this.reader.readChar();
            ch = this.reader.peekChar();
            if (!RiotChars.isHexChar((int)ch)) {
                this.error("Not a hex character: '%c'", ch);
            }
            this.stringBuilder.append((char)ch);
            this.reader.readChar();
        } else if (ch == 92) {
            ch = this.readCharEscape();
            this.stringBuilder.append((char)ch);
        } else {
            throw new ARQInternalErrorException("Not a '\\' or a '%' character");
        }
    }

    protected String readString(int startCh, int endCh) {
        long y = this.getLine();
        long x = this.getColumn();
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                this.error("Broken token: " + this.stringBuilder.toString(), y, x);
            }
            if (ch == 10) {
                this.error("Broken token (newline): " + this.stringBuilder.toString(), y, x);
            }
            if (ch == endCh) {
                return this.stringBuilder.toString();
            }
            if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    protected String readLongString(int quoteChar, boolean endNL) {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                if (endNL) {
                    return this.stringBuilder.toString();
                }
                this.error("Broken long string", new Object[0]);
            }
            if (ch == quoteChar && this.threeQuotes(quoteChar)) {
                return this.stringBuilder.toString();
            }
            if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    protected String readWord(boolean leadingDigitAllowed) {
        return this.readWordSub(leadingDigitAllowed, false);
    }

    protected String readWordSub(boolean leadingDigitAllowed, boolean leadingSignAllowed) {
        return this.readCharsAnd(leadingDigitAllowed, leadingSignAllowed, extraCharsWord, false);
    }

    protected String readVarName() {
        return this.readCharsAnd(true, true, extraCharsVar, true);
    }

    protected String readCharsAnd(boolean leadingDigitAllowed, boolean leadingSignAllowed, char[] extraChars, boolean allowFinalDot) {
        int ch;
        this.stringBuilder.setLength(0);
        int idx = 0;
        if (!leadingDigitAllowed && Character.isDigit(ch = this.reader.peekChar())) {
            return "";
        }
        if (!(leadingSignAllowed || (ch = this.reader.peekChar()) != 45 && ch != 43)) {
            return "";
        }
        while (RiotChars.isAlphaNumeric((int)(ch = this.reader.peekChar())) || Chars.charInArray((int)ch, (char[])extraChars)) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
            ++idx;
        }
        if (!allowFinalDot) {
            while (idx > 0 && this.stringBuilder.charAt(idx - 1) == '.') {
                this.reader.pushbackChar(46);
                this.stringBuilder.setLength(idx - 1);
                --idx;
            }
        }
        return this.stringBuilder.toString();
    }

    protected String readBlankNodeLabel() {
        int ch;
        this.stringBuilder.setLength(0);
        int ch2 = this.reader.peekChar();
        if (ch2 == -1) {
            this.error("Blank node label missing (EOF found)", new Object[0]);
        }
        if (RiotChars.isWhitespace((int)ch2)) {
            this.error("Blank node label missing", new Object[0]);
        }
        if (!RiotChars.isPNChars_U_N((int)ch2)) {
            this.error("Blank node label does not start with alphabetic or _ :" + (char)ch2, new Object[0]);
        }
        this.reader.readChar();
        this.stringBuilder.append((char)ch2);
        int chDot = 0;
        while ((ch = this.reader.peekChar()) != -1 && (RiotChars.isPNChars((int)ch) || ch == 46)) {
            this.reader.readChar();
            if (chDot != 0) {
                this.stringBuilder.append((char)chDot);
                chDot = 0;
            }
            if (ch != 46) {
                this.stringBuilder.append((char)ch);
                continue;
            }
            chDot = ch;
        }
        if (chDot == 46) {
            this.reader.pushbackChar(chDot);
        }
        return this.stringBuilder.toString();
    }

    protected void readNumber() {
        int len;
        boolean isDouble = false;
        boolean isDecimal = false;
        this.stringBuilder.setLength(0);
        int x = 0;
        int ch = this.reader.peekChar();
        if (ch == 48) {
            ++x;
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
            ch = this.reader.peekChar();
            if (ch == 120 || ch == 88) {
                this.reader.readChar();
                this.stringBuilder.append((char)ch);
                this.readHex(this.reader, this.stringBuilder);
                this.token.setImage(this.stringBuilder.toString());
                this.token.setType(TokenType.HEX);
                return;
            }
        } else if (ch == 45 || ch == 43) {
            this.readPossibleSign(this.stringBuilder);
        }
        x += this.readDigits(this.stringBuilder);
        ch = this.reader.peekChar();
        if (ch == 46) {
            this.reader.readChar();
            this.stringBuilder.append('.');
            isDecimal = true;
            this.readDigits(this.stringBuilder);
        }
        if (x == 0 && !isDecimal) {
            this.error("Unrecognized as number", new Object[0]);
        }
        if (this.exponent(this.stringBuilder)) {
            isDouble = true;
            isDecimal = false;
        }
        if (isDecimal && this.stringBuilder.charAt((len = this.stringBuilder.length()) - 1) == '.') {
            this.stringBuilder.setLength(len - 1);
            this.reader.pushbackChar(46);
            isDecimal = false;
        }
        this.token.setImage(this.stringBuilder.toString());
        if (isDouble) {
            this.token.setType(TokenType.DOUBLE);
        } else if (isDecimal) {
            this.token.setType(TokenType.DECIMAL);
        } else {
            this.token.setType(TokenType.INTEGER);
        }
    }

    protected void readHex(PeekReader reader, StringBuilder sb) {
        int ch;
        int x = 0;
        while (RiotChars.isHexChar((int)(ch = reader.peekChar()))) {
            reader.readChar();
            sb.append((char)ch);
            ++x;
        }
        if (x == 0) {
            this.error("No hex characters after " + sb.toString(), new Object[0]);
        }
    }

    protected int readDigits(StringBuilder buffer) {
        int ch;
        int count = 0;
        while (RiotChars.range((int)(ch = this.reader.peekChar()), (char)'0', (char)'9')) {
            this.reader.readChar();
            buffer.append((char)ch);
            ++count;
        }
        return count;
    }

    protected void readPossibleSign(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch == 45 || ch == 43) {
            this.reader.readChar();
            sb.append((char)ch);
        }
    }

    protected boolean threeQuotes(int ch) {
        int ch2 = this.reader.peekChar();
        if (ch2 != ch) {
            return false;
        }
        this.reader.readChar();
        int ch3 = this.reader.peekChar();
        if (ch3 != ch) {
            this.reader.pushbackChar(ch2);
            return false;
        }
        this.reader.readChar();
        return true;
    }

    protected boolean exponent(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch != 101 && ch != 69) {
            return false;
        }
        this.reader.readChar();
        sb.append((char)ch);
        this.readPossibleSign(sb);
        int x = this.readDigits(sb);
        if (x == 0) {
            this.error("Malformed double: " + sb, new Object[0]);
        }
        return true;
    }

    protected String langTag() {
        int ch;
        this.stringBuilder.setLength(0);
        this.a2z(this.stringBuilder);
        if (this.stringBuilder.length() == 0) {
            this.error("Bad language tag", new Object[0]);
        }
        while ((ch = this.reader.peekChar()) == 45) {
            this.reader.readChar();
            this.stringBuilder.append('-');
            int x = this.stringBuilder.length();
            this.a2zN(this.stringBuilder);
            if (this.stringBuilder.length() != x) continue;
            this.error("Bad language tag", new Object[0]);
        }
        return this.stringBuilder.toString().intern();
    }

    protected void a2z(StringBuilder sb2) {
        int ch;
        while (RiotChars.isA2Z((int)(ch = this.reader.peekChar()))) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
        }
    }

    protected void a2zN(StringBuilder sb2) {
        int ch;
        while (RiotChars.isA2ZN((int)(ch = this.reader.peekChar()))) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
        }
    }

    protected void insertCodepoint(StringBuilder buffer, int ch) {
        if (Character.charCount(ch) == 1) {
            buffer.append((char)ch);
        } else {
            if (!Character.isDefined(ch) && !Character.isSupplementaryCodePoint(ch)) {
                this.error("Illegal codepoint: 0x%04X", ch);
            }
            char[] chars = Character.toChars(ch);
            buffer.append(chars);
        }
    }

    public long getColumn() {
        return this.reader.getColNum();
    }

    public long getLine() {
        return this.reader.getLineNum();
    }

    protected void checkBlankNode(String blankNodeLabel) {
        if (this.checker != null) {
            this.checker.checkBlankNode(blankNodeLabel);
        }
    }

    protected void checkLiteralLang(String lexicalForm, String langTag) {
        if (this.checker != null) {
            this.checker.checkLiteralLang(lexicalForm, langTag);
        }
    }

    protected void checkLiteralDT(String lexicalForm, Token datatype) {
        if (this.checker != null) {
            this.checker.checkLiteralDT(lexicalForm, datatype);
        }
    }

    protected void checkString(String string) {
        if (this.checker != null) {
            this.checker.checkString(string);
        }
    }

    protected void checkURI(String uriStr) {
        if (this.checker != null) {
            this.checker.checkURI(uriStr);
        }
    }

    protected void checkNumber(String image, String datatype) {
        if (this.checker != null) {
            this.checker.checkNumber(image, datatype);
        }
    }

    protected void checkVariable(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkVariable(tokenImage);
        }
    }

    protected void checkDirective(int cntrlCode) {
        if (this.checker != null) {
            this.checker.checkDirective(cntrlCode);
        }
    }

    protected void checkKeyword(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkKeyword(tokenImage);
        }
    }

    protected void checkPrefixedName(String tokenImage, String tokenImage2) {
        if (this.checker != null) {
            this.checker.checkPrefixedName(tokenImage, tokenImage2);
        }
    }

    protected void checkControl(int code) {
        if (this.checker != null) {
            this.checker.checkControl(code);
        }
    }

    protected final int readLiteralEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.error("Escape sequence not completed", new Object[0]);
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 102: {
                return 12;
            }
            case 98: {
                return 8;
            }
            case 34: {
                return 34;
            }
            case 39: {
                return 39;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.error("Illegal escape sequence value: %c (0x%02X)", c, c);
        return 0;
    }

    protected final int readCharEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.error("Escape sequence not completed", new Object[0]);
        }
        switch (c) {
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 95: 
            case 126: {
                return c;
            }
        }
        this.error("illegal character escape value: \\%c", c);
        return 0;
    }

    protected final int readUnicode4Escape() {
        return this.readHexSequence(4);
    }

    protected final int readUnicode8Escape() {
        int ch8 = this.readHexSequence(8);
        if (ch8 > 0x10FFFF) {
            this.error("Illegal code point in \\U sequence value: 0x%08X", ch8);
        }
        return ch8;
    }

    protected final int readHexSequence(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHexChar();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    protected final int readHexChar() {
        int x;
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.error("Not a hexadecimal character (end of file)", new Object[0]);
        }
        if ((x = RiotChars.valHexChar((int)ch)) != -1) {
            return x;
        }
        this.error("Not a hexadecimal character: " + (char)ch, new Object[0]);
        return -1;
    }

    protected boolean expect(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char want = str.charAt(i);
            if (this.reader.eof()) {
                this.error("End of input during expected string: " + str, new Object[0]);
                return false;
            }
            int inChar = this.reader.peekChar();
            if (inChar != want) {
                this.error("expected \"" + str + "\"", new Object[0]);
                return false;
            }
            this.reader.readChar();
        }
        return true;
    }

    protected void warning(String message, Object ... args) {
        String msg = String.format(message, args);
        this.errorHandler.warning(msg, this.reader.getLineNum(), this.reader.getColNum());
    }

    protected void error(String message, Object ... args) {
        String msg = String.format(message, args);
        long line = this.reader.getLineNum();
        long col = this.reader.getColNum();
        this.errorHandler.error(msg, line, col);
        throw new RiotParseException(message, line, col);
    }

    public static class ErrorHandlerTokenizer
    implements ErrorHandler {
        public void warning(String message, long line, long col) {
            throw new RiotParseException(message, line, col);
        }

        public void error(String message, long line, long col) {
            throw new RiotParseException(message, line, col);
        }

        public void fatal(String message, long line, long col) {
            throw new RiotParseException(message, line, col);
        }
    }
}

