/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.benchmark.io;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Streams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.aksw.commons.util.compress.MetaBZip2CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.impl.NTripleReader;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedRDFStream;
import org.apache.jena.riot.lang.PipedTriplesStream;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.shared.SyntaxError;

public class SansaBenchRdfIo {
    public static ExecutorService executor = Executors.newSingleThreadExecutor();
    public static NTripleReader reader = SansaBenchRdfIo.forceNew(NTripleReader.class);
    public static ParserProfile parserProfile = RiotLib.dftProfile();

    public static void main(String[] args) throws Exception {
        String url = "http://downloads.linkedgeodata.org/releases/2015-11-02/2015-11-02-Abutters.way.sorted.nt.bz2";
        File tmpDir = new File("/tmp");
        File file = new File(tmpDir, "sansa-bench.nt");
        if (!file.exists()) {
            File tmpFile = new File(file.getPath() + ".tmp");
            MetaBZip2CompressorInputStream in = new MetaBZip2CompressorInputStream(new URL(url).openStream());
            Object object = null;
            try (FileOutputStream out2 = new FileOutputStream(tmpFile);){
                IOUtils.copy((InputStream)in, (OutputStream)out2);
                out2.flush();
            }
            catch (Throwable out2) {
                object = out2;
                throw out2;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable out2) {
                            ((Throwable)object).addSuppressed(out2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            tmpFile.renameTo(file);
        }
        int runs = 2;
        LinkedHashMap<String, Callable<Long>> map = new LinkedHashMap<String, Callable<Long>>();
        map.put("parseWhole", () -> SansaBenchRdfIo.parseFile(file).count());
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("Running " + (String)entry.getKey());
            for (int i = 0; i < runs; ++i) {
                Stopwatch sw = Stopwatch.createStarted();
                long count = (Long)((Callable)entry.getValue()).call();
                System.out.println("Time taken [" + (String)entry.getKey() + ", " + i + ", " + count + "] " + sw.stop().elapsed(TimeUnit.MILLISECONDS));
            }
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public static <T> T forceNew(Class<T> clazz) {
        try {
            Constructor<T> ctor;
            try {
                ctor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
            }
            T result = ctor.newInstance(new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Triple> parseReader(File file) throws FileNotFoundException, InterruptedException, ExecutionException {
        Stream<Triple> result = SansaBenchRdfIo.parseReader(new FileInputStream(file));
        return result;
    }

    public static Stream<Triple> parseReader(InputStream in) {
        PipedRDFIterator pipedRdfIterator = new PipedRDFIterator();
        PipedTriplesStream pipedRdfStream = new PipedTriplesStream(pipedRdfIterator);
        GraphMem g = new GraphMem((PipedRDFStream)pipedRdfStream){
            final /* synthetic */ PipedRDFStream val$pipedRdfStream;
            {
                this.val$pipedRdfStream = pipedRDFStream;
            }

            public void add(Triple t) {
                this.val$pipedRdfStream.triple(t);
            }
        };
        Model m = ModelFactory.createModelForGraph((Graph)g);
        NTripleReader reader = SansaBenchRdfIo.forceNew(NTripleReader.class);
        RDFErrorHandler handler = new RDFErrorHandler(){

            public void warning(Exception e) {
                System.err.println("warn: " + e);
            }

            public void error(Exception e) {
                System.err.println("error: " + e);
            }

            public void fatalError(Exception e) {
                System.err.println("fatal: " + e);
            }
        };
        reader.setErrorHandler(handler);
        Future<?> foo = executor.submit(() -> SansaBenchRdfIo.lambda$parseReader$1((PipedRDFStream)pipedRdfStream, reader, m, in));
        Stream result = Streams.stream((Iterator)pipedRdfIterator);
        return result;
    }

    public static Stream<Triple> parseFile(File file) throws FileNotFoundException {
        Stream result = Streams.stream((Iterator)RDFDataMgr.createIteratorTriples((InputStream)new FileInputStream(file), (Lang)Lang.NTRIPLES, (String)"http://example.org"));
        return result;
    }

    public static Stream<Triple> parseLineMap(File file) throws IOException {
        return Files.lines(file.toPath()).map(line -> (Triple)RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream(line.getBytes()), (Lang)Lang.NTRIPLES, (String)"http://example.org").next());
    }

    public static Stream<Triple> parseLineFlatMap(File file) throws IOException {
        return Files.lines(file.toPath()).flatMap(line -> Streams.stream((Iterator)RDFDataMgr.createIteratorTriples((InputStream)new ByteArrayInputStream(line.getBytes()), (Lang)Lang.NTRIPLES, (String)"http://example.org")));
    }

    public static Stream<Triple> parseLineReaderFlatMap(File file) throws IOException {
        return Files.lines(file.toPath()).flatMap(line -> SansaBenchRdfIo.parseReader(new ByteArrayInputStream(line.getBytes())));
    }

    public static Stream<Triple> parseLineRiot(File file) throws IOException {
        return Files.lines(file.toPath()).map(line -> (Triple)RiotParsers.createIteratorNTriples((InputStream)new ByteArrayInputStream(line.getBytes()), null, (ParserProfile)parserProfile).next());
    }

    public static Stream<Triple> parseLineRiot2(File file) throws IOException {
        return Files.lines(file.toPath()).map(line -> (Triple)RiotParsers.createParserNTriples((Tokenizer)TokenizerFactory.makeTokenizerASCII((String)line), null, (ParserProfile)parserProfile).next());
    }

    private static /* synthetic */ void lambda$parseReader$1(PipedRDFStream pipedRdfStream, NTripleReader reader, Model m, InputStream in) {
        pipedRdfStream.start();
        try {
            reader.read(m, in, "http://example.org");
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        pipedRdfStream.finish();
    }
}

