/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.benchmark.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.ext.com.google.common.collect.Streams;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class ReadableByteChannelFromIterator
implements ReadableByteChannel {
    protected Iterator<ByteBuffer> it;
    protected boolean isOpen;
    protected ByteBuffer currentBuffer;
    private static char NL = (char)10;

    public static void main(String[] args) {
        List<String> strs = Arrays.asList("@prefix eg: <http://example.org/> .\n", "eg:a eg:b eg:c .\n", "eg:d eg:e eg:f .\n", "eg:g eg:h eg:i .\n");
        InputStream in = ReadableByteChannelFromIterator.toInputStream(strs.stream());
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (InputStream)in, (Lang)Lang.TURTLE);
        RDFDataMgr.write((OutputStream)System.err, (Model)m, (RDFFormat)RDFFormat.TURTLE_PRETTY);
    }

    public static InputStream toInputStream(Iterator<String> it) {
        return ReadableByteChannelFromIterator.toInputStream(Streams.stream(it));
    }

    public static InputStream toInputStream(Stream<String> stream) {
        return Channels.newInputStream(new ReadableByteChannelFromIterator(stream.map(s -> (s + '\n').getBytes()).map(ByteBuffer::wrap).iterator()));
    }

    public ReadableByteChannelFromIterator(Iterator<ByteBuffer> it) {
        this.it = it;
        this.isOpen = true;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    @Override
    public int read(ByteBuffer dst) {
        int result = 0;
        int remaining = dst.remaining();
        while (remaining > 0) {
            int available;
            int n = available = this.currentBuffer == null ? 0 : this.currentBuffer.remaining();
            if (available == 0) {
                if (!this.it.hasNext()) {
                    if (result != 0) break;
                    result = -1;
                    break;
                }
                this.currentBuffer = this.it.next();
                continue;
            }
            int toRead = Math.min(remaining, available);
            int off = this.currentBuffer.position();
            int newOff = off + toRead;
            ByteBuffer tmp = this.currentBuffer.duplicate();
            tmp.limit(newOff);
            dst.put(tmp);
            this.currentBuffer.position(newOff);
            result += toRead;
            remaining -= toRead;
        }
        return result;
    }
}

