/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.owl.spark.hadoop;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.LineReader;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u00015\u0011ADR;oGRLwN\\1m'ftG/\u0019=SK\u000e|'\u000f\u001a*fC\u0012,'O\u0003\u0002\u0004\t\u00051\u0001.\u00193p_BT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011aA8xY*\u0011\u0011BC\u0001\fg\u0006t7/Y0ti\u0006\u001c7NC\u0001\f\u0003\rqW\r^\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB!qcH\u0011(\u001b\u0005A\"BA\r\u001b\u0003\u0019i\u0017\r\u001d:fI*\u00111a\u0007\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014x-\u0003\u0002!1\ta!+Z2pe\u0012\u0014V-\u00193feB\u0011!%J\u0007\u0002G)\u0011AEG\u0001\u0003S>L!AJ\u0012\u0003\u00191{gnZ,sSR\f'\r\\3\u0011\u0005\tB\u0013BA\u0015$\u0005\u0011!V\r\u001f;\t\u0011-\u0002!\u0011!Q\u0001\n1\n1A[8c!\ti\u0003'D\u0001/\u0015\ty#$\u0001\u0003d_:4\u0017BA\u0019/\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"A1\u0007\u0001B\u0001B\u0003%A'A\u0003ta2LG\u000f\u0005\u0002\u0018k%\u0011a\u0007\u0007\u0002\n\r&dWm\u00159mSRDQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtDc\u0001\u001e={A\u00111\bA\u0007\u0002\u0005!)1f\u000ea\u0001Y!)1g\u000ea\u0001i!9q\b\u0001b\u0001\n\u0013\u0001\u0015\u0001\u00024jY\u0016,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tj\t!AZ:\n\u0005\u0019\u001b%\u0001\u0002)bi\"Da\u0001\u0013\u0001!\u0002\u0013\t\u0015!\u00024jY\u0016\u0004\u0003b\u0002#\u0001\u0005\u0004%IAS\u000b\u0002\u0017B\u0011!\tT\u0005\u0003\u001b\u000e\u0013!BR5mKNK8\u000f^3n\u0011\u0019y\u0005\u0001)A\u0005\u0017\u0006\u0019am\u001d\u0011\t\u000fE\u0003!\u0019!C\u0005%\u00061a-\u001b7f\u0013:,\u0012a\u0015\t\u0003\u0005RK!!V\"\u0003#\u0019\u001bF)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004X\u0001\u0001\u0006IaU\u0001\bM&dW-\u00138!\u0011\u001dI\u0006\u00011A\u0005\ni\u000b1\u0001]8t+\u0005Y\u0006C\u0001/`\u001b\u0005i&\"\u00010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001l&\u0001\u0002'p]\u001eDqA\u0019\u0001A\u0002\u0013%1-A\u0004q_N|F%Z9\u0015\u0005\u0011<\u0007C\u0001/f\u0013\t1WL\u0001\u0003V]&$\bb\u00025b\u0003\u0003\u0005\raW\u0001\u0004q\u0012\n\u0004B\u00026\u0001A\u0003&1,\u0001\u0003q_N\u0004\u0003b\u00027\u0001\u0005\u0004%IAW\u0001\u0006gR\f'\u000f\u001e\u0005\u0007]\u0002\u0001\u000b\u0011B.\u0002\rM$\u0018M\u001d;!\u0011\u001d\u0001\bA1A\u0005\ni\u000b1!\u001a8e\u0011\u0019\u0011\b\u0001)A\u00057\u0006!QM\u001c3!\u0011\u001d!\b\u00011A\u0005\nU\fQbY;se\u0016tGOU3d_J$W#\u0001<\u0011\u0005]ThB\u0001/y\u0013\tIX,\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014aa\u0015;sS:<'BA=^\u0011\u001dq\b\u00011A\u0005\n}\f\u0011cY;se\u0016tGOU3d_J$w\fJ3r)\r!\u0017\u0011\u0001\u0005\bQv\f\t\u00111\u0001w\u0011\u001d\t)\u0001\u0001Q!\nY\fabY;se\u0016tGOU3d_J$\u0007\u0005C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f\u0005QA.\u001b8f%\u0016\fG-\u001a:\u0016\u0005\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M!$\u0001\u0003vi&d\u0017\u0002BA\f\u0003#\u0011!\u0002T5oKJ+\u0017\rZ3s\u0011!\tY\u0002\u0001Q\u0001\n\u00055\u0011a\u00037j]\u0016\u0014V-\u00193fe\u0002B\u0011\"a\b\u0001\u0001\u0004%I!!\t\u0002\u0013\u0019L'o\u001d;MS:,WCAA\u0012!\ra\u0016QE\u0005\u0004\u0003Oi&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003W\u0001\u0001\u0019!C\u0005\u0003[\tQBZ5sgRd\u0015N\\3`I\u0015\fHc\u00013\u00020!I\u0001.!\u000b\u0002\u0002\u0003\u0007\u00111\u0005\u0005\t\u0003g\u0001\u0001\u0015)\u0003\u0002$\u0005Qa-\u001b:ti2Kg.\u001a\u0011\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0012aD:fGRLwN\\&fs^|'\u000fZ:\u0016\u0005\u0005m\u0002\u0003\u0002/\u0002>YL1!a\u0010^\u0005\u0015\t%O]1z\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005m\u0012\u0001E:fGRLwN\\&fs^|'\u000fZ:!\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\nAA\\3yiR1\u00111EA&\u0003\u001fBq!!\u0014\u0002F\u0001\u0007\u0011%A\u0002lKfDq!!\u0015\u0002F\u0001\u0007q%A\u0003wC2,X\rC\u0004\u0002V\u0001!\t%a\u0016\u0002\u0017\u001d,G\u000f\u0015:pOJ,7o\u001d\u000b\u0003\u00033\u00022\u0001XA.\u0013\r\ti&\u0018\u0002\u0006\r2|\u0017\r\u001e\u0005\b\u0003C\u0002A\u0011IA2\u0003\u00199W\r\u001e)pgR\t1\fC\u0004\u0002h\u0001!\t%!\u001b\u0002\u0013\r\u0014X-\u0019;f\u0017\u0016LH#A\u0011\t\u000f\u00055\u0004\u0001\"\u0011\u0002p\u0005Y1M]3bi\u00164\u0016\r\\;f)\u00059\u0003bBA:\u0001\u0011\u0005\u0013QO\u0001\u0006G2|7/\u001a\u000b\u0002I\"1\u0011\u0011\u0010\u0001\u0005\nU\faB]3bI:+\u0007\u0010\u001e*fG>\u0014H\rC\u0004\u0002~\u0001!I!a \u0002#E,x\u000e^3t\u0003J,')\u00197b]\u000e,G\r\u0006\u0003\u0002$\u0005\u0005\u0005bBAB\u0003w\u0002\rA^\u0001\u0005Y&tW\r")
public class FunctionalSyntaxRecordReader
implements RecordReader<LongWritable, Text> {
    private final Path file;
    private final FileSystem fs;
    private final FSDataInputStream fileIn;
    private long pos;
    private final long start;
    private final long end;
    private String currentRecord;
    private final LineReader lineReader;
    private boolean firstLine;
    private final String[] sectionKeywords;

    private Path file() {
        return this.file;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private FSDataInputStream fileIn() {
        return this.fileIn;
    }

    private long pos() {
        return this.pos;
    }

    private void pos_$eq(long x$1) {
        this.pos = x$1;
    }

    private long start() {
        return this.start;
    }

    private long end() {
        return this.end;
    }

    private String currentRecord() {
        return this.currentRecord;
    }

    private void currentRecord_$eq(String x$1) {
        this.currentRecord = x$1;
    }

    private LineReader lineReader() {
        return this.lineReader;
    }

    private boolean firstLine() {
        return this.firstLine;
    }

    private void firstLine_$eq(boolean x$1) {
        this.firstLine = x$1;
    }

    private String[] sectionKeywords() {
        return this.sectionKeywords;
    }

    public boolean next(LongWritable key, Text value) {
        this.currentRecord_$eq(this.readNextRecord());
        key.set(this.pos());
        if (this.currentRecord() == null) {
            value.set("");
        } else {
            value.set(this.currentRecord());
        }
        return this.currentRecord() != null;
    }

    public float getProgress() {
        return this.start() == this.end() ? 0.0f : Math.min(1.0f, (float)((double)(this.pos() - this.start()) / (double)(this.end() - this.start())));
    }

    public long getPos() {
        return this.pos();
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public void close() {
        this.fileIn().close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readNextRecord() {
        Text record = new Text();
        if (this.firstLine()) {
            int bytesRead = this.lineReader().readLine(record);
            this.firstLine_$eq(false);
            this.pos_$eq(this.pos() + (long)bytesRead);
            boolean skip = true;
            for (int cntr = 0; skip && cntr < this.sectionKeywords().length; ++cntr) {
                if (!record.toString().trim().startsWith(this.sectionKeywords()[cntr])) continue;
                skip = false;
            }
            if (!skip) return record.toString();
            record.clear();
        }
        if (this.pos() >= this.end()) {
            return null;
        }
        int bytesRead = this.lineReader().readLine(record);
        this.pos_$eq(this.pos() + (long)bytesRead);
        String line = record.toString();
        while (true) {
            String string;
            if (this.quotesAreBalanced(line)) {
                String string2 = line;
                return string2;
            }
            record.clear();
            int n = this.lineReader().readLine(record);
            this.pos_$eq(this.pos() + (long)n);
            string = new StringBuilder().append((Object)string).append((Object)"\n").toString();
            string = new StringBuilder().append((Object)string).append((Object)record.toString()).toString();
        }
    }

    private boolean quotesAreBalanced(String line) {
        return new StringOps(Predef$.MODULE$.augmentString(line)).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 == '\"';
            }
        }) % 2 == 0;
    }

    public FunctionalSyntaxRecordReader(Configuration job, FileSplit split) {
        this.file = split.getPath();
        this.fs = this.file().getFileSystem(job);
        this.fileIn = this.fs().open(this.file());
        this.pos = split.getStart();
        this.fileIn().seek(this.pos());
        this.start = split.getStart();
        this.end = this.start() + split.getLength();
        this.currentRecord = null;
        this.lineReader = new LineReader((InputStream)this.fileIn());
        this.firstLine = true;
        this.sectionKeywords = (String[])((Object[])new String[]{"#", "Ontology", "Import", "SubClassOf", "EquivalentClasses", "DisjointClasses", "DisjointUnion", "Annotation", "AnnotationAssertion", "SubAnnotationPropertyOf", "AnnotationPropertyDomain", "AnnotationPropertyRange", "HasKey", "Declaration", "InverseObjectProperties", "SubObjectPropertyOf", "EquivalentObjectProperties", "DisjointObjectProperties", "ObjectPropertyDomain", "ObjectPropertyRange", "FunctionalObjectProperty", "InverseFunctionalObjectProperty", "ReflexiveObjectProperty", "IrreflexiveObjectProperty", "SymmetricObjectProperty", "AsymmetricObjectProperty", "TransitiveObjectProperty", "SubDataPropertyOf", "EquivalentDataProperties", "DisjointDataProperties", "DataPropertyDomain", "DataPropertyRange", "FunctionalDataProperty", "SameIndividual", "DifferentIndividuals", "ClassAssertion", "ObjectPropertyAssertion", "NegativeObjectPropertyAssertion", "DataPropertyAssertion", "NegativeDataPropertyAssertion", "Prefix"});
    }
}

