/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.utils;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0002\u0004\u0001#!)\u0001\u0004\u0001C\u00013!9\u0011\u0002\u0001b\u0001\n\u0003a\u0002B\u0002\u0015\u0001A\u0003%Q\u0004C\u0003*\u0001\u0011\u0005!F\u0001\u0013TS6LG.\u0019:jif,\u0005\u0010]3sS6,g\u000e^'fi\u0006<%/\u00199i\r\u0006\u001cGo\u001c:z\u0015\t9\u0001\"A\u0003vi&d7O\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0003[2T!!\u0004\b\u0002\u0017M\fgn]1`gR\f7m\u001b\u0006\u0002\u001f\u0005\u0019a.\u001a;\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u00051Q#A\u000f\u0011\u0005y1S\"A\u0010\u000b\u0005\u0001\n\u0013aA:rY*\u0011\u0011B\t\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(?\ta1\u000b]1sWN+7o]5p]\u000611\u000f]1sW\u0002\nqb\u0019:fCR,'\u000b\u001a4PkR\u0004X\u000f\u001e\u000b\u0003WM#B\u0001L'P#R\u0019Qf\u000f!\u0011\u00079\n4'D\u00010\u0015\t\u0001\u0014%A\u0002sI\u0012L!AM\u0018\u0003\u0007I#E\t\u0005\u00025s5\tQG\u0003\u00027o\u0005)qM]1qQ*\u0011\u0001HI\u0001\u0005U\u0016t\u0017-\u0003\u0002;k\t1AK]5qY\u0016DQ\u0001\u0010\u0003A\u0002u\nA$\u001b8qkR$\u0015\r^1tKRtU/\u001c2feR|e\r\u0016:ja2,7\u000f\u0005\u0002\u0014}%\u0011q\b\u0006\u0002\u0005\u0019>tw\rC\u0003B\t\u0001\u0007!)\u0001\u000eeCR\f7+\u001a;J]\u001a|'/\\1uS>tg)\u001b7f!\u0006$\b\u000e\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000bRi\u0011A\u0012\u0006\u0003\u000fB\ta\u0001\u0010:p_Rt\u0014BA%\u0015\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%#\u0002\"\u0002(\u0005\u0001\u0004\u0011\u0015!H7pI\u0016d\u0017J\u001c4pe6\fG/[8o\u000bN$\u0018.\\1u_Jt\u0015-\\3\t\u000bA#\u0001\u0019\u0001\"\u0002;5|G-\u001a7J]\u001a|'/\\1uS>tWi\u001d;j[\u0006$xN\u001d+za\u0016DQA\u0015\u0003A\u0002\t\u000bq$\\8eK2LeNZ8s[\u0006$\u0018n\u001c8NK\u0006\u001cXO]3nK:$H+\u001f9f\u0011\u0015!F\u00011\u0001V\u00035yW\u000f\u001e9vi\u0012\u000bG/Y:fiB\u0012ak\u0017\t\u0004=]K\u0016B\u0001- \u0005\u001d!\u0015\r^1tKR\u0004\"AW.\r\u0001\u0011IAlUA\u0001\u0002\u0003\u0015\t!\u0018\u0002\u0004?\u0012\n\u0014C\u00010b!\t\u0019r,\u0003\u0002a)\t9aj\u001c;iS:<\u0007CA\nc\u0013\t\u0019GCA\u0002B]f\u0004")
public class SimilarityExperimentMetaGraphFactory {
    private final SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();

    public SparkSession spark() {
        return this.spark;
    }

    public RDD<Triple> createRdfOutput(Dataset<?> outputDataset, String modelInformationEstimatorName, String modelInformationEstimatorType, String modelInformationMeasurementType, long inputDatasetNumbertOfTriples, String dataSetInformationFilePath) {
        Date metagraphDatetime = Calendar.getInstance().getTime();
        String experimentID = new StringBuilder(0).append(metagraphDatetime.toString().replaceAll("\\s", "").replaceAll(":", "")).append(modelInformationEstimatorName).toString();
        Node dateTimeLiteral = NodeFactory.createLiteralByValue((Object)metagraphDatetime.toString(), (RDFDatatype)XSDDatatype.XSDdateTime);
        Node numberInputTriplesLiteral = NodeFactory.createLiteralByValue((Object)Long.toString(inputDatasetNumbertOfTriples), (RDFDatatype)XSDDatatype.XSDlong);
        Node numberInputFilePathLiteral = NodeFactory.createLiteral((String)dataSetInformationFilePath);
        Node estimatorNameLiteral = NodeFactory.createLiteral((String)modelInformationEstimatorName);
        Node estimatorTypeLiteral = NodeFactory.createLiteral((String)modelInformationEstimatorType);
        Node measurementTypeLiteral = NodeFactory.createLiteral((String)modelInformationMeasurementType);
        Node propertyCreatedDateTime = NodeFactory.createURI((String)"sansa-stack/sansaVocab/experimentDateTime");
        Node propertyEstimatorName = NodeFactory.createURI((String)"sansa-stack/sansaVocab/estimatorName");
        Node propertyEstimatorType = NodeFactory.createURI((String)"sansa-stack/sansaVocab/estimatorType");
        Node propertyMeasurementType = NodeFactory.createURI((String)"sansa-stack/sansaVocab/measurementType");
        Node propertyEvaluated = NodeFactory.createURI((String)"sansa-stack/sansaVocab/evaluated");
        Node propertyValue = NodeFactory.createURI((String)"sansa-stack/sansaVocab/evaluated");
        Node propertyElement = NodeFactory.createURI((String)"sansa-stack/sansaVocab/element");
        Node experimentIdNode = NodeFactory.createBlankNode((String)experimentID);
        .colon.colon centralNodeTriples = new .colon.colon((Object)Triple.create((Node)experimentIdNode, (Node)propertyCreatedDateTime, (Node)dateTimeLiteral), (List)new .colon.colon((Object)Triple.create((Node)experimentIdNode, (Node)propertyEstimatorName, (Node)estimatorNameLiteral), (List)new .colon.colon((Object)Triple.create((Node)experimentIdNode, (Node)propertyEstimatorType, (Node)estimatorTypeLiteral), (List)new .colon.colon((Object)Triple.create((Node)experimentIdNode, (Node)propertyMeasurementType, (Node)measurementTypeLiteral), (List)Nil$.MODULE$))));
        SparkContext qual$1 = this.spark().sqlContext().sparkContext();
        .colon.colon x$1 = centralNodeTriples;
        int x$2 = qual$1.parallelize$default$2();
        RDD centralNodeRdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Triple.class));
        RDD metagraph = outputDataset.rdd().flatMap((Function1 & Serializable & scala.Serializable)row -> {
            String a = ((Row)row).apply(0).toString();
            String b = ((Row)row).apply(1).toString();
            double value = new StringOps(Predef$.MODULE$.augmentString(((Row)row).apply(2).toString())).toDouble();
            String simEstimationNode = new StringBuilder(0).append(experimentID).append(a).append(b).toString();
            Node nodeSimEst = NodeFactory.createURI((String)simEstimationNode);
            Node nodeA = NodeFactory.createURI((String)a);
            Node nodeB = NodeFactory.createURI((String)b);
            Node literalValue = NodeFactory.createLiteralByValue((Object)Double.toString(value), (RDFDatatype)XSDDatatype.XSDdouble);
            return new .colon.colon((Object)Triple.create((Node)experimentIdNode, (Node)propertyEvaluated, (Node)nodeSimEst), (List)new .colon.colon((Object)Triple.create((Node)nodeSimEst, (Node)propertyElement, (Node)nodeA), (List)new .colon.colon((Object)Triple.create((Node)nodeSimEst, (Node)propertyElement, (Node)nodeB), (List)new .colon.colon((Object)Triple.create((Node)nodeSimEst, (Node)propertyValue, (Node)literalValue), (List)Nil$.MODULE$))));
        }, ClassTag$.MODULE$.apply(Triple.class)).union(centralNodeRdd);
        return metagraph;
    }
}

