/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.anomalydetection;

import java.io.Serializable;
import net.sansa_stack.ml.spark.anomalydetection.DistADConfig;
import net.sansa_stack.ml.spark.anomalydetection.DistADLogger$;
import net.sansa_stack.ml.spark.anomalydetection.DistADUtil$;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001'!A1\u0002\u0001B\u0001B\u0003%!\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!!\u0004A!A!\u0002\u0013)\u0004\"B\u001d\u0001\t\u0003Q\u0004\"B \u0001\t\u0003\u0001\u0005\"B*\u0001\t\u0003!&!\u0007)sK\u0012L7-\u0019;f\u0003:|W.\u00197z\t\u0016$Xm\u0019;j_:T!!\u0003\u0006\u0002!\u0005tw.\\1ms\u0012,G/Z2uS>t'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0002nY*\u0011q\u0002E\u0001\fg\u0006t7/Y0ti\u0006\u001c7NC\u0001\u0012\u0003\rqW\r^\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037\rj\u0011\u0001\b\u0006\u0003;y\t1a]9m\u0015\tYqD\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<\u0017B\u0001\u0013\u001d\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003=y'/[4j]\u0006dG)\u0019;b%\u0012#\u0005cA\u0014+Y5\t\u0001F\u0003\u0002*=\u0005\u0019!\u000f\u001a3\n\u0005-B#a\u0001*E\tB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003c}\tAA[3oC&\u00111G\f\u0002\u0007)JL\u0007\u000f\\3\u0002\r\r|gNZ5h!\t1t'D\u0001\t\u0013\tA\u0004B\u0001\u0007ESN$\u0018\tR\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0005wqjd\b\u0005\u00027\u0001!)1\u0002\u0002a\u00015!)Q\u0005\u0002a\u0001M!)A\u0007\u0002a\u0001k\u0005\u0019!/\u001e8\u0015\u0003\u0005\u0003\"A\u0011)\u000f\u0005\rseB\u0001#N\u001d\t)EJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011JE\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005-y\u0012BA\u000f\u001f\u0013\tyE$A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&!\u0003#bi\u00064%/Y7f\u0015\tyE$\u0001\nbI\u0012\u001cE.^:uKJLE\rV8ECR\fGcA!V/\")aK\u0002a\u0001\u0003\u0006!A-\u0019;b\u0011\u0015Af\u00011\u0001B\u0003-\u0001(/\u001a3jGRLwN\\:")
public class PredicateAnomalyDetection {
    private final RDD<Triple> originalDataRDD;
    private final DistADConfig config;

    public Dataset<Row> run() {
        Dataset<Row> dataset;
        Dataset<Row> dataset2;
        long startTime;
        block21: {
            String string;
            RDD originalDataRDDCounted;
            block17: {
                Dataset originalDataDataFrameCounted;
                block19: {
                    String string2;
                    block20: {
                        String string3;
                        String string4;
                        block18: {
                            startTime = System.currentTimeMillis();
                            Dataset originalDataDataFrame = DistADUtil$.MODULE$.createDF(this.originalDataRDD).cache();
                            if (this.config.verbose()) {
                                DistADLogger$.MODULE$.LOG().info((Object)"Original Data DataFrame:");
                                originalDataDataFrame.show(false);
                            }
                            Nil$ predefinedP = Nil$.MODULE$;
                            originalDataDataFrameCounted = null;
                            originalDataDataFrameCounted = predefinedP.isEmpty() ? originalDataDataFrame.groupBy("s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).agg(functions$.MODULE$.count("p").as("o"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])) : originalDataDataFrame.filter(arg_0 -> PredicateAnomalyDetection.$anonfun$run$1$adapted((List)predefinedP, arg_0)).groupBy("s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).agg(functions$.MODULE$.count("p").as("o"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
                            if (this.config.verbose()) {
                                DistADLogger$.MODULE$.LOG().info((Object)"Result of counting dataframe:");
                                originalDataDataFrameCounted.show(false);
                            }
                            Encoder tripleTupleEncoder = Encoders$.MODULE$.kryo(Triple.class);
                            originalDataRDDCounted = originalDataDataFrameCounted.map((Function1 & Serializable & scala.Serializable)row -> {
                                Node s = NodeFactory.createURI((String)row.get(0).toString());
                                Node p = NodeFactory.createURI((String)row.get(1).toString());
                                Node o = NodeFactory.createLiteral((String)new StringBuilder(44).append(row.get(2).toString()).append("^^<http://www.w3.org/2001/XMLSchema#integer>").toString());
                                return Triple.create((Node)s, (Node)p, (Node)o);
                            }, tripleTupleEncoder).rdd();
                            string = this.config.clusteringMethod();
                            String string5 = this.config.BISECTINGKMEANS();
                            String string6 = string;
                            if (string5 != null ? !string5.equals(string6) : string6 != null) break block17;
                            if (this.config.silhouetteMethod()) {
                                this.config.numberOfClusters_$eq(DistADUtil$.MODULE$.detectNumberOfClusters((Dataset<Row>)originalDataDataFrameCounted, this.config.silhouetteMethodSamplingRate()));
                                DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(45).append("Number of optimal cluster for the dataset is ").append(this.config.numberOfClusters()).toString());
                            }
                            string2 = this.config.clusteringType();
                            String string7 = this.config.PARTIAL();
                            String string8 = string2;
                            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                                throw new Exception("Partial mode is not available for predicates");
                            }
                            string4 = this.config.FULL();
                            string3 = string2;
                            if (string4 != null) break block18;
                            if (string3 == null) break block19;
                            break block20;
                        }
                        if (string4.equals(string3)) break block19;
                    }
                    throw new MatchError((Object)string2);
                }
                Dataset<Row> predictions = DistADUtil$.MODULE$.calculateBiSectingKmeanClustering((RDD<Triple>)originalDataRDDCounted, this.config.numberOfClusters());
                if (this.config.verbose()) {
                    DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(36).append("Result of clustering with ").append(this.config.numberOfClusters()).append(" clusters:").toString());
                    predictions.show(false);
                }
                dataset2 = this.addClusterIdToData((Dataset<Row>)originalDataDataFrameCounted, predictions);
                break block21;
            }
            String string9 = this.config.MINHASHLSH();
            String string10 = string;
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                dataset2 = DistADUtil$.MODULE$.calculateMinHashLSHClustering((RDD<Triple>)originalDataRDDCounted, (RDD<Triple>)originalDataRDDCounted, this.config);
            } else {
                throw new MatchError((Object)string);
            }
        }
        Dataset<Row> originalDataDataFrameCountedWithClusterId = dataset2;
        if (this.config.verbose()) {
            DistADLogger$.MODULE$.LOG().info((Object)"Add clustering result to data:");
            originalDataDataFrameCountedWithClusterId.show(false);
        }
        String string = this.config.anomalyDetectionAlgorithm();
        String string11 = this.config.IQR();
        String string12 = string;
        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
            dataset = DistADUtil$.MODULE$.iqr(originalDataDataFrameCountedWithClusterId, this.config.verbose(), this.config.anomalyListSize());
        } else {
            String string13 = this.config.ZSCORE();
            String string14 = string;
            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                dataset = DistADUtil$.MODULE$.zscore(originalDataDataFrameCountedWithClusterId, this.config.verbose(), this.config.anomalyListSize());
            } else {
                String string15 = this.config.MAD();
                String string16 = string;
                if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                    dataset = DistADUtil$.MODULE$.mad(originalDataDataFrameCountedWithClusterId, this.config.verbose(), this.config.anomalyListSize());
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        Dataset<Row> finalResult = dataset;
        DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(16).append("Operation took: ").append(System.currentTimeMillis() - startTime).toString());
        return finalResult;
    }

    public Dataset<Row> addClusterIdToData(Dataset<Row> data, Dataset<Row> predictions) {
        ObjectRef dataJoined = ObjectRef.create((Object)data.join(predictions, "s").cache());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions.columns())).foreach((Function1 & Serializable & scala.Serializable)col -> {
            PredicateAnomalyDetection.$anonfun$addClusterIdToData$1(dataJoined, col);
            return BoxedUnit.UNIT;
        });
        return (Dataset)dataJoined.elem;
    }

    public static final /* synthetic */ boolean $anonfun$run$1(List predefinedP$1, Row p) {
        if (predefinedP$1.nonEmpty()) {
            return predefinedP$1.contains(p.getAs(1));
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$addClusterIdToData$1(ObjectRef dataJoined$1, String col) {
        if (!col.equals("s") && !col.equals("prediction")) {
            dataJoined$1.elem = ((Dataset)dataJoined$1.elem).drop(col);
            return;
        }
    }

    public PredicateAnomalyDetection(SparkSession spark, RDD<Triple> originalDataRDD, DistADConfig config) {
        this.originalDataRDD = originalDataRDD;
        this.config = config;
    }

    public static final /* synthetic */ Object $anonfun$run$1$adapted(List predefinedP$1, Row p) {
        return BoxesRunTime.boxToBoolean((boolean)PredicateAnomalyDetection.$anonfun$run$1(predefinedP$1, p));
    }
}

