/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.similarity.examples;

import java.io.Serializable;
import net.sansa_stack.ml.spark.similarity.examples.MinimalCalls$;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.BatetModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.BraunBlanquetModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.DiceModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.JaccardModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.MinHashModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.OchiaiModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.SimpsonModel;
import net.sansa_stack.ml.spark.similarity.similarityEstimationModels.TverskyModel;
import net.sansa_stack.ml.spark.utils.FeatureExtractorModel;
import net.sansa_stack.ml.spark.utils.SimilarityExperimentMetaGraphFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.sys.JenaSystem;
import org.apache.spark.ml.feature.CountVectorizer;
import org.apache.spark.ml.feature.CountVectorizerModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MinimalCalls$ {
    public static MinimalCalls$ MODULE$;

    static {
        new MinimalCalls$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MinMal Semantic Similarity Estimation Calls").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        spark.sparkContext().setLogLevel("ERROR");
        JenaSystem.init();
        String inputPath = "./sansa-ml/sansa-ml-spark/src/main/resources/movieData/movie.nt";
        Dataset triplesDf = ((Dataset)net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFDataFrameReader(spark.read()).rdf(Lang.NTRIPLES).apply((Object)inputPath)).cache();
        triplesDf.show(false);
        FeatureExtractorModel featureExtractorModel = new FeatureExtractorModel().setMode("an");
        Dataset extractedFeaturesDataFrame = featureExtractorModel.transform(triplesDf).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)MinimalCalls$.$anonfun$main$1(t))).cache();
        extractedFeaturesDataFrame.show(false);
        Dataset filteredFeaturesDataFrame = extractedFeaturesDataFrame.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)MinimalCalls$.$anonfun$main$2(t))).cache();
        filteredFeaturesDataFrame.show(false);
        CountVectorizerModel cvModel = new CountVectorizer().setInputCol("extractedFeatures").setOutputCol("vectorizedFeatures").fit(filteredFeaturesDataFrame);
        Dataset tmpCvDf = cvModel.transform(filteredFeaturesDataFrame);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_ml_spark_similarity_examples_MinimalCalls$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Net_sansa_stack_ml_spark_similarity_examples_MinimalCalls$$typecreator1$1() {
            }
        }
        UserDefinedFunction isNoneZeroVector = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)MinimalCalls$.$anonfun$main$3(v)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Net_sansa_stack_ml_spark_similarity_examples_MinimalCalls$$typecreator1$1()));
        Dataset countVectorizedFeaturesDataFrame = tmpCvDf.filter(isNoneZeroVector.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("vectorizedFeatures")}))).select("uri", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vectorizedFeatures"})).cache();
        countVectorizedFeaturesDataFrame.show(false);
        String sampleUri = "m2";
        Vector sample_key = (Vector)((Row[])countVectorizedFeaturesDataFrame.filter(countVectorizedFeaturesDataFrame.apply("uri").$eq$eq$eq((Object)sampleUri)).take(1))[0].getAs("vectorizedFeatures");
        MinHashModel minHashModel = (MinHashModel)new MinHashModel().setInputCol("vectorizedFeatures");
        minHashModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, minHashModel.nearestNeighbors$default$5(), minHashModel.nearestNeighbors$default$6()).show();
        minHashModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.8, "distance").show();
        JaccardModel jaccardModel = (JaccardModel)new JaccardModel().setInputCol("vectorizedFeatures");
        jaccardModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, jaccardModel.nearestNeighbors$default$5(), jaccardModel.nearestNeighbors$default$6()).show();
        jaccardModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, jaccardModel.similarityJoin$default$4()).show();
        BatetModel batetModel = (BatetModel)new BatetModel().setInputCol("vectorizedFeatures");
        batetModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, batetModel.nearestNeighbors$default$5(), batetModel.nearestNeighbors$default$6()).show();
        batetModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, batetModel.similarityJoin$default$4()).show();
        BraunBlanquetModel braunBlanquetModel = (BraunBlanquetModel)new BraunBlanquetModel().setInputCol("vectorizedFeatures");
        braunBlanquetModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, braunBlanquetModel.nearestNeighbors$default$5(), braunBlanquetModel.nearestNeighbors$default$6()).show();
        braunBlanquetModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, braunBlanquetModel.similarityJoin$default$4()).show();
        DiceModel diceModel = (DiceModel)new DiceModel().setInputCol("vectorizedFeatures");
        diceModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, diceModel.nearestNeighbors$default$5(), diceModel.nearestNeighbors$default$6()).show();
        diceModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, diceModel.similarityJoin$default$4()).show();
        OchiaiModel ochiaiModel = (OchiaiModel)new OchiaiModel().setInputCol("vectorizedFeatures");
        ochiaiModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, ochiaiModel.nearestNeighbors$default$5(), ochiaiModel.nearestNeighbors$default$6()).show();
        ochiaiModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, ochiaiModel.similarityJoin$default$4()).show();
        SimpsonModel simpsonModel = (SimpsonModel)new SimpsonModel().setInputCol("vectorizedFeatures");
        simpsonModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, simpsonModel.nearestNeighbors$default$5(), simpsonModel.nearestNeighbors$default$6()).show();
        simpsonModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, simpsonModel.similarityJoin$default$4()).show();
        TverskyModel tverskyModel = ((TverskyModel)new TverskyModel().setInputCol("vectorizedFeatures")).setAlpha(1.0).setBeta(1.0);
        tverskyModel.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, tverskyModel.nearestNeighbors$default$5(), tverskyModel.nearestNeighbors$default$6()).show();
        tverskyModel.similarityJoin((Dataset<Row>)countVectorizedFeaturesDataFrame, (Dataset<Row>)countVectorizedFeaturesDataFrame, 0.5, tverskyModel.similarityJoin$default$4()).show();
        MinHashModel model = (MinHashModel)new MinHashModel().setInputCol("vectorizedFeatures");
        Dataset<Row> outputDf1 = model.nearestNeighbors((Dataset<Row>)countVectorizedFeaturesDataFrame, sample_key, 10, sampleUri, model.nearestNeighbors$default$5(), model.nearestNeighbors$default$6());
        SimilarityExperimentMetaGraphFactory metaGraphFactory = new SimilarityExperimentMetaGraphFactory();
        RDD<Triple> metagraph = metaGraphFactory.createRdfOutput(outputDf1, model.estimatorName(), model.modelType(), model.estimatorMeasureType(), triplesDf.count(), inputPath);
        metagraph.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Predef$.MODULE$.println((Object)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$main$1(Row t) {
        return ((String)t.getAs("uri")).startsWith("m");
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Row t) {
        return ((String)t.getAs("uri")).startsWith("m");
    }

    public static final /* synthetic */ boolean $anonfun$main$3(Vector v) {
        return v.numNonzeros() > 0;
    }

    private MinimalCalls$() {
        MODULE$ = this;
    }
}

