/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.anomalydetection;

import net.sansa_stack.ml.spark.anomalydetection.DistADConfig;
import net.sansa_stack.ml.spark.anomalydetection.DistADLogger$;
import net.sansa_stack.ml.spark.anomalydetection.DistADUtil$;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001'!A1\u0002\u0001B\u0001B\u0003%!\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!!\u0004A!A!\u0002\u0013)\u0004\"B\u001d\u0001\t\u0003Q\u0004\"B \u0001\t\u0003\u0001\u0005\"B*\u0001\t\u0003!&A\b(v[\u0016\u0014\u0018n\u0019'ji\u0016\u0014\u0018\r\\!o_6\fG.\u001f#fi\u0016\u001cG/[8o\u0015\tI!\"\u0001\tb]>l\u0017\r\\=eKR,7\r^5p]*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\t!!\u001c7\u000b\u0005=\u0001\u0012aC:b]N\fwl\u001d;bG.T\u0011!E\u0001\u0004]\u0016$8\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e$\u001b\u0005a\"BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0017}Q!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO&\u0011A\u0005\b\u0002\r'B\f'o[*fgNLwN\\\u0001\u0010_JLw-\u001b8bY\u0012\u000bG/\u0019*E\tB\u0019qE\u000b\u0017\u000e\u0003!R!!\u000b\u0010\u0002\u0007I$G-\u0003\u0002,Q\t\u0019!\u000b\u0012#\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B4sCBD'BA\u0019 \u0003\u0011QWM\\1\n\u0005Mr#A\u0002+sSBdW-\u0001\u0004d_:4\u0017n\u001a\t\u0003m]j\u0011\u0001C\u0005\u0003q!\u0011A\u0002R5ti\u0006#5i\u001c8gS\u001e\fa\u0001P5oSRtD\u0003B\u001e={y\u0002\"A\u000e\u0001\t\u000b-!\u0001\u0019\u0001\u000e\t\u000b\u0015\"\u0001\u0019\u0001\u0014\t\u000bQ\"\u0001\u0019A\u001b\u0002\u0007I,h\u000eF\u0001B!\t\u0011\u0005K\u0004\u0002D\u001d:\u0011A)\u0014\b\u0003\u000b2s!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%\u0013\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\f?%\u0011QDH\u0005\u0003\u001fr\tq\u0001]1dW\u0006<W-\u0003\u0002R%\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003\u001fr\t!#\u00193e\u00072,8\u000f^3s\u0013\u0012$v\u000eR1uCR\u0019\u0011)V,\t\u000bY3\u0001\u0019A!\u0002\t\u0011\fG/\u0019\u0005\u00061\u001a\u0001\r!Q\u0001\faJ,G-[2uS>t7\u000f")
public class NumericLiteralAnomalyDetection {
    private final RDD<Triple> originalDataRDD;
    private final DistADConfig config;

    public Dataset<Row> run() {
        Dataset<Row> dataset;
        Dataset<Row> dataset2;
        long startTime = System.currentTimeMillis();
        RDD<Triple> onlyLiteralDataRDD = DistADUtil$.MODULE$.triplesWithNumericLitWithTypeIgnoreEndingWithID(this.originalDataRDD);
        if (this.config.verbose()) {
            DistADLogger$.MODULE$.LOG().info((Object)"Original Data RDD Only with numeric Literals:");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])onlyLiteralDataRDD.take(10))).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                NumericLiteralAnomalyDetection.$anonfun$run$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
        Dataset onlyLiteralDataDataFrame = DistADUtil$.MODULE$.createDFWithConversion(onlyLiteralDataRDD).cache();
        if (this.config.verbose()) {
            DistADLogger$.MODULE$.LOG().info((Object)"Original Data DataFrame Only with numeric Literals:");
            onlyLiteralDataDataFrame.show(false);
        }
        String string = this.config.clusteringMethod();
        String string2 = this.config.BISECTINGKMEANS();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Dataset<Row> dataset3;
            if (this.config.silhouetteMethod()) {
                this.config.numberOfClusters_$eq(DistADUtil$.MODULE$.detectNumberOfClusters((Dataset<Row>)onlyLiteralDataDataFrame, this.config.silhouetteMethodSamplingRate()));
                DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(45).append("Number of optimal cluster for the dataset is ").append(this.config.numberOfClusters()).toString());
            }
            String string4 = this.config.clusteringType();
            String string5 = this.config.PARTIAL();
            String string6 = string4;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                dataset3 = DistADUtil$.MODULE$.calculateBiSectingKmeanClustering(onlyLiteralDataRDD, this.config.numberOfClusters());
            } else {
                String string7 = this.config.FULL();
                String string8 = string4;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    dataset3 = DistADUtil$.MODULE$.calculateBiSectingKmeanClustering(this.originalDataRDD, this.config.numberOfClusters());
                } else {
                    throw new MatchError((Object)string4);
                }
            }
            Dataset<Row> predictions = dataset3;
            if (this.config.verbose()) {
                DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(36).append("Result of clustering with ").append(this.config.numberOfClusters()).append(" clusters:").toString());
                predictions.show(false);
            }
            dataset2 = this.addClusterIdToData((Dataset<Row>)onlyLiteralDataDataFrame, predictions);
        } else {
            String string9 = this.config.MINHASHLSH();
            String string10 = string;
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                dataset2 = DistADUtil$.MODULE$.calculateMinHashLSHClustering(onlyLiteralDataRDD, this.originalDataRDD, this.config);
            } else {
                throw new MatchError((Object)string);
            }
        }
        Dataset<Row> onlyLiteralDataWithDoubleDataFrameWithClusterId = dataset2;
        if (this.config.verbose()) {
            DistADLogger$.MODULE$.LOG().info((Object)"Add clustering result to data:");
            onlyLiteralDataWithDoubleDataFrameWithClusterId.show(false);
        }
        String string11 = this.config.anomalyDetectionAlgorithm();
        String string12 = this.config.IQR();
        String string13 = string11;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            dataset = DistADUtil$.MODULE$.iqr(onlyLiteralDataWithDoubleDataFrameWithClusterId, this.config.verbose(), this.config.anomalyListSize());
        } else {
            String string14 = this.config.ZSCORE();
            String string15 = string11;
            if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                dataset = DistADUtil$.MODULE$.zscore(onlyLiteralDataWithDoubleDataFrameWithClusterId, this.config.verbose(), this.config.anomalyListSize());
            } else {
                String string16 = this.config.MAD();
                String string17 = string11;
                if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                    dataset = DistADUtil$.MODULE$.mad(onlyLiteralDataWithDoubleDataFrameWithClusterId, this.config.verbose(), this.config.anomalyListSize());
                } else {
                    throw new MatchError((Object)string11);
                }
            }
        }
        Dataset<Row> finalResult = dataset;
        DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(16).append("Operation took: ").append(System.currentTimeMillis() - startTime).toString());
        return finalResult;
    }

    public Dataset<Row> addClusterIdToData(Dataset<Row> data, Dataset<Row> predictions) {
        ObjectRef dataJoined = ObjectRef.create((Object)data.join(predictions, "s").cache());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions.columns())).foreach((Function1 & java.io.Serializable & Serializable)col -> {
            NumericLiteralAnomalyDetection.$anonfun$addClusterIdToData$1(dataJoined, col);
            return BoxedUnit.UNIT;
        });
        return (Dataset)dataJoined.elem;
    }

    public static final /* synthetic */ void $anonfun$run$1(Object x$1) {
        DistADLogger$.MODULE$.LOG().info(x$1);
    }

    public static final /* synthetic */ void $anonfun$addClusterIdToData$1(ObjectRef dataJoined$1, String col) {
        block0: {
            if (col.equals("s") || col.equals("prediction")) break block0;
            dataJoined$1.elem = ((Dataset)dataJoined$1.elem).drop(col);
        }
    }

    public NumericLiteralAnomalyDetection(SparkSession spark, RDD<Triple> originalDataRDD, DistADConfig config) {
        this.originalDataRDD = originalDataRDD;
        this.config = config;
    }
}

